"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _QueryService = _interopRequireDefault(require("../services/QueryService"));
var _TranslateService = _interopRequireDefault(require("../services/TranslateService"));
var _query = require("./query");
var _translate = _interopRequireDefault(require("./translate"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function defineRoutes(router, client, openSearchServiceSetup, dataSourceEnabled, logger) {
  const translateService = new _TranslateService.default(client, dataSourceEnabled, logger);
  (0, _translate.default)(router, translateService, openSearchServiceSetup);
  const queryService = new _QueryService.default(client, dataSourceEnabled, logger);
  (0, _query.registerQueryRoute)(router, queryService);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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