"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
* Copyright OpenSearch Contributors
* SPDX-License-Identifier: Apache-2.0
*/
class CommentsService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "createComment", async (context, req, res) => {
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.createComment', {
          alertId: req.params.alertId,
          body: req.body
        });
        return res.ok({
          body: {
            ok: true,
            resp
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
    _defineProperty(this, "updateComment", async (context, req, res) => {
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.updateComment', {
          commentId: req.params.commentId,
          body: req.body
        });
        return res.ok({
          body: {
            ok: true,
            resp
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
    _defineProperty(this, "searchComments", async (context, req, res) => {
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.searchComments', {
          body: req.body
        });
        const comments = resp.hits.hits.map(({
          _id,
          _source: {
            entity_id,
            content,
            created_time,
            last_updated_time,
            user
          }
        }) => ({
          id: _id,
          entity_id,
          content,
          created_time,
          last_updated_time,
          user
        }));
        return res.ok({
          body: {
            ok: true,
            resp: {
              comments
            }
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
    _defineProperty(this, "deleteComment", async (context, req, res) => {
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.deleteComment', {
          commentId: req.params.commentId
        });
        return res.ok({
          body: {
            ok: true,
            resp
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
  }
}
exports.default = CommentsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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