/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import tr.swing.date.combo.DateItem;

public class PersistenceOutputStream {
    private final ObjectOutputStream out;

    public PersistenceOutputStream(File file) throws IOException {
        this.out = new ObjectOutputStream(new FileOutputStream(file));
    }

    public void writeString(String s) throws IOException {
        if (s == null) {
            this.out.writeByte(0);
        } else {
            this.out.writeInt(s.length());
            this.out.writeBytes(s);
        }
    }

    public void writeStrings(String[] ss) throws IOException {
        if (ss == null) {
            this.out.writeInt(-1);
        } else {
            this.out.writeInt(ss.length);
            for (String s : ss) {
                this.writeString(s);
            }
        }
    }

    public void writeBoolean(boolean b) throws IOException {
        this.out.writeBoolean(b);
    }

    public void writeInt(int i) throws IOException {
        this.out.writeInt(i);
    }

    public void writeLong(long l) throws IOException {
        this.out.writeLong(l);
    }

    public void writeByte(byte b) throws IOException {
        this.out.writeByte(b);
    }

    public void writeBytes(byte[] bs) throws IOException {
        if (bs == null) {
            this.out.writeInt(-1);
        } else {
            this.out.writeInt(bs.length);
            this.out.write(bs);
        }
    }

    public void writeDateItem(DateItem item) throws Exception {
        if (item == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(item.type.id);
            this.writeString(item.label);
            this.writeLong(item.value);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

