/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.modules.Places;

public class TempFileGenerator {
    private static final Logger LOG = Logger.getLogger(TempFileGenerator.class.getName());
    private static final boolean POSIX = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    private static final EnumSet<PosixFilePermission> readWritePosix = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
    private static final EnumSet<PosixFilePermission> readPosix = EnumSet.of(PosixFilePermission.OWNER_READ);
    private static final EnumSet<AclEntryPermission> readOnlyAcl = EnumSet.of(AclEntryPermission.READ_ACL, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_DATA, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.SYNCHRONIZE);
    private static final EnumSet<AclEntryPermission> readWriteAcl = EnumSet.of(AclEntryPermission.READ_DATA, new AclEntryPermission[]{AclEntryPermission.WRITE_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.READ_ACL, AclEntryPermission.WRITE_ACL, AclEntryPermission.SYNCHRONIZE});
    private final boolean readOnly;
    private final String filePrefix;
    private final String fileSufix;
    private final String configPath;

    public TempFileGenerator(String filePrefix, String fileSufix, String configPath, boolean readOnly) {
        this.readOnly = readOnly;
        this.configPath = configPath;
        this.filePrefix = filePrefix;
        this.fileSufix = fileSufix;
    }

    public Path writePropertiesFile(Properties props) throws IOException {
        return this.writeToNewTempFile(w -> props.store(w, ""));
    }

    public Path writeTextFile(String text) throws IOException {
        return this.writeToNewTempFile(w -> w.write(text));
    }

    private Path writeToNewTempFile(WriterConsumer c) throws IOException {
        Path temp = null;
        try {
            temp = this.generateConfigFile();
            this.writeToFile(c, temp);
        }
        catch (IOException ex) {
            this.deleteTempFile(temp);
            throw ex;
        }
        return temp;
    }

    private Path generateConfigFile() throws IOException {
        Path dir = this.generateDirPath();
        if (!Files.isDirectory(dir, LinkOption.NOFOLLOW_LINKS)) {
            Files.createDirectory(dir, new FileAttribute[0]);
        }
        if (POSIX) {
            return this.createFilePosix(dir);
        }
        Path temp = Files.createTempFile(dir, this.filePrefix, this.fileSufix, new FileAttribute[0]);
        this.setFileOwnerAcl(temp, readWriteAcl);
        return temp;
    }

    private void writeToFile(WriterConsumer c, Path filePath) throws IOException {
        try (FileWriter writer = new FileWriter(filePath.toFile(), Charset.defaultCharset());){
            c.accept(writer);
            if (POSIX) {
                this.setFilePermissionPosix(filePath);
            } else if (this.readOnly) {
                DosFileAttributeView attribs = Files.getFileAttributeView(filePath, DosFileAttributeView.class, new LinkOption[0]);
                attribs.setReadOnly(true);
                this.setFileOwnerAcl(filePath, readOnlyAcl);
            } else {
                this.setFileOwnerAcl(filePath, readWriteAcl);
            }
            filePath.toFile().deleteOnExit();
        }
    }

    private void setFileOwnerAcl(Path filePath, Set<AclEntryPermission> permissions) throws IOException {
        AclEntry.Builder aclBuilder;
        AclFileAttributeView acl = Files.getFileAttributeView(filePath, AclFileAttributeView.class, new LinkOption[0]);
        AclEntry ownerEntry = this.findFileOwner(acl);
        if (ownerEntry == null) {
            LOG.info("Owner missing, file:" + filePath.toString());
            aclBuilder = AclEntry.newBuilder().setPrincipal(acl.getOwner()).setType(AclEntryType.ALLOW);
        } else {
            aclBuilder = AclEntry.newBuilder(ownerEntry);
        }
        AclEntry ownerAcl = aclBuilder.setPermissions(permissions).build();
        acl.setAcl(Collections.singletonList(ownerAcl));
    }

    private AclEntry findFileOwner(AclFileAttributeView acl) throws IOException {
        for (AclEntry e : acl.getAcl()) {
            if (!e.principal().equals(acl.getOwner())) continue;
            return e;
        }
        return null;
    }

    private void setFilePermissionPosix(Path temp) throws IOException {
        PosixFileAttributeView attributes = Files.getFileAttributeView(temp, PosixFileAttributeView.class, new LinkOption[0]);
        if (this.readOnly) {
            attributes.setPermissions(readPosix);
        } else {
            attributes.setPermissions(readWritePosix);
        }
    }

    private Path createFilePosix(Path dir) throws IOException {
        FileAttribute<Set<PosixFilePermission>> readWriteAttribs = PosixFilePermissions.asFileAttribute(readWritePosix);
        return Files.createTempFile(dir, this.filePrefix, this.fileSufix, readWriteAttribs);
    }

    private Path generateDirPath() {
        File file = Places.getCacheSubdirectory((String)this.configPath);
        file.deleteOnExit();
        return file.toPath();
    }

    private void deleteTempFile(Path temp) {
        if (temp != null && Files.isRegularFile(temp, LinkOption.NOFOLLOW_LINKS)) {
            try {
                if (POSIX) {
                    PosixFileAttributeView attribs = Files.getFileAttributeView(temp, PosixFileAttributeView.class, new LinkOption[0]);
                    attribs.setPermissions(readWritePosix);
                } else {
                    DosFileAttributeView attribs = Files.getFileAttributeView(temp, DosFileAttributeView.class, new LinkOption[0]);
                    attribs.setReadOnly(false);
                }
                Files.delete(temp);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "deleteTempFile", ex);
            }
        }
    }

    @FunctionalInterface
    private static interface WriterConsumer {
        public void accept(Writer var1) throws IOException;
    }
}

