/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.cloud.oracle.assets.PropertiesGenerator;
import org.netbeans.modules.cloud.oracle.assets.TempFileGenerator;
import org.netbeans.spi.lsp.CommandProvider;

public class OCIPropertiesProvider
implements CommandProvider {
    private static final String GET_DB_CONNECTION = "nbls.db.connection";
    private final TempFileGenerator configFileGenerator = new TempFileGenerator("db-", ".properties", "nbls.db.connection", true);

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        HashMap<String, String> result = new HashMap<String, String>();
        CompletableFuture<Object> ret = new CompletableFuture<Object>();
        Properties dbProps = new Properties();
        DatabaseConnection conn = ConnectionManager.getDefault().getPreferredConnection(true);
        PropertiesGenerator propGen = new PropertiesGenerator(true);
        dbProps.putAll(propGen.getApplication());
        dbProps.putAll(propGen.getBootstrap());
        if (conn != null && dbProps.isEmpty()) {
            dbProps.put("datasources.default.url", conn.getDatabaseURL());
            dbProps.put("datasources.default.username", conn.getUser());
            dbProps.put("datasources.default.password", conn.getPassword());
            dbProps.put("datasources.default.driverClassName", conn.getDriverClass());
            String ocid = (String)conn.getConnectionProperties().get("OCID");
            if (ocid != null && !ocid.isEmpty()) {
                dbProps.put("datasources.default.ocid", ocid);
            }
        }
        if (!dbProps.isEmpty()) {
            try {
                Path temp = this.configFileGenerator.writePropertiesFile(dbProps);
                result.put("MICRONAUT_CONFIG_FILES", temp.toAbsolutePath().toString());
            }
            catch (IOException ex) {
                ret.completeExceptionally(ex);
                return ret;
            }
        }
        ret.complete(result);
        return ret;
    }

    public Set<String> getCommands() {
        return Collections.singleton(GET_DB_CONNECTION);
    }
}

