/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class ZipUtil {
    private static final int READ_BUF_SIZE = 65536;
    private static final int WRITE_BUF_SIZE = 65536;
    private List<UnZipFilter> filters = new ArrayList<UnZipFilter>();

    public void addFilter(UnZipFilter filter) {
        this.filters.add(filter);
    }

    private boolean allow(ZipEntry entry) {
        for (UnZipFilter f : this.filters) {
            if (f.allow(entry)) continue;
            return false;
        }
        return true;
    }

    public void zip(File zipFile, String[] sources, String[] paths) {
        try {
            FileOutputStream dest = new FileOutputStream(zipFile);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            for (int i = 0; i < sources.length; ++i) {
                File f = new File(sources[i]);
                this.addEntry(f, paths[i], out);
            }
            out.close();
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private void addEntry(File file, String path, ZipOutputStream out) throws FileNotFoundException, IOException {
        if (file.isDirectory()) {
            String[] files = file.list();
            for (int i = 0; i < files.length; ++i) {
                File f = new File(file + File.separator + files[i]);
                this.addEntry(f, path + File.separator + file.getName(), out);
            }
        } else {
            int count;
            byte[] data = new byte[65536];
            BufferedInputStream origin = null;
            FileInputStream fi = new FileInputStream(file);
            origin = new BufferedInputStream(fi, 65536);
            ZipEntry entry = new ZipEntry(path + File.separator + file.getName());
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 65536)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unzip(InputStream source, FileObject targetFolderFO, boolean overwrite) throws IOException {
        boolean result = true;
        FileSystem targetFS = targetFolderFO.getFileSystem();
        File targetFolder = FileUtil.toFile((FileObject)targetFolderFO);
        ZipInputStream zip = null;
        try {
            ZipEntry entry;
            final byte[] buffer = new byte[65536];
            final ZipInputStream in = zip = new ZipInputStream(new BufferedInputStream(source, 65536));
            while ((entry = zip.getNextEntry()) != null) {
                if (!this.allow(entry)) continue;
                final File entryFile = new File(targetFolder, entry.getName());
                if (entry.isDirectory()) {
                    if (entryFile.exists()) continue;
                    try {
                        FileObject fileObject = FileUtil.createFolder((File)entryFile);
                        continue;
                    }
                    catch (IOException iox) {
                        throw new RuntimeException("Failed to create folder: " + entryFile.getName() + ".  Terminating archive installation.");
                    }
                }
                if (entryFile.exists() && overwrite && !entryFile.delete()) {
                    throw new RuntimeException("Failed to delete file: " + entryFile.getName() + ".  Terminating archive installation.");
                }
                File parentFile = entryFile.getParentFile();
                if (!parentFile.exists()) {
                    try {
                        FileObject fileObject = FileUtil.createFolder((File)parentFile);
                    }
                    catch (IOException iox) {
                        throw new RuntimeException("Failed to create folder: " + parentFile.getName() + ".  Terminating archive installation.");
                    }
                }
                targetFS.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        FileOutputStream os = null;
                        try {
                            int len;
                            os = new FileOutputStream(entryFile);
                            while ((len = in.read(buffer)) >= 0) {
                                os.write(buffer, 0, len);
                            }
                        }
                        finally {
                            if (os != null) {
                                try {
                                    os.close();
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        }
                    }
                });
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return result;
    }

    public static interface UnZipFilter {
        public boolean allow(ZipEntry var1);
    }
}

