/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.impl.MultiModule;
import org.netbeans.modules.java.api.common.util.CommonModuleUtils;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

final class MultiModuleUnitTestsCompilerOptionsQueryImpl
implements CompilerOptionsQueryImplementation {
    private static final Logger LOG = Logger.getLogger(MultiModuleUnitTestsCompilerOptionsQueryImpl.class.getName());
    private final Project project;
    private final MultiModule sourceModules;
    private final MultiModule testModules;
    private final AtomicReference<CompilerOptionsQueryImplementation.Result> result;

    MultiModuleUnitTestsCompilerOptionsQueryImpl(@NonNull Project project, @NonNull MultiModule sourceModules, @NonNull MultiModule testModules) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"sourceModules", (Object)sourceModules);
        Parameters.notNull((CharSequence)"testModules", (Object)testModules);
        this.project = project;
        this.sourceModules = sourceModules;
        this.testModules = testModules;
        this.result = new AtomicReference();
    }

    @CheckForNull
    public CompilerOptionsQueryImplementation.Result getOptions(FileObject file) {
        CompilerOptionsQueryImplementation.Result res = null;
        if (this.testModules.getModuleName(file) != null && (res = this.result.get()) == null && !this.result.compareAndSet(null, res = new ResultImpl(this.project, this.sourceModules, this.testModules))) {
            res = this.result.get();
        }
        return res;
    }

    private static final class ResultImpl
    extends CompilerOptionsQueryImplementation.Result
    implements ChangeListener,
    PropertyChangeListener,
    FileChangeListener {
        private static final String MODULE_INFO = "module-info.java";
        private final MultiModule sourceModules;
        private final MultiModule testModules;
        private final SourceLevelQuery.Result slRes;
        private final ChangeSupport listeners;
        private List<String> cache;
        private final Collection<Pair<ClassPath, PropertyChangeListener>> currentCps;
        private final Set<File> currentModuleInfos;

        ResultImpl(@NonNull Project project, @NonNull MultiModule sourceModules, @NonNull MultiModule testModules) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"sourceModules", (Object)sourceModules);
            Parameters.notNull((CharSequence)"testModules", (Object)testModules);
            this.sourceModules = sourceModules;
            this.testModules = testModules;
            this.slRes = SourceLevelQuery.getSourceLevel2((FileObject)project.getProjectDirectory());
            this.listeners = new ChangeSupport((Object)this);
            this.sourceModules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.sourceModules));
            this.testModules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.testModules));
            this.currentCps = new ArrayList<Pair<ClassPath, PropertyChangeListener>>();
            this.currentModuleInfos = new HashSet<File>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends String> getArguments() {
            List<String> res;
            ResultImpl resultImpl = this;
            synchronized (resultImpl) {
                res = this.cache;
            }
            if (res == null) {
                ArrayList<String> options = new ArrayList<String>();
                Optional<SpecificationVersion> hasModules = Optional.ofNullable(this.slRes.getSourceLevel()).map(v -> new SpecificationVersion(v)).filter(v -> CommonModuleUtils.JDK9.compareTo(v) <= 0);
                HashSet moduleInfosToListenOn = new HashSet();
                ArrayList cpsToListenOn = new ArrayList();
                if (hasModules.isPresent()) {
                    Collection<? extends String> allModules = this.testModules.getModuleNames();
                    List<Map<String, List<File>>> modulesByType = this.classifyModules(allModules, moduleInfosToListenOn, cpsToListenOn);
                    Map<String, List<File>> realModules = modulesByType.get(0);
                    Map<String, List<File>> modulePatches = modulesByType.get(1);
                    Map<String, List<File>> invalidModules = modulesByType.get(2);
                    modulePatches.entrySet().stream().forEach(e -> {
                        String m = (String)e.getKey();
                        List path = (List)e.getValue();
                        if (!path.isEmpty()) {
                            options.add("--patch-module");
                            String testSourcePath = path.stream().map(f -> f.getAbsolutePath()).collect(Collectors.joining(":"));
                            options.add(String.format("%s=%s", m, testSourcePath));
                        }
                    });
                    String modList = allModules.stream().sorted().collect(Collectors.joining(","));
                    if (!modList.isEmpty()) {
                        options.add("--add-modules");
                        options.add(modList);
                    }
                    allModules.stream().filter(m -> !invalidModules.containsKey(m)).forEach(m -> {
                        options.add("--add-reads");
                        options.add(String.format("%s=ALL-UNNAMED", m));
                    });
                }
                res = Collections.unmodifiableList(options);
                ResultImpl resultImpl2 = this;
                synchronized (resultImpl2) {
                    Iterator<Object> it = this.currentCps.iterator();
                    while (it.hasNext()) {
                        Pair<ClassPath, PropertyChangeListener> p = it.next();
                        ((ClassPath)p.first()).removePropertyChangeListener((PropertyChangeListener)p.second());
                        it.remove();
                    }
                    assert (this.currentCps.isEmpty());
                    for (ClassPath cp : cpsToListenOn) {
                        PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)cp);
                        cp.addPropertyChangeListener(pcl);
                        this.currentCps.add((Pair<ClassPath, PropertyChangeListener>)Pair.of((Object)cp, (Object)pcl));
                    }
                    HashSet<File> toRemove = new HashSet<File>(this.currentModuleInfos);
                    toRemove.removeAll(moduleInfosToListenOn);
                    moduleInfosToListenOn.removeAll(this.currentModuleInfos);
                    for (File f : toRemove) {
                        ResultImpl.safeRemoveFileListener(f, this);
                        this.currentModuleInfos.remove(f);
                    }
                    for (File f : moduleInfosToListenOn) {
                        ResultImpl.safeAddFileListener(f, this);
                        this.currentModuleInfos.add(f);
                    }
                    if (this.cache == null) {
                        this.cache = res;
                    } else {
                        res = this.cache;
                    }
                }
            }
            return res;
        }

        public void addChangeListener(@NonNull ChangeListener listener) {
            this.listeners.addChangeListener(listener);
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            this.listeners.removeChangeListener(listener);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.reset();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            switch (evt.getPropertyName()) {
                case "modules": {
                    if (source != this.testModules && source != this.sourceModules) break;
                    this.reset();
                    break;
                }
                case "entries": {
                    if (!this.isActiveClassPath(source)) break;
                    this.reset();
                }
            }
        }

        public void fileDataCreated(FileEvent fe) {
            this.reset();
        }

        public void fileDeleted(FileEvent fe) {
            this.reset();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.reset();
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        private synchronized boolean isActiveClassPath(Object source) {
            for (Pair<ClassPath, PropertyChangeListener> p : this.currentCps) {
                if (p.first() != source) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            ResultImpl resultImpl = this;
            synchronized (resultImpl) {
                this.cache = null;
            }
            this.listeners.fireChange();
        }

        private static void safeAddFileListener(@NonNull File file, @NonNull FileChangeListener listener) {
            try {
                FileUtil.addFileChangeListener((FileChangeListener)listener, (File)file);
            }
            catch (IllegalArgumentException e) {
                LOG.log(Level.WARNING, "Cannot add listener to: {0}", file);
            }
        }

        private static void safeRemoveFileListener(@NonNull File file, @NonNull FileChangeListener listener) {
            try {
                FileUtil.removeFileChangeListener((FileChangeListener)listener, (File)file);
            }
            catch (IllegalArgumentException e) {
                LOG.log(Level.WARNING, "Cannot remove listener from: {0}", file);
            }
        }

        private List<Map<String, List<File>>> classifyModules(@NonNull Collection<? extends String> toClassify, @NonNull Set<? super File> moduleInfosToListenOn, @NonNull Collection<? super ClassPath> cpsToListenOn) {
            HashMap mods = new HashMap();
            HashMap ptchs = new HashMap();
            HashMap invd = new HashMap();
            for (String string : toClassify) {
                ClassPath cp = this.testModules.getModuleSources(string);
                if (cp == null) {
                    invd.put(string, Collections.emptyList());
                    continue;
                }
                FileObject modInfo = cp.findResource(MODULE_INFO);
                HashMap<Object, Object> into = modInfo != null && modInfo.isData() ? mods : (this.sourceModules.getModuleNames().contains(string) ? ptchs : invd);
                List files = cp.entries().stream().map(e -> FileUtil.archiveOrDirForURL((URL)e.getURL())).filter(f -> f != null).collect(Collectors.toList());
                into.put(string, files);
                files.stream().map(f -> new File((File)f, MODULE_INFO)).forEach(moduleInfosToListenOn::add);
                cpsToListenOn.add((ClassPath)cp);
            }
            return Arrays.asList(mods, ptchs, invd);
        }
    }
}

