/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.transform;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AnyPatternTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseLabelTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ConstantCaseLabelTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DeconstructionPatternTree;
import com.sun.source.tree.DefaultCaseLabelTree;
import com.sun.source.tree.DirectiveTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.OpensTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PatternCaseLabelTree;
import com.sun.source.tree.PatternTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ProvidesTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.UsesTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.tree.YieldTree;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.source.GeneratorUtilitiesAccessor;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.QualIdentTree;
import org.netbeans.modules.java.source.builder.TreeFactory;
import org.netbeans.modules.java.source.pretty.ImportAnalysis2;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.save.ElementOverlay;
import org.netbeans.modules.java.source.transform.TreeHelpers;

public class ImmutableTreeTranslator
implements TreeVisitor<Tree, Object> {
    public Element currentSym;
    protected TreeFactory make;
    protected Elements elements;
    protected CommentHandler comments;
    protected ASTService model;
    private ElementOverlay overlay;
    private ImportAnalysis2 importAnalysis;
    private Map<Tree, Object> tree2Tag;
    private TreeMaker tmaker;
    private WorkingCopy copy;

    public ImmutableTreeTranslator(WorkingCopy copy) {
        this.copy = copy;
        if (copy != null) {
            this.tmaker = copy.getTreeMaker();
        }
    }

    public void attach(Context context, ImportAnalysis2 importAnalysis, Map<Tree, Object> tree2Tag) {
        this.make = TreeFactory.instance(context);
        this.elements = JavacElements.instance(context);
        this.comments = CommentHandlerService.instance(context);
        this.model = ASTService.instance(context);
        this.overlay = context.get(ElementOverlay.class);
        this.importAnalysis = importAnalysis;
        this.tree2Tag = tree2Tag;
    }

    public void release() {
        this.make = null;
        this.comments = null;
        this.model = null;
        this.overlay = null;
        this.importAnalysis = null;
    }

    public Tree translate(Tree tree) {
        if (tree == null) {
            return null;
        }
        Tree t = tree.accept(this, null);
        if (this.tree2Tag != null && tree != t && this.tmaker != null) {
            t = this.tmaker.asReplacementOf(t, tree, true);
            this.tree2Tag.put(t, this.tree2Tag.get(tree));
        }
        return t;
    }

    public <T extends Tree> T translateClassRef(T tree) {
        return (T)this.translate(tree);
    }

    public final <T extends Tree> List<T> translateClassRef(List<T> trees) {
        if (trees == null || trees.isEmpty()) {
            return trees;
        }
        ArrayList<Tree> newTrees = new ArrayList<Tree>();
        boolean changed = false;
        for (Tree t : trees) {
            Tree newT = this.translateClassRef(t);
            if (newT != t) {
                changed = true;
            }
            if (newT == null) continue;
            newTrees.add(newT);
        }
        return changed ? newTrees : trees;
    }

    public <T extends Tree> T translateStable(T tree) {
        Tree t2 = this.translate(tree);
        if (t2 != null && t2.getClass() != tree.getClass() && t2.getClass() != tree.getClass() && (tree.getClass() != QualIdentTree.class || t2.getKind() != Tree.Kind.IDENTIFIER && t2.getKind() != Tree.Kind.MEMBER_SELECT)) {
            System.err.println("Rewrite stability problem: got " + t2.getClass() + "\n\t\texpected " + tree.getClass());
            return tree;
        }
        return (T)t2;
    }

    public static boolean isEmpty(Tree t) {
        if (t == null) {
            return true;
        }
        switch (t.getKind()) {
            default: {
                return false;
            }
            case BLOCK: {
                for (StatementTree statementTree : ((BlockTree)t).getStatements()) {
                    if (ImmutableTreeTranslator.isEmpty(statementTree)) continue;
                    return false;
                }
                return true;
            }
            case EMPTY_STATEMENT: 
        }
        return true;
    }

    public <T extends Tree> List<T> translate(List<T> trees) {
        if (trees == null || trees.isEmpty()) {
            return trees;
        }
        ArrayList<Tree> newTrees = new ArrayList<Tree>();
        boolean changed = false;
        for (Tree t : trees) {
            Tree newT = this.translate(t);
            if (newT != t) {
                changed = true;
            }
            if (newT == null) continue;
            newTrees.add(newT);
        }
        return changed ? newTrees : trees;
    }

    public <T extends Tree> List<T> translateStable(List<T> trees) {
        if (trees == null || trees.isEmpty()) {
            return trees;
        }
        ArrayList<Tree> newTrees = new ArrayList<Tree>();
        boolean changed = false;
        for (Tree t : trees) {
            Tree newT = this.translateStable(t);
            if (newT != t) {
                changed = true;
            }
            if (newT == null) continue;
            newTrees.add(newT);
        }
        return changed ? newTrees : trees;
    }

    protected <T extends Tree> List<T> optimize(List<T> trees) {
        if (trees == null || trees.isEmpty()) {
            return trees;
        }
        ArrayList<T> newTrees = new ArrayList<T>();
        for (Tree t : trees) {
            if (t == null || ImmutableTreeTranslator.isEmpty(t)) continue;
            switch (t.getKind()) {
                case RETURN: 
                case THROW: 
                case BREAK: 
                case CONTINUE: {
                    newTrees.add(t);
                    return ImmutableTreeTranslator.equals(trees, newTrees) ? trees : newTrees;
                }
            }
            newTrees.add(t);
        }
        return ImmutableTreeTranslator.equals(trees, newTrees) ? trees : newTrees;
    }

    private static <T extends Tree> boolean equals(List<T> list1, List<T> list2) {
        int n = list1.size();
        if (n != list2.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (list1.get(i) == list2.get(i)) continue;
            return false;
        }
        return true;
    }

    public final void copyCommentTo(Tree from1, Tree from2, Tree to) {
        this.copyCommentTo(from1, to);
        if (from1 != from2) {
            this.copyCommentTo(from2, to);
        }
    }

    public final void copyCommentTo(Tree from, Tree to) {
        this.comments.copyComments(from, to);
    }

    int size(List<?> list) {
        return list == null ? 0 : list.size();
    }

    private void copyPosTo(Tree from, Tree to) {
        this.model.setPos(to, this.model.getPos(from));
    }

    private boolean safeEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree tree, Object p) {
        CompilationUnitTree result = this.rewriteChildren(tree);
        return result;
    }

    @Override
    public Tree visitPackage(PackageTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitImport(ImportTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitClass(ClassTree tree, Object p) {
        Element oldSym = this.currentSym;
        this.importAnalysis.classEntered(tree);
        this.currentSym = this.model.getElement(tree);
        ClassTree result = this.rewriteChildren(tree);
        this.importAnalysis.classLeft();
        this.currentSym = oldSym;
        return result;
    }

    @Override
    public Tree visitMethod(MethodTree tree, Object p) {
        Element oldSym = this.currentSym;
        this.currentSym = this.model.getElement(tree);
        MethodTree result = this.rewriteChildren(tree);
        this.currentSym = oldSym;
        return result;
    }

    @Override
    public Tree visitVariable(VariableTree tree, Object p) {
        Element oldSym = this.currentSym;
        this.currentSym = this.model.getElement(tree);
        VariableTree result = this.rewriteChildren(tree);
        this.currentSym = oldSym;
        return result;
    }

    @Override
    public Tree visitEmptyStatement(EmptyStatementTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitBlock(BlockTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitUnionType(UnionTypeTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitDoWhileLoop(DoWhileLoopTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitWhileLoop(WhileLoopTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitForLoop(ForLoopTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitEnhancedForLoop(EnhancedForLoopTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitLabeledStatement(LabeledStatementTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitLambdaExpression(LambdaExpressionTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitSwitch(SwitchTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitCase(CaseTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitSynchronized(SynchronizedTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitTry(TryTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitCatch(CatchTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitConditionalExpression(ConditionalExpressionTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitIf(IfTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitExpressionStatement(ExpressionStatementTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitBreak(BreakTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitContinue(ContinueTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitReturn(ReturnTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitThrow(ThrowTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitAssert(AssertTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitNewClass(NewClassTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitNewArray(NewArrayTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitParenthesized(ParenthesizedTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitAssignment(AssignmentTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitCompoundAssignment(CompoundAssignmentTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitUnary(UnaryTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitBinary(BinaryTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitTypeCast(TypeCastTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitInstanceOf(InstanceOfTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitIntersectionType(IntersectionTypeTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitArrayAccess(ArrayAccessTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitMemberReference(MemberReferenceTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree tree, Object p) {
        if (tree instanceof QualIdentTree) {
            QualIdentTree qit = (QualIdentTree)tree;
            Element el = qit.sym;
            if (el == null) {
                el = this.overlay.resolve(this.model, this.elements, qit.getFQN());
            } else if (el.getKind().isClass() || el.getKind().isInterface() || el.getKind() == ElementKind.PACKAGE) {
                el = this.overlay.resolve(this.model, this.elements, ((QualifiedNameable)el).getQualifiedName().toString(), el, this.elements.getModuleOf(el));
            }
            return this.importAnalysis.resolveImport(tree, el);
        }
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitIdentifier(IdentifierTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitLiteral(LiteralTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitPrimitiveType(PrimitiveTypeTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitArrayType(ArrayTypeTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitParameterizedType(ParameterizedTypeTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitTypeParameter(TypeParameterTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitWildcard(WildcardTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitAnnotatedType(AnnotatedTypeTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitAnnotation(AnnotationTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitModifiers(ModifiersTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitErroneous(ErroneousTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitModule(ModuleTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitExports(ExportsTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitOpens(OpensTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitProvides(ProvidesTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitRequires(RequiresTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitUses(UsesTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitBindingPattern(BindingPatternTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitDefaultCaseLabel(DefaultCaseLabelTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitConstantCaseLabel(ConstantCaseLabelTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitPatternCaseLabel(PatternCaseLabelTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitDeconstructionPattern(DeconstructionPatternTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitSwitchExpression(SwitchExpressionTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitYield(YieldTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitAnyPattern(AnyPatternTree tree, Object p) {
        return this.rewriteChildren(tree);
    }

    @Override
    public Tree visitOther(Tree tree, Object p) {
        throw new Error("Tree not overloaded: " + tree);
    }

    protected final CompilationUnitTree rewriteChildren(CompilationUnitTree tree) {
        ExpressionTree pid = (ExpressionTree)this.translate(tree.getPackageName());
        this.importAnalysis.setCompilationUnit(tree);
        this.importAnalysis.setPackage(tree.getPackageName());
        List<? extends ImportTree> imps = this.translate(tree.getImports());
        this.importAnalysis.setImports(imps);
        List<? extends AnnotationTree> annotations = this.translate(tree.getPackageAnnotations());
        List<? extends Tree> types = this.translate(TreeHelpers.getCombinedTopLevelDecls(tree));
        Set<? extends Element> newImports = this.importAnalysis.getImports();
        if (this.copy != null && newImports != null && !newImports.isEmpty()) {
            imps = GeneratorUtilitiesAccessor.getInstance().addImports(GeneratorUtilities.get(this.copy), tree, imps, newImports).getImports();
        }
        if (!(annotations.equals(tree.getPackageAnnotations()) && pid == tree.getPackageName() && imps.equals(tree.getImports()) && types.equals(tree.getTypeDecls()))) {
            CompilationUnitTree n = this.make.CompilationUnit(annotations, pid, imps, types, tree.getSourceFile());
            this.model.setElement(n, this.model.getElement(tree));
            this.copyCommentTo(tree, n);
            this.model.setPos(n, this.model.getPos(tree));
            tree = n;
        }
        return tree;
    }

    protected final PackageTree rewriteChildren(PackageTree tree) {
        List<? extends AnnotationTree> annotations = this.translate(tree.getAnnotations());
        ExpressionTree pid = (ExpressionTree)this.translate(tree.getPackageName());
        if (pid != tree.getPackageName() || !annotations.equals(tree.getAnnotations())) {
            PackageTree n = this.make.Package(annotations, pid);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final ImportTree rewriteChildren(ImportTree tree) {
        Tree qualid = this.translateClassRef(tree.getQualifiedIdentifier());
        if (qualid == tree.getQualifiedIdentifier()) {
            qualid = this.translate(tree.getQualifiedIdentifier());
        }
        if (qualid != tree.getQualifiedIdentifier()) {
            ImportTree n = this.make.Import(qualid, tree.isStatic());
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final ClassTree rewriteChildren(ClassTree tree) {
        boolean typeChanged;
        ModifiersTree mods = (ModifiersTree)this.translate(tree.getModifiers());
        List<? extends TypeParameterTree> typarams = this.translateStable(tree.getTypeParameters());
        Tree extending = this.translateClassRef(tree.getExtendsClause());
        List<? extends Tree> implementing = this.translateClassRef(tree.getImplementsClause());
        this.importAnalysis.enterVisibleThroughClasses(tree);
        List<? extends Tree> defs = this.translate(tree.getMembers());
        boolean bl = typeChanged = !typarams.equals(tree.getTypeParameters()) || extending != tree.getExtendsClause() || !implementing.equals(tree.getImplementsClause());
        if (typeChanged || mods != tree.getModifiers() || !defs.equals(tree.getMembers())) {
            ClassTree n = this.make.Class(mods, tree.getSimpleName(), typarams, extending, implementing, defs);
            if (!typeChanged) {
                this.model.setElement(n, this.model.getElement(tree));
                this.model.setType(n, this.model.getType(tree));
            }
            this.copyCommentTo(tree, n);
            if (tree.getMembers().size() == defs.size()) {
                this.model.setPos(n, this.model.getPos(tree));
            } else {
                this.copyPosTo(tree, n);
            }
            tree = n;
        }
        return tree;
    }

    protected final MethodTree rewriteChildren(MethodTree tree) {
        ModifiersTree mods = (ModifiersTree)this.translate(tree.getModifiers());
        ExpressionTree restype = (ExpressionTree)this.translateClassRef(tree.getReturnType());
        List<? extends TypeParameterTree> typarams = this.translateStable(tree.getTypeParameters());
        List<? extends VariableTree> params = this.translateStable(tree.getParameters());
        List<? extends ExpressionTree> thrown = this.translate(tree.getThrows());
        ExpressionTree defaultValue = (ExpressionTree)this.translate(tree.getDefaultValue());
        BlockTree body = (BlockTree)this.translate(tree.getBody());
        if (!(restype == tree.getReturnType() && typarams.equals(tree.getTypeParameters()) && params.equals(tree.getParameters()) && thrown.equals(tree.getThrows()) && mods == tree.getModifiers() && defaultValue == tree.getDefaultValue() && body == tree.getBody())) {
            if ((((JCTree.JCModifiers)mods).flags & 0x1000000000L) != 0L) {
                mods = this.make.Modifiers(((JCTree.JCModifiers)mods).flags & 0xFFFFFFEFFFFFFFFFL, mods.getAnnotations());
            }
            MethodTree n = this.make.Method(mods, tree.getName().toString(), restype, typarams, params, thrown, body, defaultValue);
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final VariableTree rewriteChildren(VariableTree tree) {
        ModifiersTree mods = (ModifiersTree)this.translate(tree.getModifiers());
        ExpressionTree vartype = (ExpressionTree)this.translateClassRef(tree.getType());
        ExpressionTree init = (ExpressionTree)this.translate(tree.getInitializer());
        if (vartype != tree.getType() || mods != tree.getModifiers() || init != tree.getInitializer()) {
            VariableTree n = this.make.Variable(mods, tree.getName().toString(), vartype, init);
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final EmptyStatementTree rewriteChildren(EmptyStatementTree tree) {
        return tree;
    }

    protected final BlockTree rewriteChildren(BlockTree tree) {
        List<? extends StatementTree> oldStats = tree.getStatements();
        List<? extends StatementTree> newStats = this.translate(oldStats);
        if (!newStats.equals(oldStats)) {
            BlockTree n = this.make.Block(newStats, tree.isStatic());
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            if (newStats.size() == oldStats.size() && (oldStats.size() <= 0 || newStats.size() <= 0 || oldStats.get(0) == newStats.get(0) || this.model.getPos(oldStats.get(0)) >= 0 && this.model.getPos(newStats.get(0)) >= 0)) {
                this.copyPosTo(tree, n);
            }
            tree = n;
        }
        return tree;
    }

    protected final UnionTypeTree rewriteChildren(UnionTypeTree tree) {
        List<? extends Tree> newComponents = this.translate(tree.getTypeAlternatives());
        if (newComponents != tree.getTypeAlternatives()) {
            UnionTypeTree n = this.make.UnionType(newComponents);
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final DoWhileLoopTree rewriteChildren(DoWhileLoopTree tree) {
        StatementTree body = (StatementTree)this.translate(tree.getStatement());
        ExpressionTree cond = (ExpressionTree)this.translate(tree.getCondition());
        if (body != tree.getStatement() || cond != tree.getCondition()) {
            DoWhileLoopTree n = this.make.DoWhileLoop(cond, body);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final WhileLoopTree rewriteChildren(WhileLoopTree tree) {
        ExpressionTree cond = (ExpressionTree)this.translate(tree.getCondition());
        StatementTree body = (StatementTree)this.translate(tree.getStatement());
        if (cond != tree.getCondition() || body != tree.getStatement()) {
            WhileLoopTree n = this.make.WhileLoop(cond, body);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final ForLoopTree rewriteChildren(ForLoopTree tree) {
        List<? extends StatementTree> init = this.translate(tree.getInitializer());
        ExpressionTree cond = (ExpressionTree)this.translate(tree.getCondition());
        List<? extends ExpressionStatementTree> step = this.translate(tree.getUpdate());
        StatementTree body = (StatementTree)this.translate(tree.getStatement());
        if (!init.equals(tree.getInitializer()) || cond != tree.getCondition() || !step.equals(tree.getUpdate()) || body != tree.getStatement()) {
            if (init != tree.getInitializer()) {
                init = this.optimize(init);
            }
            if (step != tree.getUpdate()) {
                step = this.optimize(step);
            }
            ForLoopTree n = this.make.ForLoop(init, cond, step, body);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            if (tree.getInitializer().size() != init.size() || tree.getUpdate().size() != step.size()) {
                this.model.setPos(tree, -2);
            } else {
                this.copyPosTo(tree, n);
            }
            tree = n;
        }
        return tree;
    }

    protected final EnhancedForLoopTree rewriteChildren(EnhancedForLoopTree tree) {
        VariableTree var = (VariableTree)this.translate(tree.getVariable());
        ExpressionTree expr = (ExpressionTree)this.translate(tree.getExpression());
        StatementTree body = (StatementTree)this.translate(tree.getStatement());
        if (var != tree.getVariable() || expr != tree.getExpression() || body != tree.getStatement()) {
            EnhancedForLoopTree n = this.make.EnhancedForLoop(var, expr, body);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final LabeledStatementTree rewriteChildren(LabeledStatementTree tree) {
        StatementTree body = (StatementTree)this.translate(tree.getStatement());
        if (body != tree.getStatement()) {
            LabeledStatementTree n = this.make.LabeledStatement(tree.getLabel(), body);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final LambdaExpressionTree rewriteChildren(LambdaExpressionTree tree) {
        Tree body = this.translate(tree.getBody());
        List<? extends VariableTree> parameters = this.translate(tree.getParameters());
        if (body != tree.getBody() || parameters != tree.getParameters()) {
            LambdaExpressionTree n = this.make.LambdaExpression(parameters, body);
            ((JCTree.JCLambda)n).paramKind = ((JCTree.JCLambda)tree).paramKind;
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final SwitchTree rewriteChildren(SwitchTree tree) {
        ExpressionTree selector = (ExpressionTree)this.translate(tree.getExpression());
        List<? extends CaseTree> cases = this.translateStable(tree.getCases());
        if (selector != tree.getExpression() || !cases.equals(tree.getCases())) {
            SwitchTree n = this.make.Switch(selector, cases);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final CaseTree rewriteChildren(CaseTree tree) {
        Tree body = tree.getBody();
        List<? extends CaseLabelTree> labels = tree.getLabels();
        if (body == null) {
            List<? extends CaseLabelTree> pats = this.translate(labels);
            ExpressionTree newGuard = (ExpressionTree)this.translate(tree.getGuard());
            List<? extends StatementTree> stats = this.translate(tree.getStatements());
            if (!pats.equals(labels) || tree.getGuard() != newGuard || !stats.equals(tree.getStatements())) {
                if (stats != tree.getStatements()) {
                    stats = this.optimize(stats);
                }
                CaseTree n = this.make.CaseMultiplePatterns(pats, newGuard, stats);
                this.model.setType(n, this.model.getType(tree));
                this.copyCommentTo(tree, n);
                this.copyPosTo(tree, n);
                tree = n;
            }
        } else {
            List<? extends CaseLabelTree> pats = this.translate(labels);
            ExpressionTree newGuard = (ExpressionTree)this.translate(tree.getGuard());
            Tree nueBody = this.translate(body);
            if (!pats.equals(labels) || tree.getGuard() != newGuard || body != nueBody) {
                CaseTree n = this.make.CaseMultiplePatterns(pats, newGuard, nueBody);
                this.model.setType(n, this.model.getType(tree));
                this.copyCommentTo(tree, n);
                this.copyPosTo(tree, n);
                tree = n;
            }
        }
        return tree;
    }

    protected final SynchronizedTree rewriteChildren(SynchronizedTree tree) {
        ExpressionTree lock = (ExpressionTree)this.translate(tree.getExpression());
        BlockTree body = (BlockTree)this.translate(tree.getBlock());
        if (lock != tree.getExpression() || body != tree.getBlock()) {
            SynchronizedTree n = this.make.Synchronized(lock, body);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final TryTree rewriteChildren(TryTree tree) {
        List<? extends Tree> resources = this.translate(tree.getResources());
        BlockTree body = (BlockTree)this.translate(tree.getBlock());
        List<? extends CatchTree> catches = this.translateStable(tree.getCatches());
        BlockTree finalizer = (BlockTree)this.translate(tree.getFinallyBlock());
        if (body != tree.getBlock() || !catches.equals(tree.getCatches()) || finalizer != tree.getFinallyBlock() || !resources.equals(tree.getResources())) {
            TryTree n = this.make.Try(resources, body, catches, finalizer);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final CatchTree rewriteChildren(CatchTree tree) {
        VariableTree param = this.translateStable(tree.getParameter());
        BlockTree body = (BlockTree)this.translate(tree.getBlock());
        if (param != tree.getParameter() || body != tree.getBlock()) {
            CatchTree n = this.make.Catch(param, body);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final ConditionalExpressionTree rewriteChildren(ConditionalExpressionTree tree) {
        ExpressionTree cond = (ExpressionTree)this.translate(tree.getCondition());
        ExpressionTree truepart = (ExpressionTree)this.translate(tree.getTrueExpression());
        ExpressionTree falsepart = (ExpressionTree)this.translate(tree.getFalseExpression());
        if (cond != tree.getCondition() || truepart != tree.getTrueExpression() || falsepart != tree.getFalseExpression()) {
            ConditionalExpressionTree n = this.make.ConditionalExpression(cond, truepart, falsepart);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final IfTree rewriteChildren(IfTree tree) {
        ExpressionTree cond = (ExpressionTree)this.translate(tree.getCondition());
        StatementTree thenpart = (StatementTree)this.translate(tree.getThenStatement());
        StatementTree elsepart = (StatementTree)this.translate(tree.getElseStatement());
        if (cond != tree.getCondition() || thenpart != tree.getThenStatement() || elsepart != tree.getElseStatement()) {
            IfTree n = this.make.If(cond, thenpart, elsepart);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final ExpressionStatementTree rewriteChildren(ExpressionStatementTree tree) {
        ExpressionTree expr = (ExpressionTree)this.translate(tree.getExpression());
        if (expr != tree.getExpression()) {
            ExpressionStatementTree n = this.make.ExpressionStatement(expr);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final BreakTree rewriteChildren(BreakTree tree) {
        return tree;
    }

    protected final ContinueTree rewriteChildren(ContinueTree tree) {
        return tree;
    }

    protected final ReturnTree rewriteChildren(ReturnTree tree) {
        ExpressionTree expr = (ExpressionTree)this.translate(tree.getExpression());
        if (expr != tree.getExpression()) {
            ReturnTree n = this.make.Return(expr);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final ThrowTree rewriteChildren(ThrowTree tree) {
        ExpressionTree expr = (ExpressionTree)this.translate(tree.getExpression());
        if (expr != tree.getExpression()) {
            ThrowTree n = this.make.Throw(expr);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final AssertTree rewriteChildren(AssertTree tree) {
        ExpressionTree cond = (ExpressionTree)this.translate(tree.getCondition());
        ExpressionTree detail = (ExpressionTree)this.translate(tree.getDetail());
        if (cond != tree.getCondition() || detail != tree.getDetail()) {
            AssertTree n = this.make.Assert(cond, detail);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final MethodInvocationTree rewriteChildren(MethodInvocationTree tree) {
        List<? extends Tree> typeargs = this.translate(tree.getTypeArguments());
        ExpressionTree meth = (ExpressionTree)this.translate(tree.getMethodSelect());
        List<? extends ExpressionTree> args = this.translate(tree.getArguments());
        if (!typeargs.equals(tree.getTypeArguments()) || meth != tree.getMethodSelect() || !args.equals(tree.getArguments())) {
            if (args != tree.getArguments()) {
                args = this.optimize(args);
            }
            if (typeargs != tree.getTypeArguments()) {
                typeargs = this.optimize(typeargs);
            }
            MethodInvocationTree n = this.make.MethodInvocation(typeargs, meth, args);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            tree = n;
            if (this.size(tree.getTypeArguments()) != this.size(typeargs) && this.size(tree.getArguments()) != this.size(args)) {
                this.model.setPos(tree, -2);
            } else {
                this.copyPosTo(tree, n);
            }
        }
        return tree;
    }

    protected final NewClassTree rewriteChildren(NewClassTree tree) {
        ExpressionTree encl = (ExpressionTree)this.translate(tree.getEnclosingExpression());
        List<? extends Tree> typeargs = this.translate(tree.getTypeArguments());
        ExpressionTree clazz = this.translateClassRef(tree.getIdentifier());
        List<? extends ExpressionTree> args = this.translate(tree.getArguments());
        ClassTree def = this.translateStable(tree.getClassBody());
        if (encl != tree.getEnclosingExpression() || !typeargs.equals(tree.getTypeArguments()) || clazz != tree.getIdentifier() || !args.equals(tree.getArguments()) || def != tree.getClassBody()) {
            if (args != tree.getArguments()) {
                args = this.optimize(args);
            }
            if (typeargs != tree.getTypeArguments()) {
                typeargs = this.optimize(typeargs);
            }
            NewClassTree n = this.make.NewClass(encl, typeargs, clazz, args, def);
            this.model.setElement(n, this.model.getElement(tree));
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            if (this.size(tree.getTypeArguments()) != this.size(typeargs) && this.size(tree.getArguments()) != this.size(args) || def != tree.getClassBody()) {
                this.model.setPos(n, -2);
            } else {
                this.copyPosTo(tree, n);
            }
            tree = n;
        }
        return tree;
    }

    protected final NewArrayTree rewriteChildren(NewArrayTree tree) {
        ExpressionTree elemtype = (ExpressionTree)this.translateClassRef(tree.getType());
        List<? extends ExpressionTree> dims = this.translate(tree.getDimensions());
        List<? extends ExpressionTree> elems = this.translate(tree.getInitializers());
        if (elemtype != tree.getType() || !this.safeEquals(dims, tree.getDimensions()) || !this.safeEquals(elems, tree.getInitializers())) {
            if (elems != tree.getInitializers()) {
                elems = this.optimize(elems);
            }
            if (dims != tree.getDimensions()) {
                dims = this.optimize(dims);
            }
            NewArrayTree n = this.make.NewArray(elemtype, dims, elems);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            tree = n;
            if (this.size(tree.getDimensions()) != this.size(dims) || this.size(tree.getInitializers()) != this.size(elems)) {
                this.model.setPos(tree, -2);
            } else {
                this.copyPosTo(tree, n);
            }
        }
        return tree;
    }

    protected final ParenthesizedTree rewriteChildren(ParenthesizedTree tree) {
        ExpressionTree expr = (ExpressionTree)this.translate(tree.getExpression());
        if (expr != tree.getExpression()) {
            ParenthesizedTree n = this.make.Parenthesized(expr);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final AssignmentTree rewriteChildren(AssignmentTree tree) {
        ExpressionTree lhs = (ExpressionTree)this.translate(tree.getVariable());
        ExpressionTree rhs = (ExpressionTree)this.translate(tree.getExpression());
        if (lhs != tree.getVariable() || rhs != tree.getExpression()) {
            AssignmentTree n = this.make.Assignment(lhs, rhs);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final CompoundAssignmentTree rewriteChildren(CompoundAssignmentTree tree) {
        ExpressionTree lhs = (ExpressionTree)this.translate(tree.getVariable());
        ExpressionTree rhs = (ExpressionTree)this.translate(tree.getExpression());
        if (lhs != tree.getVariable() || rhs != tree.getExpression()) {
            CompoundAssignmentTree n = this.make.CompoundAssignment(tree.getKind(), lhs, rhs);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final UnaryTree rewriteChildren(UnaryTree tree) {
        ExpressionTree arg = (ExpressionTree)this.translate(tree.getExpression());
        if (arg != tree.getExpression()) {
            UnaryTree n = this.make.Unary(tree.getKind(), arg);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final BinaryTree rewriteChildren(BinaryTree tree) {
        ExpressionTree lhs = (ExpressionTree)this.translate(tree.getLeftOperand());
        ExpressionTree rhs = (ExpressionTree)this.translate(tree.getRightOperand());
        if (lhs != tree.getLeftOperand() || rhs != tree.getRightOperand()) {
            BinaryTree n = this.make.Binary(tree.getKind(), lhs, rhs);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final TypeCastTree rewriteChildren(TypeCastTree tree) {
        Tree clazz = this.translateClassRef(tree.getType());
        ExpressionTree expr = (ExpressionTree)this.translate(tree.getExpression());
        if (clazz != tree.getType() || expr != tree.getExpression()) {
            TypeCastTree n = this.make.TypeCast(clazz, expr);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final InstanceOfTree rewriteChildren(InstanceOfTree tree) {
        ExpressionTree expr = (ExpressionTree)this.translate(tree.getExpression());
        Tree origPattern = tree.getPattern();
        if (origPattern == null) {
            origPattern = tree.getType();
        }
        Tree newPattern = this.translate(origPattern);
        if (expr != tree.getExpression() || newPattern != origPattern) {
            InstanceOfTree n = this.make.InstanceOf(expr, newPattern);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final IntersectionTypeTree rewriteChildren(IntersectionTypeTree tree) {
        List<? extends Tree> bounds = this.translate(tree.getBounds());
        if (!this.safeEquals(bounds, tree.getBounds())) {
            IntersectionTypeTree n = this.make.IntersectionType(bounds);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final ArrayAccessTree rewriteChildren(ArrayAccessTree tree) {
        ExpressionTree array = (ExpressionTree)this.translate(tree.getExpression());
        ExpressionTree index = (ExpressionTree)this.translate(tree.getIndex());
        if (array != tree.getExpression() || index != tree.getIndex()) {
            ArrayAccessTree n = this.make.ArrayAccess(array, index);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final MemberSelectTree rewriteChildren(MemberSelectTree tree) {
        ExpressionTree selected = this.translateClassRef(tree.getExpression());
        if (selected != tree.getExpression()) {
            MemberSelectTree n = this.make.MemberSelect(selected, tree.getIdentifier());
            this.model.setElement(n, this.model.getElement(tree));
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final IdentifierTree rewriteChildren(IdentifierTree tree) {
        return tree;
    }

    protected final LiteralTree rewriteChildren(LiteralTree tree) {
        return tree;
    }

    protected final PrimitiveTypeTree rewriteChildren(PrimitiveTypeTree tree) {
        return tree;
    }

    protected final ArrayTypeTree rewriteChildren(ArrayTypeTree tree) {
        ExpressionTree elemtype = (ExpressionTree)this.translateClassRef(tree.getType());
        if (elemtype != tree.getType()) {
            ArrayTypeTree n = this.make.ArrayType(elemtype);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final ParameterizedTypeTree rewriteChildren(ParameterizedTypeTree tree) {
        ExpressionTree clazz = (ExpressionTree)this.translateClassRef(tree.getType());
        List<? extends Tree> arguments = this.translate(tree.getTypeArguments());
        if (clazz != tree.getType() || !arguments.equals(tree.getTypeArguments())) {
            if (arguments != tree.getTypeArguments()) {
                arguments = this.optimize(arguments);
            }
            ParameterizedTypeTree n = this.make.ParameterizedType(clazz, arguments);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            tree = n;
            if (tree.getTypeArguments().size() != arguments.size()) {
                this.model.setPos(tree, -2);
            } else {
                this.copyPosTo(tree, n);
            }
        }
        return tree;
    }

    protected final TypeParameterTree rewriteChildren(TypeParameterTree tree) {
        List<? extends Tree> bounds = this.translate(tree.getBounds());
        if (!bounds.equals(tree.getBounds())) {
            bounds = this.optimize(bounds);
            TypeParameterTree n = this.make.TypeParameter(tree.getName(), bounds);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            tree = n;
            if (tree.getBounds().size() != bounds.size()) {
                this.model.setPos(tree, -2);
            } else {
                this.copyPosTo(tree, n);
            }
        }
        return tree;
    }

    protected final WildcardTree rewriteChildren(WildcardTree tree) {
        Tree type = this.translateClassRef(tree.getBound());
        if (type != tree.getBound()) {
            WildcardTree n = this.make.Wildcard(tree.getKind(), type);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final AnnotatedTypeTree rewriteChildren(AnnotatedTypeTree tree) {
        List<? extends AnnotationTree> annotations = this.translate(tree.getAnnotations());
        ExpressionTree underlyingType = (ExpressionTree)this.translate(tree.getUnderlyingType());
        if (!annotations.equals(tree.getAnnotations()) || underlyingType != tree.getUnderlyingType()) {
            AnnotatedTypeTree n = this.make.AnnotatedType(annotations, underlyingType);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final AnnotationTree rewriteChildren(AnnotationTree tree) {
        Tree annotationType = this.translate(tree.getAnnotationType());
        List<? extends ExpressionTree> args = this.translate(tree.getArguments());
        if (annotationType != tree.getAnnotationType() || !args.equals(tree.getArguments())) {
            if (args != tree.getArguments()) {
                args = this.optimize(args);
            }
            AnnotationTree n = tree.getKind() == Tree.Kind.ANNOTATION ? this.make.Annotation(annotationType, args) : this.make.TypeAnnotation(annotationType, args);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            tree = n;
            if (tree.getArguments().size() != args.size()) {
                this.model.setPos(tree, -2);
            } else {
                this.copyPosTo(tree, n);
            }
        }
        return tree;
    }

    protected final ModifiersTree rewriteChildren(ModifiersTree tree) {
        List<? extends AnnotationTree> annotations = this.translateStable(tree.getAnnotations());
        if (!annotations.equals(tree.getAnnotations())) {
            ModifiersTree n = this.make.Modifiers(tree, annotations);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final ErroneousTree rewriteChildren(ErroneousTree tree) {
        List<? extends Tree> oldErrs = tree.getErrorTrees();
        List<? extends Tree> newErrs = this.translate(oldErrs);
        if (!newErrs.equals(oldErrs)) {
            ErroneousTree n = this.make.Erroneous(newErrs);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected Tree rewriteChildren(MemberReferenceTree node) {
        ExpressionTree qualifierExpression = (ExpressionTree)this.translate(node.getQualifierExpression());
        List<? extends ExpressionTree> typeArguments = this.translate(node.getTypeArguments());
        if (qualifierExpression != node.getQualifierExpression() || typeArguments != node.getTypeArguments()) {
            MemberReferenceTree n = this.make.MemberReference(node.getMode(), node.getName(), qualifierExpression, typeArguments);
            this.model.setType(n, this.model.getType(node));
            this.copyCommentTo(node, n);
            this.copyPosTo(node, n);
            node = n;
        }
        return node;
    }

    private Tree rewriteChildren(ModuleTree tree) {
        ExpressionTree name = (ExpressionTree)this.translate(tree.getName());
        List<? extends AnnotationTree> annotations = this.translate(tree.getAnnotations());
        List<? extends DirectiveTree> directives = this.translate(tree.getDirectives());
        if (name != tree.getName() || !Objects.equals(annotations, tree.getAnnotations()) || !Objects.equals(directives, tree.getDirectives())) {
            ModuleTree n = this.make.Module(this.make.Modifiers(0L, annotations), tree.getModuleType(), name, directives);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    private Tree rewriteChildren(ExportsTree tree) {
        ExpressionTree name = (ExpressionTree)this.translate(tree.getPackageName());
        List<? extends ExpressionTree> moduleNames = this.translate(tree.getModuleNames());
        if (name != tree.getPackageName() || !Objects.equals(moduleNames, tree.getModuleNames())) {
            ExportsTree n = this.make.Exports(name, moduleNames);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    private Tree rewriteChildren(OpensTree tree) {
        ExpressionTree name = (ExpressionTree)this.translate(tree.getPackageName());
        List<? extends ExpressionTree> moduleNames = this.translate(tree.getModuleNames());
        if (name != tree.getPackageName() || !Objects.equals(moduleNames, tree.getModuleNames())) {
            OpensTree n = this.make.Opens(name, moduleNames);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    private Tree rewriteChildren(ProvidesTree tree) {
        ExpressionTree serviceName = (ExpressionTree)this.translate(tree.getServiceName());
        List<? extends ExpressionTree> implNames = this.translate(tree.getImplementationNames());
        if (serviceName != tree.getServiceName() || !Objects.equals(implNames, tree.getImplementationNames())) {
            ProvidesTree n = this.make.Provides(serviceName, implNames);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    private Tree rewriteChildren(RequiresTree tree) {
        ExpressionTree name = (ExpressionTree)this.translate(tree.getModuleName());
        if (name != tree.getModuleName()) {
            RequiresTree n = this.make.Requires(tree.isTransitive(), tree.isStatic(), name);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    private Tree rewriteChildren(UsesTree tree) {
        ExpressionTree name = (ExpressionTree)this.translate(tree.getServiceName());
        if (name != tree.getServiceName()) {
            UsesTree n = this.make.Uses(name);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    private BindingPatternTree rewriteChildren(BindingPatternTree tree) {
        VariableTree newVar = (VariableTree)this.translate(tree.getVariable());
        if (newVar != tree.getVariable()) {
            BindingPatternTree n = this.make.BindingPattern(newVar);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    private DefaultCaseLabelTree rewriteChildren(DefaultCaseLabelTree tree) {
        return tree;
    }

    private ConstantCaseLabelTree rewriteChildren(ConstantCaseLabelTree tree) {
        ExpressionTree newExpression = (ExpressionTree)this.translate(tree.getConstantExpression());
        if (newExpression != tree.getConstantExpression()) {
            ConstantCaseLabelTree n = this.make.ConstantCaseLabel(newExpression);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    private PatternCaseLabelTree rewriteChildren(PatternCaseLabelTree tree) {
        PatternTree newPattern = (PatternTree)this.translate(tree.getPattern());
        if (newPattern != tree.getPattern()) {
            PatternCaseLabelTree n = this.make.PatternCaseLabel(newPattern);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    private DeconstructionPatternTree rewriteChildren(DeconstructionPatternTree tree) {
        ExpressionTree newDeconstructor = (ExpressionTree)this.translate(tree.getDeconstructor());
        List<? extends PatternTree> newNestedPatterns = this.translate(tree.getNestedPatterns());
        if (newDeconstructor != tree.getDeconstructor() || !Objects.equals(newNestedPatterns, tree.getNestedPatterns())) {
            DeconstructionPatternTree n = this.make.DeconstructionPattern(newDeconstructor, newNestedPatterns);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    private AnyPatternTree rewriteChildren(AnyPatternTree tree) {
        return tree;
    }

    protected final SwitchExpressionTree rewriteChildren(SwitchExpressionTree tree) {
        ExpressionTree selector = (ExpressionTree)this.translate(tree.getExpression());
        List<? extends CaseTree> cases = this.translateStable(tree.getCases());
        if (selector != tree.getExpression() || !cases.equals(tree.getCases())) {
            SwitchExpressionTree n = this.make.SwitchExpression(selector, cases);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }

    protected final YieldTree rewriteChildren(YieldTree tree) {
        ExpressionTree value = (ExpressionTree)this.translate(tree.getValue());
        if (value != tree.getValue()) {
            YieldTree n = this.make.Yield(value);
            this.model.setType(n, this.model.getType(tree));
            this.copyCommentTo(tree, n);
            this.copyPosTo(tree, n);
            tree = n;
        }
        return tree;
    }
}

