/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.classpath.AptCacheForSourceQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.CachingFileManager;
import org.netbeans.modules.java.source.parsing.FileManagerTransaction;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.ModuleLocation;
import org.netbeans.modules.java.source.parsing.ModuleSourceFileManager;
import org.netbeans.modules.java.source.parsing.SiblingProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Pair;

public class OutputFileManager
extends CachingFileManager {
    private static final Logger LOG = Logger.getLogger(OutputFileManager.class.getName());
    private final ClassPath scp;
    private final ClassPath apt;
    private final SiblingProvider siblings;
    private final FileManagerTransaction tx;
    private final ModuleSourceFileManager moduleSourceFileManager;
    private Pair<URI, File> cachedClassFolder;
    private Iterable<Set<JavaFileManager.Location>> cachedModuleLocations;

    public OutputFileManager(@NonNull CachingArchiveProvider provider, @NonNull ClassPath outputClassPath, @NonNull ClassPath sourcePath, @NonNull ClassPath aptPath, @NonNull SiblingProvider siblings, @NonNull FileManagerTransaction tx, @NullAllowed ModuleSourceFileManager moduleSFileManager) {
        super(provider, outputClassPath, null, false, true);
        assert (outputClassPath != null);
        assert (sourcePath != null);
        assert (siblings != null);
        assert (tx != null);
        this.scp = sourcePath;
        this.apt = aptPath;
        this.siblings = siblings;
        this.tx = tx;
        this.moduleSourceFileManager = moduleSFileManager;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location l, String packageName, Set<JavaFileObject.Kind> kinds, boolean recursive) {
        Iterable<JavaFileObject> sr;
        if (!ModuleLocation.isInstance(l)) {
            sr = super.list(l, packageName, kinds, recursive);
        } else {
            ModuleLocation.WithExcludes ml = ModuleLocation.WithExcludes.cast(l);
            sr = this.listImpl(l, ml.getModuleEntries(), packageName, kinds, recursive);
        }
        return this.tx.filter(l, packageName, sr);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind, javax.tools.FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        URL siblingURL;
        if (kind != JavaFileObject.Kind.CLASS) {
            throw new IllegalArgumentException();
        }
        String baseName = FileObjects.convertPackage2Folder(className);
        File activeRoot = this.getClassFolderForSource(l, sibling, baseName);
        if (activeRoot == null) {
            activeRoot = this.getClassFolderForApt(l, sibling, baseName);
        }
        if (activeRoot == null && this.siblings.hasSibling() && (activeRoot = this.getClassFolderForSourceImpl(siblingURL = this.siblings.getSibling())) == null) {
            activeRoot = this.getClassFolderForApt(siblingURL);
        }
        if (activeRoot == null) {
            if (this.scp.getRoots().length > 0) {
                LOG.log(Level.WARNING, "No output for class: {0} sibling: {1} srcRoots: {2}", new Object[]{className, sibling, this.scp});
            }
            throw new InvalidSourcePath();
        }
        baseName = className.replace('.', File.separatorChar);
        String nameStr = baseName + ".sig";
        File f = new File(activeRoot, nameStr);
        if (FileObjects.isValidFileName(className)) {
            return this.tx.createFileObject(l, f, activeRoot, null, null);
        }
        LOG.log(Level.WARNING, "Invalid class name: {0} sibling: {1}", new Object[]{className, sibling});
        return FileObjects.nullWriteFileObject(FileObjects.fileFileObject(f, activeRoot, null, null));
    }

    @Override
    public javax.tools.FileObject getFileForOutput(JavaFileManager.Location l, String pkgName, String relativeName, javax.tools.FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        URL siblingURL;
        assert (pkgName != null);
        assert (relativeName != null);
        URL uRL = this.siblings.hasSibling() ? this.siblings.getSibling() : (siblingURL = sibling == null ? null : sibling.toUri().toURL());
        if (siblingURL == null) {
            throw new IllegalArgumentException("sibling == null");
        }
        File activeRoot = this.getClassFolderForSourceImpl(siblingURL);
        if (activeRoot == null && (activeRoot = this.getClassFolderForApt(siblingURL)) == null) {
            throw new InvalidSourcePath();
        }
        String path = FileObjects.resolveRelativePath(pkgName, relativeName);
        File file = FileUtil.normalizeFile((File)new File(activeRoot, path.replace('/', File.separatorChar)));
        return this.tx.createFileObject(l, file, activeRoot, null, null);
    }

    @Override
    public javax.tools.FileObject getFileForInput(JavaFileManager.Location l, String pkgName, String relativeName) {
        String[] names = FileObjects.getFolderAndBaseName(FileObjects.resolveRelativePath(pkgName, relativeName), '/');
        JavaFileObject fo = this.tx.readFileObject(l, names[0], names[1]);
        if (fo != null) {
            return fo;
        }
        if (!ModuleLocation.isInstance(l)) {
            return super.getFileForInput(l, pkgName, relativeName);
        }
        return this.getFileForInputImpl(ModuleLocation.WithExcludes.cast(l).getModuleEntries(), pkgName, relativeName);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind) {
        int dot;
        String dir;
        JavaFileObject fo;
        if (kind == JavaFileObject.Kind.CLASS && (fo = this.tx.readFileObject(l, dir = (dot = className.lastIndexOf(46)) == -1 ? "" : FileObjects.convertPackage2Folder(className.substring(0, dot)), className.substring(dot + 1))) != null) {
            return fo;
        }
        if (!ModuleLocation.isInstance(l)) {
            return super.getJavaFileForInput(l, className, kind);
        }
        return this.getJavaFileForInputImpl(ModuleLocation.WithExcludes.cast(l).getModuleEntries(), className, kind);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return location == StandardLocation.CLASS_OUTPUT;
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        if (location != StandardLocation.CLASS_OUTPUT) {
            throw new IllegalStateException(String.format("Unsupported location: %s", location));
        }
        if (this.cachedModuleLocations == null) {
            if (this.moduleSourceFileManager != null) {
                HashMap entriesByUrl = new HashMap();
                this.getClassPath().entries().forEach(e -> entriesByUrl.put(e.getURL(), e));
                this.cachedModuleLocations = this.moduleSourceFileManager.sourceModuleLocations().stream().map(ml -> {
                    ModuleLocation.WithExcludes oml = ModuleLocation.WithExcludes.createExcludes(StandardLocation.CLASS_OUTPUT, ml.getModuleRoots().stream().map(src -> {
                        try {
                            URL cacheRoot = BaseUtilities.toURI((File)JavaIndex.getClassFolder(src, false, false)).toURL();
                            ClassPath.Entry cacheEntry = (ClassPath.Entry)entriesByUrl.get(cacheRoot);
                            assert (cacheEntry != null) : String.format("No cache entry for cache root: %s (src root: %s), known entries: %s", cacheRoot, src, entriesByUrl.keySet());
                            return cacheEntry;
                        }
                        catch (IOException ioe) {
                            Exceptions.printStackTrace((Throwable)ioe);
                            return null;
                        }
                    }).filter(cacheEntry -> cacheEntry != null).collect(Collectors.toSet()), ml.getModuleName());
                    return Collections.singleton(oml);
                }).collect(Collectors.toList());
            } else {
                this.cachedModuleLocations = Collections.emptySet();
            }
        }
        return this.cachedModuleLocations;
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        return StreamSupport.stream(this.listLocationsForModules(location).spliterator(), false).flatMap(c -> c.stream()).filter(l -> moduleName.equals(ModuleLocation.cast(l).getModuleName())).findAny().orElse(null);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        URL foUrl = fo.toUri().toURL();
        for (Set<JavaFileManager.Location> s : this.listLocationsForModules(location)) {
            for (JavaFileManager.Location l : s) {
                ModuleLocation ml = ModuleLocation.cast(l);
                for (URL uRL : ml.getModuleRoots()) {
                    if (!FileObjects.isParentOf(uRL, foUrl)) continue;
                    return l;
                }
            }
        }
        return null;
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        ModuleLocation ml = ModuleLocation.cast(location);
        return ml.getModuleName();
    }

    private File getClassFolderForSource(JavaFileManager.Location l, javax.tools.FileObject sibling, String baseName) throws IOException {
        return sibling == null ? this.getClassFolderForSourceImpl(l, baseName) : this.getClassFolderForSourceImpl(sibling.toUri().toURL());
    }

    private File getClassFolderForSourceImpl(URL sibling) throws IOException {
        List entries = this.scp.entries();
        int eSize = entries.size();
        if (eSize == 1) {
            return this.getClassFolder(((ClassPath.Entry)entries.get(0)).getURL());
        }
        if (eSize == 0) {
            return null;
        }
        try {
            for (ClassPath.Entry entry : entries) {
                URL rootUrl = entry.getURL();
                if (!FileObjects.isParentOf(rootUrl, sibling)) continue;
                return this.getClassFolder(rootUrl);
            }
        }
        catch (IllegalArgumentException e) {
            String message = String.format("uri: %s", sibling.toString());
            throw (IllegalArgumentException)Exceptions.attachMessage((Throwable)e, (String)message);
        }
        return null;
    }

    private File getClassFolderForSourceImpl(JavaFileManager.Location l, String baseName) throws IOException {
        List entries = this.scp.entries();
        int eSize = entries.size();
        if (eSize == 1) {
            return this.getClassFolder(((ClassPath.Entry)entries.get(0)).getURL());
        }
        if (eSize == 0) {
            return null;
        }
        String[] parentName = this.splitParentName(baseName);
        Collection<? extends URL> roots = this.getLocationRoots(l);
        for (ClassPath.Entry entry : entries) {
            File cacheFolder;
            FileObject parentFile;
            FileObject root = entry.getRoot();
            if (root == null || (parentFile = root.getFileObject(parentName[0])) == null || parentFile.getFileObject(parentName[1], "java") == null || !roots.contains(BaseUtilities.toURI((File)(cacheFolder = this.getClassFolder(entry.getURL()))).toURL())) continue;
            return cacheFolder;
        }
        return null;
    }

    private File getClassFolderForApt(JavaFileManager.Location l, javax.tools.FileObject sibling, String baseName) throws IOException {
        return sibling == null ? this.getClassFolderForApt(l, baseName) : this.getClassFolderForApt(sibling.toUri().toURL());
    }

    private File getClassFolderForApt(@NonNull URL surl) {
        for (ClassPath.Entry entry : this.apt.entries()) {
            URL classFolder;
            if (!FileObjects.isParentOf(entry.getURL(), surl) || (classFolder = AptCacheForSourceQuery.getClassFolder(entry.getURL())) == null) continue;
            try {
                return BaseUtilities.toFile((URI)classFolder.toURI());
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private File getClassFolderForApt(JavaFileManager.Location l, String baseName) {
        String[] parentName = this.splitParentName(baseName);
        Collection<? extends URL> roots = this.getLocationRoots(l);
        for (ClassPath.Entry entry : this.apt.entries()) {
            URL classFolder;
            FileObject parentFile;
            FileObject root = entry.getRoot();
            if (root == null || (parentFile = root.getFileObject(parentName[0])) == null || parentFile.getFileObject(parentName[1], "java") == null || (classFolder = AptCacheForSourceQuery.getClassFolder(entry.getURL())) == null || !roots.contains(classFolder)) continue;
            try {
                return BaseUtilities.toFile((URI)classFolder.toURI());
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private String[] splitParentName(String baseName) {
        String name;
        String parent = null;
        int index = baseName.lastIndexOf(47);
        if (index < 0) {
            parent = "";
            name = baseName;
        } else {
            parent = baseName.substring(0, index);
            name = baseName.substring(index + 1);
        }
        index = name.indexOf(36);
        if (index > 0) {
            name = name.substring(0, index);
        }
        return new String[]{parent, name};
    }

    private File getClassFolder(URL url) throws IOException {
        Pair<URI, File> cacheItem = this.cachedClassFolder;
        URI uri = null;
        try {
            uri = url.toURI();
            if (cacheItem != null && uri.equals(cacheItem.first())) {
                return (File)cacheItem.second();
            }
        }
        catch (URISyntaxException e) {
            LOG.log(Level.FINE, "Not caching class folder for URL: {0}", url);
        }
        File result = JavaIndex.getClassFolder(url, false, false);
        assert (result != null) : "No class folder for source root: " + url;
        if (uri != null) {
            this.cachedClassFolder = Pair.of((Object)uri, (Object)result);
        }
        return result;
    }

    private Collection<? extends URL> getLocationRoots(JavaFileManager.Location l) {
        if (!ModuleLocation.isInstance(l)) {
            return this.getClassPath().entries().stream().map(e -> e.getURL()).collect(Collectors.toSet());
        }
        return ModuleLocation.cast(l).getModuleRoots();
    }

    public static class InvalidSourcePath
    extends IllegalStateException {
    }
}

