/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.projectint;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class FileObjectIterator
implements Iterator<FileObject> {
    private Collection<FileObject> roots;
    private Iterator<FileObject> rootsIterator;
    private Enumeration<? extends FileObject> rootChildrenEnum;

    public FileObjectIterator(Collection<FileObject> roots) {
        this.roots = roots;
    }

    @Override
    public boolean hasNext() {
        if (null == this.rootsIterator) {
            this.rootsIterator = this.roots.iterator();
            return this.rootsIterator.hasNext();
        }
        return null != this.rootChildrenEnum && this.rootChildrenEnum.hasMoreElements() || this.rootsIterator.hasNext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FileObject next() {
        FileObject result = null;
        if (null != this.rootChildrenEnum) {
            if (this.rootChildrenEnum.hasMoreElements()) return this.rootChildrenEnum.nextElement();
        }
        if (!this.rootsIterator.hasNext()) throw new NoSuchElementException();
        result = this.rootsIterator.next();
        this.rootChildrenEnum = result.getChildren(true);
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean isUnderRoots(FileObject fo) {
        for (FileObject root : this.roots) {
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
            return true;
        }
        return false;
    }
}

