/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.packets.Bundle;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.InitMessage;
import org.netbeans.modules.php.dbgp.packets.MessageBuilder;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class DbgpMessage {
    private static final Logger LOGGER = Logger.getLogger(DbgpMessage.class.getName());
    private static final String INIT = "init";
    private static final String RESPONSE = "response";
    private static final String STREAM = "stream";
    static final String ISO_CHARSET = "ISO-8859-1";
    private static final int MAX_PACKET_SIZE = 1024;
    protected static final String HTML_APOS = "&apos;";
    protected static final String HTML_QUOTE = "&quot;";
    protected static final String HTML_AMP = "&amp";
    protected static final String HTML_LT = "&lt";
    protected static final String HTML_GT = "&gt";
    private static final Map<String, Character> ENTITIES = new HashMap<String, Character>();
    private static DocumentBuilder builder;
    private static AtomicInteger myMaxDataSize;
    private Node myNode;

    DbgpMessage(Node node) {
        this.myNode = node;
    }

    public static DbgpMessage create(InputStream inputStream, String projectEncoding) throws SocketException {
        try {
            int size = DbgpMessage.getDataSize(inputStream);
            if (size < 0) {
                DbgpMessage.notifyPacketError(null);
                Logger.getLogger(DbgpMessage.class.getName()).log(Level.FINE, "Got {0} as data size", size);
                return null;
            }
            byte[] bytes = DbgpMessage.getContent(inputStream, size);
            Node node = DbgpMessage.getNode(bytes, projectEncoding);
            DbgpMessage.logDebugInfo(bytes);
            return DbgpMessage.create(node);
        }
        catch (SocketException e) {
            throw e;
        }
        catch (IOException e) {
            DbgpMessage.log(e);
            return null;
        }
    }

    public abstract void process(DebugSession var1, DbgpCommand var2);

    public static int getMaxDataSize() {
        return myMaxDataSize.get();
    }

    public static void setMaxDataSize(int size) {
        int maxSize = myMaxDataSize.get();
        if (maxSize != size) {
            myMaxDataSize.compareAndSet(maxSize, size);
        }
    }

    public static DbgpMessage create(Node node) {
        String rootName;
        if (node == null) {
            return null;
        }
        switch (rootName = node.getNodeName()) {
            case "init": {
                return new InitMessage(node);
            }
            case "stream": {
                return MessageBuilder.createStream(node);
            }
            case "response": {
                return MessageBuilder.createResponse(node);
            }
        }
        return null;
    }

    protected static void log(IOException e) {
        Logger.getLogger(DbgpMessage.class.getName()).log(Level.SEVERE, null, e);
    }

    protected static String getNodeValue(Node node) {
        NodeList list = node.getChildNodes();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child instanceof Text) {
                builder.append(child.getNodeValue());
                continue;
            }
            if (!(child instanceof CDATASection)) continue;
            builder.append(child.getNodeValue());
        }
        return DbgpMessage.replaceHtmlEntities(builder.toString());
    }

    protected static String getAttribute(Node node, String attrName) {
        Node attr = node.getAttributes().getNamedItem(attrName);
        return attr == null ? null : DbgpMessage.replaceHtmlEntities(attr.getNodeValue());
    }

    protected static boolean getBoolean(Node node, String attrName) {
        String value = DbgpMessage.getAttribute(node, attrName);
        if (value == null) {
            return false;
        }
        try {
            return Integer.parseInt(value) > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected static Node getChild(Node node, String nodeName) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!nodeName.equals(child.getNodeName())) continue;
            return child;
        }
        return null;
    }

    protected static List<Node> getChildren(Node node, String nodeName) {
        LinkedList<Node> result = new LinkedList<Node>();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!nodeName.equals(child.getNodeName())) continue;
            result.add(child);
        }
        return result;
    }

    protected Node getNode() {
        return this.myNode;
    }

    private static void log(ParserConfigurationException e) {
        Logger.getLogger(DbgpMessage.class.getName()).log(Level.SEVERE, null, e);
    }

    private static void logDebugInfo(byte[] bytes) {
        block3: {
            try {
                if (bytes != null) {
                    Logger.getLogger(DbgpMessage.class.getName()).log(Level.FINE, new String(bytes, ISO_CHARSET));
                }
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    private static void notifyPacketError(Exception e) {
        if (e != null) {
            LOGGER.log(Level.INFO, null, e);
        }
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.DbgpMessage_packet_error(), 0));
    }

    private static byte[] getContent(InputStream inputStream, int size) throws IOException {
        int count;
        byte[] bytes = new byte[size];
        try {
            int length;
            for (count = 0; count < size; count += inputStream.read(bytes, count, length)) {
                int awaitedBytes = size - count;
                length = awaitedBytes < DbgpMessage.getMaxDataSize() ? awaitedBytes : DbgpMessage.getMaxDataSize();
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        if (count != size) {
            DbgpMessage.notifyPacketError(null);
            LOGGER.log(Level.INFO, "Read {0} bytes from socket input stream, but expected {1} bytes", new Object[]{count, size});
            return null;
        }
        int nullByte = inputStream.read();
        assert (nullByte == 0);
        return bytes;
    }

    private static int getDataSize(InputStream inputStream) throws IOException {
        int next;
        LinkedList<Integer> list = new LinkedList<Integer>();
        while ((next = inputStream.read()) > 0) {
            list.add(next);
        }
        byte[] bytes = new byte[list.size()];
        int i = 0;
        for (Integer integer : list) {
            byte byt = integer.byteValue();
            bytes[i++] = byt;
        }
        String str = new String(bytes, ISO_CHARSET);
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String removeNonXMLCharacters(String text) {
        int codePoint;
        StringBuilder out = new StringBuilder();
        StringBuilder errorMessage = null;
        for (int index = 0; index < text.length(); index += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(index);
            if (codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF) {
                out.append(Character.toChars(codePoint));
                continue;
            }
            if (errorMessage == null) {
                errorMessage = new StringBuilder();
                errorMessage.append("The message from xdebug contains invalid XML characters: ");
            } else {
                errorMessage.append(", ");
            }
            errorMessage.append(codePoint);
        }
        if (errorMessage != null) {
            errorMessage.append("\nPlease mentioned it in http://netbeans.org/bugzilla/show_bug.cgi?id=179309.");
            LOGGER.warning(errorMessage.toString());
        }
        return out.toString();
    }

    private static Node getNode(byte[] bytes, String projectEncoding) throws IOException {
        if (builder == null || bytes == null) {
            return null;
        }
        String original = new String(bytes, projectEncoding);
        String inputWithoutNullChars = null;
        try {
            String input = DbgpMessage.removeNonXMLCharacters(original);
            inputWithoutNullChars = input.replace("&#0;", "");
            InputSource is = new InputSource(new StringReader(inputWithoutNullChars));
            is.setEncoding(projectEncoding);
            Document doc = builder.parse(is);
            return doc.getDocumentElement();
        }
        catch (SAXException e) {
            LOGGER.log(Level.SEVERE, "Possible invalid XML - ORIGINAL:\n\n{0}\n\nAFTER REPLACE:\n\n{1}", new Object[]{original, inputWithoutNullChars});
            return null;
        }
    }

    private static String replaceHtmlEntities(String str) {
        if (str.indexOf("&") == -1) {
            return str;
        }
        for (Map.Entry<String, Character> entry : ENTITIES.entrySet()) {
            String entity = entry.getKey();
            Character ch = entry.getValue();
            str = str.replace(entity, ch + "");
        }
        return str;
    }

    static {
        myMaxDataSize = new AtomicInteger(1024);
        ENTITIES.put(HTML_APOS, Character.valueOf('\''));
        ENTITIES.put(HTML_QUOTE, Character.valueOf('\"'));
        ENTITIES.put(HTML_AMP, Character.valueOf('&'));
        ENTITIES.put(HTML_LT, Character.valueOf('<'));
        ENTITIES.put(HTML_GT, Character.valueOf('>'));
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setEntityResolver(new StubResolver());
        }
        catch (ParserConfigurationException e) {
            DbgpMessage.log(e);
        }
    }

    private static class StubResolver
    implements EntityResolver {
        private StubResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return null;
        }
    }

    public static final class NoneDbgpMessage
    extends DbgpMessage {
        public NoneDbgpMessage(Node node) {
            super(node);
        }

        @Override
        public void process(DebugSession session, DbgpCommand command) {
        }
    }
}

