/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.shell;

import com.oracle.truffle.js.shell.ConsoleHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.graalvm.shadowed.org.jline.reader.EndOfFileException;
import org.graalvm.shadowed.org.jline.reader.History;
import org.graalvm.shadowed.org.jline.reader.LineReader;
import org.graalvm.shadowed.org.jline.reader.LineReaderBuilder;
import org.graalvm.shadowed.org.jline.reader.UserInterruptException;
import org.graalvm.shadowed.org.jline.reader.impl.history.DefaultHistory;
import org.graalvm.shadowed.org.jline.terminal.Terminal;
import org.graalvm.shadowed.org.jline.terminal.TerminalBuilder;

public class JLineConsoleHandler
implements ConsoleHandler {
    private final Terminal terminal;
    private final LineReader reader;
    private final History history;
    private final String prompt;

    public JLineConsoleHandler(InputStream inStream, OutputStream outStream, String prompt) throws IOException {
        this.terminal = TerminalBuilder.builder().jna(false).streams(inStream, outStream).system(true).build();
        this.history = new DefaultHistory();
        this.prompt = prompt;
        LineReaderBuilder builder = LineReaderBuilder.builder().terminal(this.terminal).history(this.history);
        builder.option(LineReader.Option.DISABLE_EVENT_EXPANSION, true);
        builder.variable("comment-begin", (Object)"//");
        builder.variable("bell-style", (Object)"off");
        this.reader = builder.build();
    }

    @Override
    public String readLine() throws IOException {
        try {
            return this.reader.readLine(this.prompt);
        }
        catch (EndOfFileException e) {
            return null;
        }
        catch (UserInterruptException e) {
            return null;
        }
    }
}

