/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.keymanagement.model.EncryptDataDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class EncryptRequest
extends BmcRequest<EncryptDataDetails> {
    private EncryptDataDetails encryptDataDetails;
    private String opcRequestId;

    public EncryptDataDetails getEncryptDataDetails() {
        return this.encryptDataDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public EncryptDataDetails getBody$() {
        return this.encryptDataDetails;
    }

    public Builder toBuilder() {
        return new Builder().encryptDataDetails(this.encryptDataDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",encryptDataDetails=").append(String.valueOf((Object)this.encryptDataDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptRequest)) {
            return false;
        }
        EncryptRequest other = (EncryptRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.encryptDataDetails, (Object)other.encryptDataDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.encryptDataDetails == null ? 43 : this.encryptDataDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<EncryptRequest, EncryptDataDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private EncryptDataDetails encryptDataDetails = null;
        private String opcRequestId = null;

        public Builder encryptDataDetails(EncryptDataDetails encryptDataDetails) {
            this.encryptDataDetails = encryptDataDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(EncryptRequest o) {
            this.encryptDataDetails(o.getEncryptDataDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public EncryptRequest build() {
            EncryptRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(EncryptDataDetails body) {
            this.encryptDataDetails(body);
            return this;
        }

        public EncryptRequest buildWithoutInvocationCallback() {
            EncryptRequest request = new EncryptRequest();
            request.encryptDataDetails = this.encryptDataDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

