/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDhcpOptionsRequest
extends BmcRequest<Void> {
    private String dhcpId;

    public String getDhcpId() {
        return this.dhcpId;
    }

    public Builder toBuilder() {
        return new Builder().dhcpId(this.dhcpId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dhcpId=").append(String.valueOf(this.dhcpId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDhcpOptionsRequest)) {
            return false;
        }
        GetDhcpOptionsRequest other = (GetDhcpOptionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dhcpId, other.dhcpId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dhcpId == null ? 43 : this.dhcpId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDhcpOptionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dhcpId = null;

        public Builder dhcpId(String dhcpId) {
            this.dhcpId = dhcpId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDhcpOptionsRequest o) {
            this.dhcpId(o.getDhcpId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDhcpOptionsRequest build() {
            GetDhcpOptionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDhcpOptionsRequest buildWithoutInvocationCallback() {
            GetDhcpOptionsRequest request = new GetDhcpOptionsRequest();
            request.dhcpId = this.dhcpId;
            return request;
        }
    }
}

