/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.oracle.bmc.core.Compute;
import com.oracle.bmc.core.model.BootVolumeAttachment;
import com.oracle.bmc.core.model.ComputeCapacityReservation;
import com.oracle.bmc.core.model.ComputeCluster;
import com.oracle.bmc.core.model.ConsoleHistory;
import com.oracle.bmc.core.model.DedicatedVmHost;
import com.oracle.bmc.core.model.Image;
import com.oracle.bmc.core.model.Instance;
import com.oracle.bmc.core.model.InstanceConsoleConnection;
import com.oracle.bmc.core.model.VnicAttachment;
import com.oracle.bmc.core.model.VolumeAttachment;
import com.oracle.bmc.core.requests.ChangeComputeCapacityReservationCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeDedicatedVmHostCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInstanceCompartmentRequest;
import com.oracle.bmc.core.requests.CreateComputeCapacityReservationRequest;
import com.oracle.bmc.core.requests.CreateDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.CreateImageRequest;
import com.oracle.bmc.core.requests.DeleteComputeCapacityReservationRequest;
import com.oracle.bmc.core.requests.DeleteDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.ExportImageRequest;
import com.oracle.bmc.core.requests.GetBootVolumeAttachmentRequest;
import com.oracle.bmc.core.requests.GetComputeCapacityReservationRequest;
import com.oracle.bmc.core.requests.GetComputeClusterRequest;
import com.oracle.bmc.core.requests.GetConsoleHistoryRequest;
import com.oracle.bmc.core.requests.GetDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.GetImageRequest;
import com.oracle.bmc.core.requests.GetInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.GetInstanceRequest;
import com.oracle.bmc.core.requests.GetVnicAttachmentRequest;
import com.oracle.bmc.core.requests.GetVolumeAttachmentRequest;
import com.oracle.bmc.core.requests.LaunchInstanceRequest;
import com.oracle.bmc.core.requests.UpdateComputeCapacityReservationRequest;
import com.oracle.bmc.core.requests.UpdateInstanceRequest;
import com.oracle.bmc.core.responses.ChangeComputeCapacityReservationCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeDedicatedVmHostCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInstanceCompartmentResponse;
import com.oracle.bmc.core.responses.CreateComputeCapacityReservationResponse;
import com.oracle.bmc.core.responses.CreateDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.CreateImageResponse;
import com.oracle.bmc.core.responses.DeleteComputeCapacityReservationResponse;
import com.oracle.bmc.core.responses.DeleteDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.ExportImageResponse;
import com.oracle.bmc.core.responses.GetBootVolumeAttachmentResponse;
import com.oracle.bmc.core.responses.GetComputeCapacityReservationResponse;
import com.oracle.bmc.core.responses.GetComputeClusterResponse;
import com.oracle.bmc.core.responses.GetConsoleHistoryResponse;
import com.oracle.bmc.core.responses.GetDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.GetImageResponse;
import com.oracle.bmc.core.responses.GetInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.GetInstanceResponse;
import com.oracle.bmc.core.responses.GetVnicAttachmentResponse;
import com.oracle.bmc.core.responses.GetVolumeAttachmentResponse;
import com.oracle.bmc.core.responses.LaunchInstanceResponse;
import com.oracle.bmc.core.responses.UpdateComputeCapacityReservationResponse;
import com.oracle.bmc.core.responses.UpdateInstanceResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import com.oracle.bmc.workrequests.WorkRequest;
import com.oracle.bmc.workrequests.requests.GetWorkRequestRequest;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ComputeWaiters {
    @Nonnull
    private final ExecutorService executorService;
    @Nonnull
    private final Compute client;
    private final WorkRequest workRequestClient;

    @Deprecated
    public ComputeWaiters(@Nonnull ExecutorService executorService, @Nonnull Compute client) {
        this(executorService, client, null);
    }

    public ComputeWaiters(@Nonnull ExecutorService executorService, @Nonnull Compute client, WorkRequest workRequestClient) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.executorService = executorService;
        this.client = client;
        this.workRequestClient = workRequestClient;
    }

    public Waiter<ChangeComputeCapacityReservationCompartmentRequest, ChangeComputeCapacityReservationCompartmentResponse> forChangeComputeCapacityReservationCompartment(ChangeComputeCapacityReservationCompartmentRequest request) {
        return this.forChangeComputeCapacityReservationCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeComputeCapacityReservationCompartmentRequest, ChangeComputeCapacityReservationCompartmentResponse> forChangeComputeCapacityReservationCompartment(final ChangeComputeCapacityReservationCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ChangeComputeCapacityReservationCompartmentResponse>(){

            @Override
            public ChangeComputeCapacityReservationCompartmentResponse call() throws Exception {
                ChangeComputeCapacityReservationCompartmentResponse response = ComputeWaiters.this.client.changeComputeCapacityReservationCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<ChangeDedicatedVmHostCompartmentRequest, ChangeDedicatedVmHostCompartmentResponse> forChangeDedicatedVmHostCompartment(ChangeDedicatedVmHostCompartmentRequest request) {
        return this.forChangeDedicatedVmHostCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeDedicatedVmHostCompartmentRequest, ChangeDedicatedVmHostCompartmentResponse> forChangeDedicatedVmHostCompartment(final ChangeDedicatedVmHostCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ChangeDedicatedVmHostCompartmentResponse>(){

            @Override
            public ChangeDedicatedVmHostCompartmentResponse call() throws Exception {
                ChangeDedicatedVmHostCompartmentResponse response = ComputeWaiters.this.client.changeDedicatedVmHostCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentResponse> forChangeInstanceCompartment(ChangeInstanceCompartmentRequest request) {
        return this.forChangeInstanceCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentResponse> forChangeInstanceCompartment(final ChangeInstanceCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ChangeInstanceCompartmentResponse>(){

            @Override
            public ChangeInstanceCompartmentResponse call() throws Exception {
                ChangeInstanceCompartmentResponse response = ComputeWaiters.this.client.changeInstanceCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<CreateComputeCapacityReservationRequest, CreateComputeCapacityReservationResponse> forCreateComputeCapacityReservation(CreateComputeCapacityReservationRequest request) {
        return this.forCreateComputeCapacityReservation(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateComputeCapacityReservationRequest, CreateComputeCapacityReservationResponse> forCreateComputeCapacityReservation(final CreateComputeCapacityReservationRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<CreateComputeCapacityReservationResponse>(){

            @Override
            public CreateComputeCapacityReservationResponse call() throws Exception {
                CreateComputeCapacityReservationResponse response = ComputeWaiters.this.client.createComputeCapacityReservation(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<CreateDedicatedVmHostRequest, CreateDedicatedVmHostResponse> forCreateDedicatedVmHost(CreateDedicatedVmHostRequest request) {
        return this.forCreateDedicatedVmHost(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateDedicatedVmHostRequest, CreateDedicatedVmHostResponse> forCreateDedicatedVmHost(final CreateDedicatedVmHostRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<CreateDedicatedVmHostResponse>(){

            @Override
            public CreateDedicatedVmHostResponse call() throws Exception {
                CreateDedicatedVmHostResponse response = ComputeWaiters.this.client.createDedicatedVmHost(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<CreateImageRequest, CreateImageResponse> forCreateImage(CreateImageRequest request) {
        return this.forCreateImage(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateImageRequest, CreateImageResponse> forCreateImage(final CreateImageRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<CreateImageResponse>(){

            @Override
            public CreateImageResponse call() throws Exception {
                CreateImageResponse response = ComputeWaiters.this.client.createImage(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<DeleteComputeCapacityReservationRequest, DeleteComputeCapacityReservationResponse> forDeleteComputeCapacityReservation(DeleteComputeCapacityReservationRequest request) {
        return this.forDeleteComputeCapacityReservation(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<DeleteComputeCapacityReservationRequest, DeleteComputeCapacityReservationResponse> forDeleteComputeCapacityReservation(final DeleteComputeCapacityReservationRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<DeleteComputeCapacityReservationResponse>(){

            @Override
            public DeleteComputeCapacityReservationResponse call() throws Exception {
                DeleteComputeCapacityReservationResponse response = ComputeWaiters.this.client.deleteComputeCapacityReservation(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<DeleteDedicatedVmHostRequest, DeleteDedicatedVmHostResponse> forDeleteDedicatedVmHost(DeleteDedicatedVmHostRequest request) {
        return this.forDeleteDedicatedVmHost(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<DeleteDedicatedVmHostRequest, DeleteDedicatedVmHostResponse> forDeleteDedicatedVmHost(final DeleteDedicatedVmHostRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<DeleteDedicatedVmHostResponse>(){

            @Override
            public DeleteDedicatedVmHostResponse call() throws Exception {
                DeleteDedicatedVmHostResponse response = ComputeWaiters.this.client.deleteDedicatedVmHost(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<ExportImageRequest, ExportImageResponse> forExportImage(ExportImageRequest request) {
        return this.forExportImage(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ExportImageRequest, ExportImageResponse> forExportImage(final ExportImageRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ExportImageResponse>(){

            @Override
            public ExportImageResponse call() throws Exception {
                ExportImageResponse response = ComputeWaiters.this.client.exportImage(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse> forBootVolumeAttachment(GetBootVolumeAttachmentRequest request, BootVolumeAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBootVolumeAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse> forBootVolumeAttachment(GetBootVolumeAttachmentRequest request, BootVolumeAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBootVolumeAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse> forBootVolumeAttachment(GetBootVolumeAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BootVolumeAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBootVolumeAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse> forBootVolumeAttachment(BmcGenericWaiter waiter, GetBootVolumeAttachmentRequest request, BootVolumeAttachment.LifecycleState ... targetStates) {
        final HashSet<BootVolumeAttachment.LifecycleState> targetStatesSet = new HashSet<BootVolumeAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse>(){

            @Override
            public GetBootVolumeAttachmentResponse apply(GetBootVolumeAttachmentRequest request) {
                return ComputeWaiters.this.client.getBootVolumeAttachment(request);
            }
        }, (Predicate)new Predicate<GetBootVolumeAttachmentResponse>(){

            @Override
            public boolean test(GetBootVolumeAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getBootVolumeAttachment().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetComputeCapacityReservationRequest, GetComputeCapacityReservationResponse> forComputeCapacityReservation(GetComputeCapacityReservationRequest request, ComputeCapacityReservation.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forComputeCapacityReservation(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetComputeCapacityReservationRequest, GetComputeCapacityReservationResponse> forComputeCapacityReservation(GetComputeCapacityReservationRequest request, ComputeCapacityReservation.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forComputeCapacityReservation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetComputeCapacityReservationRequest, GetComputeCapacityReservationResponse> forComputeCapacityReservation(GetComputeCapacityReservationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ComputeCapacityReservation.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forComputeCapacityReservation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetComputeCapacityReservationRequest, GetComputeCapacityReservationResponse> forComputeCapacityReservation(BmcGenericWaiter waiter, GetComputeCapacityReservationRequest request, ComputeCapacityReservation.LifecycleState ... targetStates) {
        final HashSet<ComputeCapacityReservation.LifecycleState> targetStatesSet = new HashSet<ComputeCapacityReservation.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetComputeCapacityReservationRequest, GetComputeCapacityReservationResponse>(){

            @Override
            public GetComputeCapacityReservationResponse apply(GetComputeCapacityReservationRequest request) {
                return ComputeWaiters.this.client.getComputeCapacityReservation(request);
            }
        }, (Predicate)new Predicate<GetComputeCapacityReservationResponse>(){

            @Override
            public boolean test(GetComputeCapacityReservationResponse response) {
                return targetStatesSet.contains((Object)response.getComputeCapacityReservation().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ComputeCapacityReservation.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetComputeClusterRequest, GetComputeClusterResponse> forComputeCluster(GetComputeClusterRequest request, ComputeCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forComputeCluster(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetComputeClusterRequest, GetComputeClusterResponse> forComputeCluster(GetComputeClusterRequest request, ComputeCluster.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forComputeCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetComputeClusterRequest, GetComputeClusterResponse> forComputeCluster(GetComputeClusterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ComputeCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forComputeCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetComputeClusterRequest, GetComputeClusterResponse> forComputeCluster(BmcGenericWaiter waiter, GetComputeClusterRequest request, ComputeCluster.LifecycleState ... targetStates) {
        final HashSet<ComputeCluster.LifecycleState> targetStatesSet = new HashSet<ComputeCluster.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetComputeClusterRequest, GetComputeClusterResponse>(){

            @Override
            public GetComputeClusterResponse apply(GetComputeClusterRequest request) {
                return ComputeWaiters.this.client.getComputeCluster(request);
            }
        }, (Predicate)new Predicate<GetComputeClusterResponse>(){

            @Override
            public boolean test(GetComputeClusterResponse response) {
                return targetStatesSet.contains((Object)response.getComputeCluster().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ComputeCluster.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetConsoleHistoryRequest, GetConsoleHistoryResponse> forConsoleHistory(GetConsoleHistoryRequest request, ConsoleHistory.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConsoleHistory(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetConsoleHistoryRequest, GetConsoleHistoryResponse> forConsoleHistory(GetConsoleHistoryRequest request, ConsoleHistory.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forConsoleHistory(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetConsoleHistoryRequest, GetConsoleHistoryResponse> forConsoleHistory(GetConsoleHistoryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ConsoleHistory.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forConsoleHistory(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetConsoleHistoryRequest, GetConsoleHistoryResponse> forConsoleHistory(BmcGenericWaiter waiter, GetConsoleHistoryRequest request, ConsoleHistory.LifecycleState ... targetStates) {
        final HashSet<ConsoleHistory.LifecycleState> targetStatesSet = new HashSet<ConsoleHistory.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetConsoleHistoryRequest, GetConsoleHistoryResponse>(){

            @Override
            public GetConsoleHistoryResponse apply(GetConsoleHistoryRequest request) {
                return ComputeWaiters.this.client.getConsoleHistory(request);
            }
        }, (Predicate)new Predicate<GetConsoleHistoryResponse>(){

            @Override
            public boolean test(GetConsoleHistoryResponse response) {
                return targetStatesSet.contains((Object)response.getConsoleHistory().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse> forDedicatedVmHost(GetDedicatedVmHostRequest request, DedicatedVmHost.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDedicatedVmHost(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse> forDedicatedVmHost(GetDedicatedVmHostRequest request, DedicatedVmHost.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDedicatedVmHost(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse> forDedicatedVmHost(GetDedicatedVmHostRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DedicatedVmHost.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDedicatedVmHost(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse> forDedicatedVmHost(BmcGenericWaiter waiter, GetDedicatedVmHostRequest request, DedicatedVmHost.LifecycleState ... targetStates) {
        final HashSet<DedicatedVmHost.LifecycleState> targetStatesSet = new HashSet<DedicatedVmHost.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse>(){

            @Override
            public GetDedicatedVmHostResponse apply(GetDedicatedVmHostRequest request) {
                return ComputeWaiters.this.client.getDedicatedVmHost(request);
            }
        }, (Predicate)new Predicate<GetDedicatedVmHostResponse>(){

            @Override
            public boolean test(GetDedicatedVmHostResponse response) {
                return targetStatesSet.contains((Object)response.getDedicatedVmHost().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DedicatedVmHost.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetImageRequest, GetImageResponse> forImage(GetImageRequest request, Image.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forImage(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetImageRequest, GetImageResponse> forImage(GetImageRequest request, Image.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forImage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetImageRequest, GetImageResponse> forImage(GetImageRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Image.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forImage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetImageRequest, GetImageResponse> forImage(BmcGenericWaiter waiter, GetImageRequest request, Image.LifecycleState ... targetStates) {
        final HashSet<Image.LifecycleState> targetStatesSet = new HashSet<Image.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetImageRequest, GetImageResponse>(){

            @Override
            public GetImageResponse apply(GetImageRequest request) {
                return ComputeWaiters.this.client.getImage(request);
            }
        }, (Predicate)new Predicate<GetImageResponse>(){

            @Override
            public boolean test(GetImageResponse response) {
                return targetStatesSet.contains((Object)response.getImage().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Image.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetInstanceRequest, GetInstanceResponse> forInstance(GetInstanceRequest request, Instance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInstanceRequest, GetInstanceResponse> forInstance(GetInstanceRequest request, Instance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetInstanceRequest, GetInstanceResponse> forInstance(GetInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Instance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetInstanceRequest, GetInstanceResponse> forInstance(BmcGenericWaiter waiter, GetInstanceRequest request, Instance.LifecycleState ... targetStates) {
        final HashSet<Instance.LifecycleState> targetStatesSet = new HashSet<Instance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetInstanceRequest, GetInstanceResponse>(){

            @Override
            public GetInstanceResponse apply(GetInstanceRequest request) {
                return ComputeWaiters.this.client.getInstance(request);
            }
        }, (Predicate)new Predicate<GetInstanceResponse>(){

            @Override
            public boolean test(GetInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Instance.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse> forInstanceConsoleConnection(GetInstanceConsoleConnectionRequest request, InstanceConsoleConnection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInstanceConsoleConnection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse> forInstanceConsoleConnection(GetInstanceConsoleConnectionRequest request, InstanceConsoleConnection.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInstanceConsoleConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse> forInstanceConsoleConnection(GetInstanceConsoleConnectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, InstanceConsoleConnection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInstanceConsoleConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse> forInstanceConsoleConnection(BmcGenericWaiter waiter, GetInstanceConsoleConnectionRequest request, InstanceConsoleConnection.LifecycleState ... targetStates) {
        final HashSet<InstanceConsoleConnection.LifecycleState> targetStatesSet = new HashSet<InstanceConsoleConnection.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse>(){

            @Override
            public GetInstanceConsoleConnectionResponse apply(GetInstanceConsoleConnectionRequest request) {
                return ComputeWaiters.this.client.getInstanceConsoleConnection(request);
            }
        }, (Predicate)new Predicate<GetInstanceConsoleConnectionResponse>(){

            @Override
            public boolean test(GetInstanceConsoleConnectionResponse response) {
                return targetStatesSet.contains((Object)response.getInstanceConsoleConnection().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)InstanceConsoleConnection.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetVnicAttachmentRequest, GetVnicAttachmentResponse> forVnicAttachment(GetVnicAttachmentRequest request, VnicAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVnicAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVnicAttachmentRequest, GetVnicAttachmentResponse> forVnicAttachment(GetVnicAttachmentRequest request, VnicAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVnicAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVnicAttachmentRequest, GetVnicAttachmentResponse> forVnicAttachment(GetVnicAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VnicAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVnicAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVnicAttachmentRequest, GetVnicAttachmentResponse> forVnicAttachment(BmcGenericWaiter waiter, GetVnicAttachmentRequest request, VnicAttachment.LifecycleState ... targetStates) {
        final HashSet<VnicAttachment.LifecycleState> targetStatesSet = new HashSet<VnicAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVnicAttachmentRequest, GetVnicAttachmentResponse>(){

            @Override
            public GetVnicAttachmentResponse apply(GetVnicAttachmentRequest request) {
                return ComputeWaiters.this.client.getVnicAttachment(request);
            }
        }, (Predicate)new Predicate<GetVnicAttachmentResponse>(){

            @Override
            public boolean test(GetVnicAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getVnicAttachment().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse> forVolumeAttachment(GetVolumeAttachmentRequest request, VolumeAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVolumeAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse> forVolumeAttachment(GetVolumeAttachmentRequest request, VolumeAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVolumeAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse> forVolumeAttachment(GetVolumeAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VolumeAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVolumeAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse> forVolumeAttachment(BmcGenericWaiter waiter, GetVolumeAttachmentRequest request, VolumeAttachment.LifecycleState ... targetStates) {
        final HashSet<VolumeAttachment.LifecycleState> targetStatesSet = new HashSet<VolumeAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse>(){

            @Override
            public GetVolumeAttachmentResponse apply(GetVolumeAttachmentRequest request) {
                return ComputeWaiters.this.client.getVolumeAttachment(request);
            }
        }, (Predicate)new Predicate<GetVolumeAttachmentResponse>(){

            @Override
            public boolean test(GetVolumeAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getVolumeAttachment().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<LaunchInstanceRequest, LaunchInstanceResponse> forLaunchInstance(LaunchInstanceRequest request) {
        return this.forLaunchInstance(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<LaunchInstanceRequest, LaunchInstanceResponse> forLaunchInstance(final LaunchInstanceRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<LaunchInstanceResponse>(){

            @Override
            public LaunchInstanceResponse call() throws Exception {
                LaunchInstanceResponse response = ComputeWaiters.this.client.launchInstance(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<UpdateComputeCapacityReservationRequest, UpdateComputeCapacityReservationResponse> forUpdateComputeCapacityReservation(UpdateComputeCapacityReservationRequest request) {
        return this.forUpdateComputeCapacityReservation(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpdateComputeCapacityReservationRequest, UpdateComputeCapacityReservationResponse> forUpdateComputeCapacityReservation(final UpdateComputeCapacityReservationRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<UpdateComputeCapacityReservationResponse>(){

            @Override
            public UpdateComputeCapacityReservationResponse call() throws Exception {
                UpdateComputeCapacityReservationResponse response = ComputeWaiters.this.client.updateComputeCapacityReservation(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<UpdateInstanceRequest, UpdateInstanceResponse> forUpdateInstance(UpdateInstanceRequest request) {
        return this.forUpdateInstance(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpdateInstanceRequest, UpdateInstanceResponse> forUpdateInstance(final UpdateInstanceRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<UpdateInstanceResponse>(){

            @Override
            public UpdateInstanceResponse call() throws Exception {
                UpdateInstanceResponse response = ComputeWaiters.this.client.updateInstance(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }
}

