/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.source;

import java.util.logging.Logger;
import nu.validator.source.SourceCode;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

final class LocationRecorder
implements ContentHandler,
LexicalHandler {
    private static final Logger log4j = Logger.getLogger(LocationRecorder.class.getName());
    private final SourceCode owner;
    private Locator locator;
    private String uri;

    LocationRecorder(SourceCode owner) {
        this.owner = owner;
    }

    private void addLocatorLocation() {
        if (this.locator != null) {
            String systemId = this.locator.getSystemId();
            log4j.fine(systemId);
            if (this.uri == systemId || this.uri != null && this.uri.equals(systemId)) {
                this.owner.addLocatorLocation(this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
        }
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        this.addLocatorLocation();
    }

    @Override
    public void endDocument() throws SAXException {
        this.locator = null;
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        this.addLocatorLocation();
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        this.addLocatorLocation();
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
        this.addLocatorLocation();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        log4j.fine(String.valueOf(locator));
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
        this.addLocatorLocation();
    }

    @Override
    public void startDocument() throws SAXException {
        this.uri = this.owner.getUri();
    }

    @Override
    public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
        this.addLocatorLocation();
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
        this.addLocatorLocation();
    }

    @Override
    public void endCDATA() throws SAXException {
        this.addLocatorLocation();
    }

    @Override
    public void endDTD() throws SAXException {
        this.addLocatorLocation();
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
        this.addLocatorLocation();
    }

    @Override
    public void startCDATA() throws SAXException {
        this.addLocatorLocation();
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
        this.addLocatorLocation();
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
        this.addLocatorLocation();
    }
}

