/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.project;

import java.io.InputStream;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.fish.payara.micro.project.MicroApplication;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.openide.util.Lookup;

public class MicroActionsProvider
implements MavenActionsProvider {
    private static final String ACTION_MAPPINGS = "org/netbeans/modules/fish/payara/micro/project/resources/action-mapping.xml";
    private final AbstractMavenActionsProvider actionsProvider = new AbstractMavenActionsProvider(){

        protected InputStream getActionDefinitionStream() {
            return MicroActionsProvider.class.getClassLoader().getResourceAsStream(MicroActionsProvider.ACTION_MAPPINGS);
        }

        public boolean isActionEnable(String action, Project project, Lookup lookup) {
            NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            String packagingType = nbMavenProject.getPackagingType();
            if (!"war".equals(packagingType)) {
                return false;
            }
            switch (action) {
                case "run": 
                case "debug": 
                case "profile": 
                case "run.single.deploy": 
                case "debug.single.deploy": 
                case "profile.single.deploy": {
                    break;
                }
                default: {
                    return false;
                }
            }
            return MicroApplication.getInstance(project) != null;
        }
    };

    public RunConfig createConfigForDefaultAction(String actionName, Project project, Lookup lookup) {
        MicroApplication microApplication = MicroApplication.getInstance(project);
        if (microApplication != null) {
            Preferences pref = ProjectUtils.getPreferences((Project)project, MicroApplication.class, (boolean)true);
            String microVersionText = pref.get("version", "");
            Boolean hotDeploy = pref.getBoolean("hotDeploy", false);
            RunConfig config = this.actionsProvider.createConfigForDefaultAction(actionName, project, lookup);
            if (!microVersionText.isEmpty()) {
                config.setProperty("version.payara", microVersionText);
            }
            if (hotDeploy.booleanValue()) {
                config.setProperty("hotDeploy", Boolean.TRUE.toString());
            }
            return config;
        }
        return null;
    }

    public NetbeansActionMapping getMappingForAction(String actionName, Project project) {
        MicroApplication microApplication = MicroApplication.getInstance(project);
        if (microApplication != null) {
            return this.actionsProvider.getMappingForAction(actionName, project);
        }
        return null;
    }

    public boolean isActionEnable(String action, Project project, Lookup lookup) {
        MicroApplication microApplication = MicroApplication.getInstance(project);
        if (microApplication != null) {
            return this.actionsProvider.isActionEnable(action, project, lookup);
        }
        return false;
    }

    public Set<String> getSupportedDefaultActions() {
        return this.actionsProvider.getSupportedDefaultActions();
    }
}

