/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sync;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectSettings;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.runconfigs.RunConfigRemote;

public final class TimeStamps {
    private static final Logger LOGGER = Logger.getLogger(TimeStamps.class.getName());
    private final Storage storage;
    private final String pathPrefix;

    public TimeStamps(PhpProject project) {
        this(new StorageImpl(project), RunConfigRemote.forProject(project).getRemoteConnectionHint());
        assert (project != null);
    }

    TimeStamps(Storage storage, String pathPrefix) {
        assert (storage != null);
        assert (pathPrefix != null);
        this.storage = storage;
        this.pathPrefix = pathPrefix;
    }

    public long getSyncTimestamp(TransferFile transferFile) {
        assert (transferFile != null);
        String path = this.getFullPath(transferFile.getRemoteAbsolutePath());
        LinkedList paths = new LinkedList(StringUtils.explode((String)path, (String)"/"));
        assert (!paths.isEmpty()) : path;
        if (transferFile.isFile()) {
            LOGGER.log(Level.FINE, "File {0} is not a directory, changing to its parent", path);
            paths.removeLast();
        }
        while (true) {
            String tmp = StringUtils.implode(paths, (String)"/");
            if (this.pathPrefix.length() > tmp.length()) break;
            LOGGER.log(Level.FINE, "Getting sync timestamp of {0}", tmp);
            long timestamp = this.storage.getLong(tmp);
            if (timestamp != -1L) {
                LOGGER.log(Level.FINE, "Sync timestamp of {0} is {1}", new Object[]{tmp, timestamp});
                return timestamp;
            }
            paths.removeLast();
        }
        LOGGER.fine("Path prefix length reached, exiting loop");
        LOGGER.log(Level.FINE, "Sync timestamp of {0} not found", path);
        return -1L;
    }

    public void setSyncTimestamp(TransferFile transferFile) {
        this.setSyncTimestamp(transferFile, TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
    }

    void setSyncTimestamp(TransferFile transferFile, long timestamp) {
        assert (transferFile != null);
        if (!transferFile.isDirectory()) {
            LOGGER.log(Level.FINE, "Ignoring non-directory {0}", transferFile.getRemoteAbsolutePath());
            return;
        }
        String path = this.getFullPath(transferFile.getRemoteAbsolutePath());
        LOGGER.log(Level.FINE, "Setting sync timestamp of {0} to {1}", new Object[]{path, timestamp});
        this.storage.setLong(path, timestamp);
    }

    String getFullPath(String path) {
        return this.pathPrefix + path;
    }

    private static final class StorageImpl
    implements Storage {
        private final Project project;

        public StorageImpl(Project project) {
            assert (project != null);
            this.project = project;
        }

        @Override
        public long getLong(String key) {
            return ProjectSettings.getSyncTimestamp(this.project, this.getHash(key));
        }

        @Override
        public void setLong(String key, long value) {
            ProjectSettings.setSyncTimestamp(this.project, this.getHash(key), value);
        }

        private String getHash(String input) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] hash = md.digest(input.getBytes(StandardCharsets.UTF_8));
                StringBuilder sb = new StringBuilder();
                for (byte b : hash) {
                    sb.append(Integer.toHexString(b & 0xFF));
                }
                String result = sb.toString();
                LOGGER.log(Level.FINE, "Hashing \"{0}\" to \"{1}\"", new Object[]{input, result});
                return result;
            }
            catch (NoSuchAlgorithmException ex) {
                LOGGER.log(Level.INFO, null, ex);
                LOGGER.log(Level.FINE, "No hashing for \"{0}\"", input);
                return input;
            }
        }
    }

    static interface Storage {
        public long getLong(String var1);

        public void setLong(String var1, long var2);
    }
}

