/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency.reload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.dependency.ProjectReload;
import org.netbeans.modules.project.dependency.reload.ProjectReloadInternal;
import org.netbeans.modules.project.dependency.reload.ProjectStateListener;
import org.netbeans.modules.project.dependency.reload.ReloadApiAccessor;
import org.netbeans.modules.project.dependency.reload.ReloadSpiAccessor;
import org.netbeans.modules.project.dependency.reload.Reloader;
import org.netbeans.modules.project.dependency.spi.ProjectReloadImplementation;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Pair;
import org.openide.util.WeakListeners;

class StateDataListener
extends FileChangeAdapter
implements ProjectStateListener {
    private static final Logger LOG = Logger.getLogger(StateDataListener.class.getName());
    final Project p;
    final ProjectReloadInternal.StateRef tracker;
    final ProjectReloadInternal.StateParts parts;
    Map<FileObject, Collection<ProjectReloadImplementation.ProjectStateData>> watchedFiles;
    Collection<FileChangeListener> fcls = new ArrayList<FileChangeListener>();
    Collection<Pair<Lookup.Result, LookupListener[]>> lcls = new ArrayList<Pair<Lookup.Result, LookupListener[]>>();

    public StateDataListener(Project p, ProjectReloadInternal.StateParts parts, ProjectReloadInternal.StateRef ref) {
        this.p = p;
        this.tracker = ref;
        this.parts = parts;
    }

    void init() {
        this.updateFileListeners();
        for (ProjectReloadImplementation.ProjectStateData d : this.parts.values()) {
            ReloadSpiAccessor.get().addProjectStateListener(d, this);
        }
        this.checkFileTimestamps();
        this.checkInconsistencies();
    }

    public void checkFileTimestamps() {
        ProjectReload.ProjectState s = (ProjectReload.ProjectState)this.tracker.get();
        if (s == null) {
            return;
        }
        Map<FileObject, Collection<ProjectReloadImplementation.ProjectStateData>> wf = this.watchedFiles;
        Reloader.checkFileTimestamps(s, wf);
    }

    void checkInconsistencies() {
        ProjectReload.ProjectState s = (ProjectReload.ProjectState)this.tracker.get();
        if (s == null) {
            return;
        }
        for (ProjectReloadImplementation.ProjectStateData d : this.parts.values()) {
            Reloader.markInconsistencies(d, null, this.parts, s);
        }
    }

    @Override
    public void fireDataInconsistent(ProjectReloadImplementation.ProjectStateData d, Class<?> dataClass) {
        ProjectReload.ProjectState state = (ProjectReload.ProjectState)this.tracker.get();
        if (state == null) {
            this.detachListeners();
            return;
        }
        Lookup.Template t = new Lookup.Template(dataClass);
        for (ProjectReloadImplementation.ProjectStateData sd : this.parts.values()) {
            if ((sd == null || !dataClass.isInstance(sd.getProjectData())) && (sd.getLookup() == null || sd.getLookup().lookupItem(t) == null)) continue;
            sd.fireChanged(false, true);
        }
    }

    private synchronized boolean updateFileListeners() {
        Set obsoletes;
        LinkedHashMap<FileObject, Collection<ProjectReloadImplementation.ProjectStateData>> updatedFiles = new LinkedHashMap<FileObject, Collection<ProjectReloadImplementation.ProjectStateData>>();
        for (ProjectReloadImplementation.ProjectStateData sd : this.parts.values()) {
            if (sd == null) continue;
            Collection<FileObject> c = sd.getFiles();
            c.forEach(f -> updatedFiles.computeIfAbsent((FileObject)f, f2 -> new ArrayList(1)).add(sd));
        }
        HashSet newFiles = new HashSet(updatedFiles.keySet());
        if (this.watchedFiles != null) {
            obsoletes = new HashSet<FileObject>(this.watchedFiles.keySet());
            obsoletes.removeAll(updatedFiles.keySet());
            newFiles.removeAll(this.watchedFiles.keySet());
        } else {
            obsoletes = Collections.emptySet();
        }
        LOG.log(Level.FINER, "{0}: UpdateListeners called. Added: {1}, removed: {2}", new Object[]{this.p, newFiles, obsoletes});
        if (obsoletes.isEmpty() && newFiles.isEmpty()) {
            this.watchedFiles = updatedFiles;
            return false;
        }
        ArrayList<FileChangeListener> listeners = new ArrayList<FileChangeListener>();
        ArrayList<Pair<Lookup.Result, LookupListener[]>> lookupListeners = new ArrayList<Pair<Lookup.Result, LookupListener[]>>();
        if (!obsoletes.isEmpty()) {
            Iterator<Pair<Lookup.Result, LookupListener[]>> llit = this.lcls.iterator();
            Iterator<FileChangeListener> lit = this.fcls.iterator();
            Iterator<FileObject> fit = this.watchedFiles.keySet().iterator();
            while (fit.hasNext()) {
                Pair<Lookup.Result, LookupListener[]> ll = llit.next();
                FileChangeListener l = lit.next();
                FileObject f2 = fit.next();
                if (obsoletes.contains(f2)) {
                    f2.removeFileChangeListener((FileChangeListener)this);
                    ((Lookup.Result)ll.first()).removeLookupListener(((LookupListener[])ll.second())[1]);
                    continue;
                }
                lookupListeners.add(ll);
                listeners.add(l);
            }
        } else if (this.watchedFiles != null && !this.watchedFiles.isEmpty()) {
            listeners.addAll(this.fcls);
        }
        for (FileObject f3 : newFiles) {
            FileChangeListener l = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)f3);
            listeners.add(l);
            f3.addFileChangeListener((FileChangeListener)this);
            Lookup.Result lr = f3.getLookup().lookupResult(SaveCookie.class);
            LookupListener ll2 = e -> this.cookiesChanged(f3, e);
            LookupListener ll = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)ll2, (Object)lr);
            lookupListeners.add((Pair<Lookup.Result, LookupListener[]>)Pair.of((Object)lr, (Object)new LookupListener[]{ll, ll2}));
            lr.addLookupListener(ll2);
        }
        this.watchedFiles = updatedFiles;
        this.fcls = listeners;
        this.lcls = lookupListeners;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachListeners() {
        StateDataListener stateDataListener = this;
        synchronized (stateDataListener) {
            if (this.watchedFiles != null) {
                this.watchedFiles.keySet().forEach(f -> f.removeFileChangeListener((FileChangeListener)this));
                this.watchedFiles.clear();
            }
            this.lcls.forEach(p -> ((Lookup.Result)p.first()).removeLookupListener(((LookupListener[])p.second())[1]));
            this.lcls.clear();
            this.fcls.clear();
        }
        this.parts.values().forEach(sd -> ReloadSpiAccessor.get().removeProjectStateListener((ProjectReloadImplementation.ProjectStateData)sd, this));
    }

    private void reportFile(FileObject f, long t) {
        long t2;
        ProjectReload.ProjectState state = (ProjectReload.ProjectState)this.tracker.get();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0} received file report: {1}, time {2}, file time {4}, state time: {3}", new Object[]{state == null ? "null" : state.toString(), f, t, state == null ? -3L : state.getTimestamp(), f.lastModified().getTime()});
        }
        if (state == null) {
            this.detachListeners();
            return;
        }
        long l = t2 = t == -1L ? f.lastModified().getTime() : t;
        if (t2 < state.getTimestamp()) {
            return;
        }
        ReloadApiAccessor.get().updateProjectState(state, true, false, Collections.singleton(f), null, null);
        ((Collection)this.watchedFiles.getOrDefault(f, Collections.emptyList())).forEach(d -> d.fireChanged(false, true));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        LinkedHashSet<FileObject> s;
        ProjectReload.ProjectState state = (ProjectReload.ProjectState)this.tracker.get();
        ProjectReloadImplementation.ProjectStateData d = (ProjectReloadImplementation.ProjectStateData)e.getSource();
        boolean c = d.isConsistent();
        boolean v = d.isValid();
        if (state == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "DETACHING on stateData from {1}", new Object[]{d.toString()});
            }
            this.detachListeners();
            return;
        }
        HashSet<FileObject> obs = new HashSet<FileObject>(d.getFiles());
        boolean fire = false;
        boolean invalid = false;
        boolean inconsistent = false;
        LinkedHashSet<FileObject> setModified = null;
        obs.removeAll(state.getLoadedFiles());
        if (!obs.isEmpty() && (s = new LinkedHashSet<FileObject>(state.getChangedFiles())).addAll(obs)) {
            setModified = s;
            inconsistent = true;
            fire = true;
        }
        if (state.isConsistent() && !c) {
            inconsistent = true;
            fire = true;
        }
        if (state.isValid() && !v) {
            invalid = true;
            fire = true;
        }
        if (v) {
            this.updateFileListeners();
        }
        if (!v) {
            this.detachListeners();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0} received stateData from {1}, updating: {2}", new Object[]{state.toString(), d.toString(), fire});
        }
        if (fire) {
            ReloadApiAccessor.get().updateProjectState(state, inconsistent, invalid, setModified, null, null);
        }
    }

    public void fileDeleted(FileEvent fe) {
        this.reportFile(fe.getFile(), System.currentTimeMillis());
    }

    public void fileChanged(FileEvent fe) {
        this.reportFile(fe.getFile(), fe.getFile().lastModified().getTime());
    }

    public void fileDataCreated(FileEvent fe) {
        this.reportFile(fe.getFile().getParent(), fe.getFile().lastModified().getTime());
    }

    public void cookiesChanged(FileObject f, LookupEvent ev) {
        ProjectReload.ProjectState state = (ProjectReload.ProjectState)this.tracker.get();
        if (state == null) {
            this.detachListeners();
            return;
        }
        Lookup.Result lr = (Lookup.Result)ev.getSource();
        if (!lr.allItems().isEmpty()) {
            HashSet<FileObject> ed = new HashSet<FileObject>(state.getEditedFiles());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0} received SaveCookie on file {1}; present {2}", new Object[]{state.toString(), f, ed.contains(f)});
            }
            if (ed.add(f)) {
                HashSet<FileObject> ch = new HashSet<FileObject>(state.getChangedFiles());
                if (!ch.add(f)) {
                    ch = null;
                }
                ReloadApiAccessor.get().updateProjectState(state, true, false, ch, ed, null);
            }
            ((Collection)this.watchedFiles.getOrDefault(f, Collections.emptyList())).forEach(d -> d.fireChanged(false, true));
        }
    }
}

