/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.swing.text.Position;
import org.netbeans.modules.gsf.testrunner.ui.TestMethodFinderImpl;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public final class TestMethodFinder {
    public static Map<FileObject, Collection<TestMethodController.TestMethod>> findTestMethods(Iterable<FileObject> testRoots, BiConsumer<FileObject, Collection<TestMethodController.TestMethod>> listener) {
        TestMethodFinderImpl.INSTANCE.addListener(listener);
        HashMap<FileObject, Collection<TestMethodController.TestMethod>> file2TestMethods = new HashMap<FileObject, Collection<TestMethodController.TestMethod>>();
        for (FileObject testRoot : testRoots) {
            try {
                FileObject cacheRoot = TestMethodFinder.getCacheRoot(testRoot.toURL());
                if (cacheRoot == null) continue;
                Enumeration children = cacheRoot.getChildren(true);
                while (children.hasMoreElements()) {
                    FileObject child = (FileObject)children.nextElement();
                    if (!child.hasExt("tests")) continue;
                    TestMethodFinder.loadTestMethods(child, file2TestMethods);
                }
            }
            catch (IOException iOException) {
            }
        }
        return file2TestMethods;
    }

    private static void loadTestMethods(FileObject input, Map<FileObject, Collection<TestMethodController.TestMethod>> file2TestMethods) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(input.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            FileObject fo = null;
            String className = null;
            Position classPosition = null;
            Collection testMethods = null;
            while ((line = br.readLine()) != null) {
                int idx;
                String info;
                if (line.startsWith("url: ")) {
                    String url = line.substring(5);
                    fo = URLMapper.findFileObject((URL)URI.create(url).toURL());
                    if (fo == null) {
                        return;
                    }
                    testMethods = file2TestMethods.computeIfAbsent(fo, fObj -> new ArrayList());
                    continue;
                }
                if (line.startsWith("class: ")) {
                    info = line.substring(7);
                    idx = info.lastIndexOf(58);
                    className = (idx < 0 ? info : info.substring(0, idx)).trim();
                    classPosition = idx < 0 ? null : () -> Integer.parseInt(info.substring(idx + 1));
                    continue;
                }
                if (!line.startsWith("method: ") || testMethods == null || className == null) continue;
                info = line.substring(8);
                idx = info.lastIndexOf(58);
                String name = (idx < 0 ? info : info.substring(0, idx)).trim();
                String[] range = idx < 0 ? new String[]{} : info.substring(idx + 1).split("-");
                Position methodStart = range.length > 0 ? () -> Integer.parseInt(range[0]) : null;
                Position methodEnd = range.length > 1 ? () -> Integer.parseInt(range[1]) : null;
                testMethods.add(new TestMethodController.TestMethod(className, classPosition, new SingleMethod(fo, name), methodStart, null, methodEnd));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static FileObject getCacheRoot(URL root) throws IOException {
        FileObject dataFolder = CacheFolder.getDataFolder((URL)root, (boolean)true);
        return dataFolder != null ? FileUtil.createFolder((FileObject)dataFolder, (String)"tests/2") : null;
    }
}

