/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jsui.frames.models;

import com.sun.jdi.AbsentInformationException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.js.frames.JSStackFrame;
import org.netbeans.modules.debugger.jpda.jsui.frames.models.Bundle;
import org.netbeans.modules.debugger.jpda.jsui.frames.models.DebuggingJSFramesInJavaModelFilter;
import org.netbeans.modules.debugger.jpda.jsui.frames.models.DebuggingJSTreeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class DebuggingJSActionsProvider
implements NodeActionsProviderFilter {
    private final JPDADebugger debugger;
    private final Session session;
    private final RequestProcessor requestProcessor;

    public DebuggingJSActionsProvider(ContextProvider context) {
        this.debugger = (JPDADebugger)context.lookupFirst(null, JPDADebugger.class);
        this.session = (Session)context.lookupFirst(null, Session.class);
        this.requestProcessor = (RequestProcessor)context.lookupFirst(null, RequestProcessor.class);
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof JSStackFrame) {
            node = ((JSStackFrame)node).getJavaFrame();
        }
        original.performDefaultAction(node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof JSStackFrame) {
            node = ((JSStackFrame)node).getJavaFrame();
            Action[] actions = original.getActions(node);
            for (int i = 0; i < actions.length; ++i) {
                if (actions[i] == null) continue;
                Object debuggerActionKind = actions[i].getValue("debuggerActionKind");
                actions[i] = "copyToClipboard".equals(debuggerActionKind) ? this.createCopyToClipboardAction(actions[i]) : DebuggingJSActionsProvider.translateModelAction(actions[i]);
            }
            return actions;
        }
        Action[] actions = original.getActions(node);
        actions = this.replaceCopyToClipboardAction(actions);
        return actions;
    }

    private static Action translateModelAction(Action action) {
        Models.ActionPerformer ap = DebuggingJSActionsProvider.getActionPerformer(action);
        if (ap != null) {
            String name = (String)action.getValue("Name");
            action = Models.createAction((String)name, (Models.ActionPerformer)new ActionPerformerDelegate(ap), (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
        }
        return action;
    }

    static Models.ActionPerformer getActionPerformer(Action action) {
        try {
            Class<?> asClass = Class.forName(Models.class.getName() + "$ActionSupport");
            if (!asClass.isInstance(action)) {
                return null;
            }
            Field performerField = asClass.getDeclaredField("performer");
            performerField.setAccessible(true);
            Object performer = performerField.get(action);
            return (Models.ActionPerformer)performer;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private Action[] replaceCopyToClipboardAction(Action[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            Object debuggerActionKind;
            if (actions[i] == null || !"copyToClipboard".equals(debuggerActionKind = actions[i].getValue("debuggerActionKind"))) continue;
            actions[i] = this.createCopyToClipboardAction(actions[i]);
        }
        return actions;
    }

    private Action createCopyToClipboardAction(Action action) {
        Models.ActionPerformer ap = DebuggingJSActionsProvider.getActionPerformer(action);
        if (ap != null) {
            String name = (String)action.getValue("Name");
            action = Models.createAction((String)name, (Models.ActionPerformer)new CopyToClipboardPerformerDelegate(ap), (int)Models.MULTISELECTION_TYPE_ANY);
        }
        return action;
    }

    private void stackToCLBD(List<JPDAThread> threads) {
        StringBuffer frameStr = new StringBuffer(512);
        for (JPDAThread t : threads) {
            if (frameStr.length() > 0) {
                frameStr.append('\n');
            }
            frameStr.append("\"");
            frameStr.append(t.getName());
            frameStr.append("\"\n");
            this.appendStackInfo(frameStr, t);
        }
        Clipboard systemClipboard = DebuggingJSActionsProvider.getClipboard();
        StringSelection transferableText = new StringSelection(frameStr.toString());
        systemClipboard.setContents(transferableText, null);
    }

    void appendStackInfo(StringBuffer frameStr, JPDAThread t) {
        Object[] stack;
        try {
            stack = t.getCallStack();
        }
        catch (AbsentInformationException ex) {
            frameStr.append(Bundle.MSG_NoSourceInfo());
            stack = null;
        }
        if (stack != null) {
            Object[] jsChildren;
            Object[] children = stack;
            boolean displayJSStacks = DebuggingJSFramesInJavaModelFilter.preferences.getBoolean("displayJSStacks", true);
            if ((displayJSStacks || "JS".equals(this.session.getCurrentLanguage())) && (jsChildren = DebuggingJSTreeModel.createChildrenWithJSStack(stack)) != null) {
                children = DebuggingJSTreeModel.filterChildren(jsChildren);
            }
            int k = children.length;
            for (int i = 0; i < k; ++i) {
                CallStackFrame frame;
                Object ch = children[i];
                if (ch instanceof CallStackFrame) {
                    frame = (CallStackFrame)ch;
                    frameStr.append("\tat ");
                    frameStr.append(frame.getClassName());
                    frameStr.append(".");
                    frameStr.append(frame.getMethodName());
                } else if (ch instanceof JSStackFrame) {
                    JSStackFrame jsframe = (JSStackFrame)ch;
                    frame = jsframe.getJavaFrame();
                    String cName = frame.getClassName();
                    if (cName.startsWith("jdk.nashorn.internal.scripts.Script$")) {
                        cName = cName.substring("jdk.nashorn.internal.scripts.Script$".length());
                    } else if (cName.startsWith("org.openjdk.nashorn.internal.scripts.Script$")) {
                        cName = cName.substring("org.openjdk.nashorn.internal.scripts.Script$".length());
                    }
                    frameStr.append("\tat ");
                    frameStr.append(cName);
                    frameStr.append(".");
                    frameStr.append(frame.getMethodName());
                } else {
                    frame = null;
                }
                if (frame != null) {
                    try {
                        String sourceName = frame.getSourceName(null);
                        frameStr.append("(");
                        frameStr.append(sourceName);
                        int line = frame.getLineNumber(null);
                        if (line > 0) {
                            frameStr.append(":");
                            frameStr.append(line);
                        }
                        frameStr.append(")");
                    }
                    catch (AbsentInformationException absentInformationException) {
                        // empty catch block
                    }
                }
                if (i == k - 1) continue;
                frameStr.append('\n');
            }
        }
    }

    static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    private static class ActionPerformerDelegate
    implements Models.ActionPerformer {
        private final Models.ActionPerformer apDelegate;

        ActionPerformerDelegate(Models.ActionPerformer apDelegate) {
            this.apDelegate = apDelegate;
        }

        public boolean isEnabled(Object node) {
            if (node instanceof JSStackFrame) {
                node = ((JSStackFrame)node).getJavaFrame();
            }
            return this.apDelegate.isEnabled(node);
        }

        public void perform(Object[] nodes) {
            for (int i = 0; i < nodes.length; ++i) {
                if (!(nodes[i] instanceof JSStackFrame)) continue;
                nodes[i] = ((JSStackFrame)nodes[i]).getJavaFrame();
            }
            this.apDelegate.perform(nodes);
        }
    }

    private class CopyToClipboardPerformerDelegate
    implements Models.ActionPerformer {
        private final Models.ActionPerformer ap;

        CopyToClipboardPerformerDelegate(Models.ActionPerformer ap) {
            this.ap = ap;
        }

        public boolean isEnabled(Object node) {
            return this.ap.isEnabled(node);
        }

        public void perform(final Object[] nodes) {
            DebuggingJSActionsProvider.this.requestProcessor.post(new Runnable(){

                @Override
                public void run() {
                    CopyToClipboardPerformerDelegate.this.run(nodes);
                }
            });
        }

        void run(Object[] nodes) {
            ArrayList<JPDAThread> threads = new ArrayList<JPDAThread>(nodes.length);
            for (Object node : nodes) {
                JPDAThread t;
                if (node instanceof JPDAThread) {
                    threads.add((JPDAThread)node);
                }
                if (!(node instanceof CallStackFrame) || threads.contains(t = ((CallStackFrame)node).getThread())) continue;
                threads.add(t);
            }
            if (threads.isEmpty()) {
                threads.add(DebuggingJSActionsProvider.this.debugger.getCurrentThread());
            }
            DebuggingJSActionsProvider.this.stackToCLBD(threads);
        }
    }
}

