/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.ChangeDomainCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeDomainCompartmentRequest
extends BmcRequest<ChangeDomainCompartmentDetails> {
    private String domainId;
    private ChangeDomainCompartmentDetails changeDomainCompartmentDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public String getDomainId() {
        return this.domainId;
    }

    public ChangeDomainCompartmentDetails getChangeDomainCompartmentDetails() {
        return this.changeDomainCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public ChangeDomainCompartmentDetails getBody$() {
        return this.changeDomainCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().domainId(this.domainId).changeDomainCompartmentDetails(this.changeDomainCompartmentDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",domainId=").append(String.valueOf(this.domainId));
        sb.append(",changeDomainCompartmentDetails=").append(String.valueOf((Object)this.changeDomainCompartmentDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeDomainCompartmentRequest)) {
            return false;
        }
        ChangeDomainCompartmentRequest other = (ChangeDomainCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.domainId, other.domainId) && Objects.equals((Object)this.changeDomainCompartmentDetails, (Object)other.changeDomainCompartmentDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.domainId == null ? 43 : this.domainId.hashCode());
        result = result * 59 + (this.changeDomainCompartmentDetails == null ? 43 : this.changeDomainCompartmentDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeDomainCompartmentRequest, ChangeDomainCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String domainId = null;
        private ChangeDomainCompartmentDetails changeDomainCompartmentDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder changeDomainCompartmentDetails(ChangeDomainCompartmentDetails changeDomainCompartmentDetails) {
            this.changeDomainCompartmentDetails = changeDomainCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeDomainCompartmentRequest o) {
            this.domainId(o.getDomainId());
            this.changeDomainCompartmentDetails(o.getChangeDomainCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeDomainCompartmentRequest build() {
            ChangeDomainCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeDomainCompartmentDetails body) {
            this.changeDomainCompartmentDetails(body);
            return this;
        }

        public ChangeDomainCompartmentRequest buildWithoutInvocationCallback() {
            ChangeDomainCompartmentRequest request = new ChangeDomainCompartmentRequest();
            request.domainId = this.domainId;
            request.changeDomainCompartmentDetails = this.changeDomainCompartmentDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

