/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzer;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.util.ImageUtilities;

public class KOUtils {
    public static final String JAVASCRIPT_MIMETYPE = "text/javascript";
    public static final String KO_DATA_BIND_MIMETYPE = "text/ko-data-bind";
    public static final String KO_DATA_BIND_ATTR_NAME = "data-bind";
    public static final String KO_PARAMS_ATTR_NAME = "params";
    public static final ImageIcon KO_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/html/knockout/knockout-icon.png", (boolean)false);
    public static final Color KO_COLOR = Color.green.darker();
    private static final int URL_CONNECTION_TIMEOUT = 1000;
    private static final int URL_READ_TIMEOUT = 3000;

    public static OffsetRange getValidDocumentOffsetRange(int efrom, int eto, Snapshot snapshot) {
        if (efrom == -1 || eto == -1) {
            throw new IllegalArgumentException(String.format("bad range: %s - %s", efrom, eto));
        }
        int dfrom = snapshot.getOriginalOffset(efrom);
        int dto = snapshot.getOriginalOffset(eto);
        if (dfrom == -1 || dto == -1) {
            return null;
        }
        if (dfrom > dto) {
            return null;
        }
        return new OffsetRange(dfrom, dto);
    }

    public static String getContentAsString(URL url, Charset charset) throws IOException {
        StringWriter writer = new StringWriter();
        KOUtils.loadURL(url, writer, charset);
        return writer.getBuffer().toString();
    }

    public static void loadURL(URL url, Writer writer, Charset charset) throws IOException {
        int read;
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        URLConnection con = url.openConnection();
        con.setConnectTimeout(1000);
        con.setReadTimeout(3000);
        con.connect();
        InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(con.getInputStream()), charset);
        char[] buf = new char[2048];
        while ((read = r.read(buf)) != -1) {
            writer.write(buf, 0, read);
        }
        ((Reader)r).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            int read;
            char[] buf = new char[2048];
            while ((read = r.read(buf)) != -1) {
                sb.append(buf, 0, read);
            }
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getKnockoutDocumentationContent(String content) {
        int stripFrom = 0;
        int stripTo = content.length();
        HtmlSource source = new HtmlSource((CharSequence)content);
        Iterator elementsIterator = SyntaxAnalyzer.create((HtmlSource)source).elementsIterator();
        boolean inContent = false;
        int depth = 0;
        while (elementsIterator.hasNext()) {
            Element element = (Element)elementsIterator.next();
            switch (element.type()) {
                case OPEN_TAG: {
                    CharSequence unquotedValue;
                    Attribute attribute;
                    OpenTag ot = (OpenTag)element;
                    if (LexerUtils.equals((CharSequence)"div", (CharSequence)ot.name(), (boolean)true, (boolean)true) && (attribute = ot.getAttribute("class")) != null && (unquotedValue = attribute.unquotedValue()) != null && LexerUtils.equals((CharSequence)"content", (CharSequence)unquotedValue, (boolean)true, (boolean)true)) {
                        stripFrom = element.to();
                        inContent = true;
                    }
                    if (!inContent) break;
                    ++depth;
                    break;
                }
                case CLOSE_TAG: {
                    if (!inContent || --depth != 0) break;
                    stripTo = element.from();
                    return content.substring(stripFrom, stripTo);
                }
            }
        }
        return content.substring(stripFrom, stripTo);
    }
}

