/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.commons.classloading;

public final class ClassLoaderHelper {
    private static final String JAVA = "java.";
    private static final String JDK_INTERNAL = "jdk.internal.";
    private static final String SUN_MISC = "sun.misc.";

    private ClassLoaderHelper() {
    }

    public static String fromClassNameToResourceName(String className) {
        return className.replace('.', '/').concat(".class");
    }

    public static boolean isInJdkPackage(String name) {
        return name.startsWith(JAVA) || name.startsWith(JDK_INTERNAL) || name.startsWith(SUN_MISC);
    }
}

