#!/usr/bin/env tclsh8.6
#
# plumb.tcl: plumb to the plan9 plumber
#
# To install in the default directory:
#
#	# make install
#
# To install on a different prefix (i.e. your homedir)
#
#	$PREFIX=${HOME} make install
#
# The extension takes data from the selection in a text widget in IRCTk
# and run the plumb executable. The system will decide what to do with
# it.
#

source $::env(IRCTK_TCL_SDK)

set name "Plumb"
set version 1.0.0

proc plumbing {msg} {
	#
	# Send the data to the system plumber
	#
	if {[catch {exec plumb [format %s [dict get $msg data]]} errstr]} {
		puts stderr "irctk plumb: $errstr"
	}
}

::irctk::init $name $version {}

::irctk::filter plumb plumbing

::irctk::loop
