/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.Binding;
import com.google.cloud.Condition;
import com.google.cloud.Policy;
import com.google.cloud.StringEnumValue;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.Cors;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.Rpo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.Utils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.google.iam.v1.Binding;
import com.google.iam.v1.Policy;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.Timestamp;
import com.google.storage.v2.Bucket;
import com.google.storage.v2.BucketAccessControl;
import com.google.storage.v2.CryptoKeyName;
import com.google.storage.v2.CustomerEncryption;
import com.google.storage.v2.Object;
import com.google.storage.v2.ObjectAccessControl;
import com.google.storage.v2.ObjectChecksums;
import com.google.storage.v2.Owner;
import com.google.type.Date;
import com.google.type.Expr;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

final class GrpcConversions {
    static final GrpcConversions INSTANCE = new GrpcConversions();
    private final Conversions.Codec<Acl.Entity, String> entityCodec = Conversions.Codec.of(this::entityEncode, this::entityDecode);
    private final Conversions.Codec<Acl, ObjectAccessControl> objectAclCodec = Conversions.Codec.of(this::objectAclEncode, this::objectAclDecode);
    private final Conversions.Codec<Acl, BucketAccessControl> bucketAclCodec = Conversions.Codec.of(this::bucketAclEncode, this::bucketAclDecode);
    private final Conversions.Codec<Cors, Bucket.Cors> corsCodec = Conversions.Codec.of(this::corsEncode, this::corsDecode);
    private final Conversions.Codec<BucketInfo.Logging, Bucket.Logging> loggingCodec = Conversions.Codec.of(this::loggingEncode, this::loggingDecode);
    private final Conversions.Codec<BucketInfo.IamConfiguration, Bucket.IamConfig> iamConfigurationCodec = Conversions.Codec.of(this::iamConfigEncode, this::iamConfigDecode);
    private final Conversions.Codec<BucketInfo.Autoclass, Bucket.Autoclass> autoclassCodec = Conversions.Codec.of(this::autoclassEncode, this::autoclassDecode);
    private final Conversions.Codec<BucketInfo.SoftDeletePolicy, Bucket.SoftDeletePolicy> softDeletePolicyCodec = Conversions.Codec.of(this::softDeletePolicyEncode, this::softDeletePolicyDecode);
    private final Conversions.Codec<BucketInfo.LifecycleRule, Bucket.Lifecycle.Rule> lifecycleRuleCodec = Conversions.Codec.of(this::lifecycleRuleEncode, this::lifecycleRuleDecode);
    private final Conversions.Codec<BucketInfo, Bucket> bucketInfoCodec = Conversions.Codec.of(this::bucketInfoEncode, this::bucketInfoDecode);
    private final Conversions.Codec<BlobInfo.CustomerEncryption, CustomerEncryption> customerEncryptionCodec = Conversions.Codec.of(this::customerEncryptionEncode, this::customerEncryptionDecode);
    private final Conversions.Codec<BlobId, Object> blobIdCodec = Conversions.Codec.of(this::blobIdEncode, this::blobIdDecode);
    private final Conversions.Codec<BlobInfo, Object> blobInfoCodec = Conversions.Codec.of(this::blobInfoEncode, this::blobInfoDecode);
    private final Conversions.Codec<Policy, com.google.iam.v1.Policy> policyCodec = Conversions.Codec.of(this::policyEncode, this::policyDecode);
    private final Conversions.Codec<Binding, com.google.iam.v1.Binding> bindingCodec = Conversions.Codec.of(this::bindingEncode, this::bindingDecode);
    private final Conversions.Codec<Condition, Expr> iamConditionCodec = Conversions.Codec.of(this::conditionEncode, this::conditionDecode);
    private final Conversions.Codec<BucketInfo.HierarchicalNamespace, Bucket.HierarchicalNamespace> hierarchicalNamespaceCodec = Conversions.Codec.of(this::hierarchicalNamespaceEncode, this::hierarchicalNamespaceDecode);
    private final Conversions.Codec<ByteString, String> byteStringB64StringCodec = Conversions.Codec.of(bs -> Base64.getEncoder().encodeToString(bs.toByteArray()), s -> ByteString.copyFrom((byte[])Base64.getDecoder().decode(s.getBytes(StandardCharsets.UTF_8))));
    @VisibleForTesting
    final Conversions.Codec<OffsetDateTime, Timestamp> timestampCodec = Conversions.Codec.of(odt -> Timestamp.newBuilder().setSeconds(odt.toEpochSecond()).setNanos(odt.getNano()).build(), t -> Instant.ofEpochSecond(t.getSeconds()).plusNanos(t.getNanos()).atOffset(ZoneOffset.UTC));
    @VisibleForTesting
    final Conversions.Codec<java.time.Duration, Duration> durationCodec = Conversions.Codec.of(javaDuration -> Duration.newBuilder().setSeconds(javaDuration.getSeconds()).setNanos(javaDuration.getNano()).build(), protoDuration -> java.time.Duration.ofSeconds(protoDuration.getSeconds()).plusNanos(protoDuration.getNanos()));
    @VisibleForTesting
    final Conversions.Codec<OffsetDateTime, Date> odtDateCodec = Conversions.Codec.of(odt -> {
        OffsetDateTime utc = odt.withOffsetSameInstant(ZoneOffset.UTC);
        return Date.newBuilder().setYear(utc.getYear()).setMonth(utc.getMonthValue()).setDay(utc.getDayOfMonth()).build();
    }, d -> LocalDate.of(d.getYear(), d.getMonth(), d.getDay()).atStartOfDay().atOffset(ZoneOffset.UTC));

    private GrpcConversions() {
    }

    Conversions.Codec<Acl.Entity, String> entity() {
        return this.entityCodec;
    }

    Conversions.Codec<Acl, ObjectAccessControl> objectAcl() {
        return this.objectAclCodec;
    }

    Conversions.Codec<Acl, BucketAccessControl> bucketAcl() {
        return this.bucketAclCodec;
    }

    Conversions.Codec<Cors, Bucket.Cors> cors() {
        return this.corsCodec;
    }

    Conversions.Codec<BucketInfo.Logging, Bucket.Logging> logging() {
        return this.loggingCodec;
    }

    Conversions.Codec<BucketInfo.IamConfiguration, Bucket.IamConfig> iamConfiguration() {
        return this.iamConfigurationCodec;
    }

    Conversions.Codec<BucketInfo.LifecycleRule, Bucket.Lifecycle.Rule> lifecycleRule() {
        return this.lifecycleRuleCodec;
    }

    Conversions.Codec<BucketInfo, Bucket> bucketInfo() {
        return this.bucketInfoCodec;
    }

    Conversions.Codec<BlobInfo.CustomerEncryption, CustomerEncryption> customerEncryption() {
        return this.customerEncryptionCodec;
    }

    Conversions.Codec<BlobId, Object> blobId() {
        return this.blobIdCodec;
    }

    Conversions.Codec<BlobInfo, Object> blobInfo() {
        return this.blobInfoCodec;
    }

    Conversions.Codec<Policy, com.google.iam.v1.Policy> policyCodec() {
        return this.policyCodec;
    }

    private BucketInfo bucketInfoDecode(Bucket from) {
        List bucketAclList;
        List defaultObjectAclList;
        Bucket.Logging logging;
        List corsList;
        BucketInfo.BuilderImpl to = new BucketInfo.BuilderImpl((String)Utils.bucketNameCodec.decode(from.getName()));
        ((BucketInfo.Builder)to).setProject((String)Utils.projectNameCodec.decode(from.getProject()));
        ((BucketInfo.Builder)to).setGeneratedId(from.getBucketId());
        this.maybeDecodeRetentionPolicy(from, to);
        Utils.ifNonNull(from.getLocation(), to::setLocation);
        Utils.ifNonNull(from.getLocationType(), to::setLocationType);
        Utils.ifNonNull(from.getMetageneration(), to::setMetageneration);
        if (from.hasBilling()) {
            Bucket.Billing billing = from.getBilling();
            ((BucketInfo.Builder)to).setRequesterPays(billing.getRequesterPays());
        }
        if (from.hasCreateTime()) {
            ((BucketInfo.Builder)to).setCreateTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getCreateTime()));
        }
        if (from.hasUpdateTime()) {
            ((BucketInfo.Builder)to).setUpdateTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getUpdateTime()));
        }
        if (from.hasEncryption()) {
            ((BucketInfo.Builder)to).setDefaultKmsKeyName(from.getEncryption().getDefaultKmsKey());
        }
        if (!from.getRpo().isEmpty()) {
            ((BucketInfo.Builder)to).setRpo(Rpo.valueOf(from.getRpo()));
        }
        if (!from.getStorageClass().isEmpty()) {
            ((BucketInfo.Builder)to).setStorageClass(StorageClass.valueOf(from.getStorageClass()));
        }
        if (from.hasVersioning()) {
            ((BucketInfo.Builder)to).setVersioningEnabled(from.getVersioning().getEnabled());
        }
        Utils.ifNonNull(from.getDefaultEventBasedHold(), to::setDefaultEventBasedHold);
        Map labelsMap = from.getLabelsMap();
        if (!labelsMap.isEmpty()) {
            ((BucketInfo.Builder)to).setLabels(labelsMap);
        }
        if (from.hasWebsite()) {
            String notFoundPage;
            Bucket.Website website = from.getWebsite();
            String mainPageSuffix = website.getMainPageSuffix();
            if (!mainPageSuffix.isEmpty()) {
                ((BucketInfo.Builder)to).setIndexPage(mainPageSuffix);
            }
            if (!(notFoundPage = website.getNotFoundPage()).isEmpty()) {
                ((BucketInfo.Builder)to).setNotFoundPage(notFoundPage);
            }
        }
        if (from.hasLifecycle()) {
            ((BucketInfo.Builder)to).setLifecycleRules((Iterable)GrpcConversions.toImmutableListOf(this.lifecycleRuleCodec::decode).apply(from.getLifecycle().getRuleList()));
        }
        if (!(corsList = from.getCorsList()).isEmpty()) {
            ((BucketInfo.Builder)to).setCors((Iterable)GrpcConversions.toImmutableListOf(this.corsCodec::decode).apply(corsList));
        }
        if (!(!from.hasLogging() || (logging = from.getLogging()).getLogBucket().isEmpty() && logging.getLogObjectPrefix().isEmpty())) {
            ((BucketInfo.Builder)to).setLogging((BucketInfo.Logging)this.loggingCodec.decode(logging));
        }
        if (from.hasOwner()) {
            ((BucketInfo.Builder)to).setOwner((Acl.Entity)this.entityCodec.decode(from.getOwner().getEntity()));
        }
        if (!(defaultObjectAclList = from.getDefaultObjectAclList()).isEmpty()) {
            ((BucketInfo.Builder)to).setDefaultAcl((Iterable)GrpcConversions.toImmutableListOf(this.objectAclCodec::decode).apply(defaultObjectAclList));
        }
        if (!(bucketAclList = from.getAclList()).isEmpty()) {
            ((BucketInfo.Builder)to).setAcl((Iterable)GrpcConversions.toImmutableListOf(this.bucketAclCodec::decode).apply(bucketAclList));
        }
        if (from.hasIamConfig()) {
            ((BucketInfo.Builder)to).setIamConfiguration((BucketInfo.IamConfiguration)this.iamConfigurationCodec.decode(from.getIamConfig()));
        }
        if (from.hasAutoclass()) {
            ((BucketInfo.Builder)to).setAutoclass((BucketInfo.Autoclass)this.autoclassCodec.decode(from.getAutoclass()));
        }
        if (from.hasSoftDeletePolicy()) {
            ((BucketInfo.Builder)to).setSoftDeletePolicy((BucketInfo.SoftDeletePolicy)this.softDeletePolicyCodec.decode(from.getSoftDeletePolicy()));
        }
        if (from.hasCustomPlacementConfig()) {
            Bucket.CustomPlacementConfig customPlacementConfig = from.getCustomPlacementConfig();
            ((BucketInfo.Builder)to).setCustomPlacementConfig(BucketInfo.CustomPlacementConfig.newBuilder().setDataLocations((List<String>)customPlacementConfig.getDataLocationsList()).build());
        }
        if (from.hasHierarchicalNamespace()) {
            ((BucketInfo.Builder)to).setHierarchicalNamespace((BucketInfo.HierarchicalNamespace)this.hierarchicalNamespaceCodec.decode(from.getHierarchicalNamespace()));
        }
        if (!from.getEtag().isEmpty()) {
            ((BucketInfo.Builder)to).setEtag(from.getEtag());
        }
        return ((BucketInfo.Builder)to).build();
    }

    private Bucket bucketInfoEncode(BucketInfo from) {
        BucketInfo.CustomPlacementConfig customPlacementConfig;
        BucketInfo.Logging logging;
        Bucket.Builder to = Bucket.newBuilder();
        to.setName((String)Utils.bucketNameCodec.encode(from.getName()));
        Utils.ifNonNull(from.getProject(), Utils.projectNameCodec::encode, arg_0 -> ((Bucket.Builder)to).setProject(arg_0));
        Utils.ifNonNull(from.getGeneratedId(), arg_0 -> ((Bucket.Builder)to).setBucketId(arg_0));
        this.maybeEncodeRetentionPolicy(from, to);
        Utils.ifNonNull(from.getLocation(), arg_0 -> ((Bucket.Builder)to).setLocation(arg_0));
        Utils.ifNonNull(from.getLocationType(), arg_0 -> ((Bucket.Builder)to).setLocationType(arg_0));
        Utils.ifNonNull(from.getMetageneration(), arg_0 -> ((Bucket.Builder)to).setMetageneration(arg_0));
        if (from.requesterPays() != null) {
            Bucket.Billing.Builder billingBuilder = Bucket.Billing.newBuilder();
            Utils.ifNonNull(from.requesterPays(), arg_0 -> ((Bucket.Billing.Builder)billingBuilder).setRequesterPays(arg_0));
            to.setBilling(billingBuilder.build());
        }
        Utils.ifNonNull(from.getCreateTimeOffsetDateTime(), this.timestampCodec::encode, arg_0 -> ((Bucket.Builder)to).setCreateTime(arg_0));
        Utils.ifNonNull(from.getUpdateTimeOffsetDateTime(), this.timestampCodec::encode, arg_0 -> ((Bucket.Builder)to).setUpdateTime(arg_0));
        if (from.getDefaultKmsKeyName() != null) {
            Bucket.Encryption.Builder encryptionBuilder = Bucket.Encryption.newBuilder();
            Utils.ifNonNull(from.getDefaultKmsKeyName(), arg_0 -> ((Bucket.Encryption.Builder)encryptionBuilder).setDefaultKmsKey(arg_0));
            to.setEncryption(encryptionBuilder.build());
        }
        if (from.getIndexPage() != null || from.getNotFoundPage() != null) {
            Bucket.Website.Builder websiteBuilder = Bucket.Website.newBuilder();
            Utils.ifNonNull(from.getIndexPage(), arg_0 -> ((Bucket.Website.Builder)websiteBuilder).setMainPageSuffix(arg_0));
            Utils.ifNonNull(from.getNotFoundPage(), arg_0 -> ((Bucket.Website.Builder)websiteBuilder).setNotFoundPage(arg_0));
            to.setWebsite(websiteBuilder.build());
        }
        Utils.ifNonNull(from.getRpo(), StringEnumValue::toString, arg_0 -> ((Bucket.Builder)to).setRpo(arg_0));
        Utils.ifNonNull(from.getStorageClass(), StringEnumValue::toString, arg_0 -> ((Bucket.Builder)to).setStorageClass(arg_0));
        if (from.versioningEnabled() != null) {
            Bucket.Versioning.Builder versioningBuilder = Bucket.Versioning.newBuilder();
            Utils.ifNonNull(from.versioningEnabled(), arg_0 -> ((Bucket.Versioning.Builder)versioningBuilder).setEnabled(arg_0));
            to.setVersioning(versioningBuilder.build());
        }
        Utils.ifNonNull(from.getDefaultEventBasedHold(), arg_0 -> ((Bucket.Builder)to).setDefaultEventBasedHold(arg_0));
        Utils.ifNonNull(from.getLabels(), this::removeNullValues, arg_0 -> ((Bucket.Builder)to).putAllLabels(arg_0));
        List<BucketInfo.LifecycleRule> lifecycleRules = from.lifecycleRules;
        if (lifecycleRules != null) {
            Bucket.Lifecycle.Builder lifecycleBuilder = Bucket.Lifecycle.newBuilder();
            if (!lifecycleRules.isEmpty()) {
                ImmutableSet set = (ImmutableSet)from.getLifecycleRules().stream().map(this.lifecycleRuleCodec::encode).collect(ImmutableSet.toImmutableSet());
                lifecycleBuilder.addAllRule((Iterable)ImmutableList.copyOf((Collection)set));
            }
            to.setLifecycle(lifecycleBuilder.build());
        }
        if ((logging = from.getLogging()) != null && (logging.getLogBucket() != null && !logging.getLogBucket().isEmpty() || logging.getLogObjectPrefix() != null && !logging.getLogObjectPrefix().isEmpty())) {
            to.setLogging((Bucket.Logging)this.loggingCodec.encode(logging));
        }
        Utils.ifNonNull(from.getCors(), GrpcConversions.toImmutableListOf(this.corsCodec::encode), arg_0 -> ((Bucket.Builder)to).addAllCors(arg_0));
        Utils.ifNonNull(from.getOwner(), Utils.lift(this.entity()::encode).andThen(o -> Owner.newBuilder().setEntity(o).build()), arg_0 -> ((Bucket.Builder)to).setOwner(arg_0));
        Utils.ifNonNull(from.getDefaultAcl(), GrpcConversions.toImmutableListOf(this.objectAclCodec::encode), arg_0 -> ((Bucket.Builder)to).addAllDefaultObjectAcl(arg_0));
        Utils.ifNonNull(from.getAcl(), GrpcConversions.toImmutableListOf(this.bucketAclCodec::encode), arg_0 -> ((Bucket.Builder)to).addAllAcl(arg_0));
        Utils.ifNonNull(from.getIamConfiguration(), this.iamConfigurationCodec::encode, arg_0 -> ((Bucket.Builder)to).setIamConfig(arg_0));
        Utils.ifNonNull(from.getAutoclass(), this.autoclassCodec::encode, arg_0 -> ((Bucket.Builder)to).setAutoclass(arg_0));
        Utils.ifNonNull(from.getSoftDeletePolicy(), this.softDeletePolicyCodec::encode, arg_0 -> ((Bucket.Builder)to).setSoftDeletePolicy(arg_0));
        if (from.getModifiedFields().contains((java.lang.Object)Storage.BucketField.SOFT_DELETE_POLICY) && from.getSoftDeletePolicy() == null) {
            to.clearSoftDeletePolicy();
        }
        if ((customPlacementConfig = from.getCustomPlacementConfig()) != null && customPlacementConfig.getDataLocations() != null) {
            to.setCustomPlacementConfig(Bucket.CustomPlacementConfig.newBuilder().addAllDataLocations(customPlacementConfig.getDataLocations()).build());
        }
        Utils.ifNonNull(from.getHierarchicalNamespace(), this.hierarchicalNamespaceCodec::encode, arg_0 -> ((Bucket.Builder)to).setHierarchicalNamespace(arg_0));
        Utils.ifNonNull(from.getEtag(), arg_0 -> ((Bucket.Builder)to).setEtag(arg_0));
        return to.build();
    }

    private void maybeEncodeRetentionPolicy(BucketInfo from, Bucket.Builder to) {
        if (from.getRetentionPeriodDuration() != null || from.retentionPolicyIsLocked() != null || from.getRetentionEffectiveTimeOffsetDateTime() != null) {
            Bucket.RetentionPolicy.Builder retentionPolicyBuilder = to.getRetentionPolicyBuilder();
            Utils.ifNonNull(from.getRetentionPeriodDuration(), this.durationCodec::encode, arg_0 -> ((Bucket.RetentionPolicy.Builder)retentionPolicyBuilder).setRetentionDuration(arg_0));
            Utils.ifNonNull(from.retentionPolicyIsLocked(), arg_0 -> ((Bucket.RetentionPolicy.Builder)retentionPolicyBuilder).setIsLocked(arg_0));
            Utils.ifNonNull(from.getRetentionEffectiveTimeOffsetDateTime(), this.timestampCodec::encode, arg_0 -> ((Bucket.RetentionPolicy.Builder)retentionPolicyBuilder).setEffectiveTime(arg_0));
            to.setRetentionPolicy(retentionPolicyBuilder.build());
        }
    }

    private void maybeDecodeRetentionPolicy(Bucket from, BucketInfo.Builder to) {
        if (from.hasRetentionPolicy()) {
            Bucket.RetentionPolicy retentionPolicy = from.getRetentionPolicy();
            to.setRetentionPolicyIsLocked(retentionPolicy.getIsLocked());
            if (retentionPolicy.hasRetentionDuration()) {
                to.setRetentionPeriodDuration((java.time.Duration)this.durationCodec.decode(retentionPolicy.getRetentionDuration()));
            }
            if (retentionPolicy.hasEffectiveTime()) {
                to.setRetentionEffectiveTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(retentionPolicy.getEffectiveTime()));
            }
        }
    }

    private Bucket.Logging loggingEncode(BucketInfo.Logging from) {
        Bucket.Logging.Builder to = Bucket.Logging.newBuilder();
        if (from.getLogObjectPrefix() != null && !from.getLogObjectPrefix().isEmpty()) {
            to.setLogObjectPrefix(from.getLogObjectPrefix());
        }
        Utils.ifNonNull(from.getLogBucket(), Utils.bucketNameCodec::encode, arg_0 -> ((Bucket.Logging.Builder)to).setLogBucket(arg_0));
        return to.build();
    }

    private BucketInfo.Logging loggingDecode(Bucket.Logging from) {
        String logBucket;
        BucketInfo.Logging.Builder to = BucketInfo.Logging.newBuilder();
        String logObjectPrefix = from.getLogObjectPrefix();
        if (!logObjectPrefix.isEmpty()) {
            to.setLogObjectPrefix(logObjectPrefix);
        }
        if (!(logBucket = from.getLogBucket()).isEmpty()) {
            to.setLogBucket((String)Utils.bucketNameCodec.decode(logBucket));
        }
        return to.build();
    }

    private Bucket.Cors corsEncode(Cors from) {
        Bucket.Cors.Builder to = Bucket.Cors.newBuilder();
        to.setMaxAgeSeconds(from.getMaxAgeSeconds().intValue());
        to.addAllResponseHeader(from.getResponseHeaders());
        Utils.ifNonNull(from.getMethods(), GrpcConversions.toImmutableListOf(java.lang.Object::toString), arg_0 -> ((Bucket.Cors.Builder)to).addAllMethod(arg_0));
        Utils.ifNonNull(from.getOrigins(), GrpcConversions.toImmutableListOf(java.lang.Object::toString), arg_0 -> ((Bucket.Cors.Builder)to).addAllOrigin(arg_0));
        return to.build();
    }

    private Cors corsDecode(Bucket.Cors from) {
        Cors.Builder to = Cors.newBuilder().setMaxAgeSeconds(from.getMaxAgeSeconds());
        Utils.ifNonNull(from.getMethodList(), m -> (ImmutableList)m.stream().map(String::toUpperCase).map(HttpMethod::valueOf).collect(ImmutableList.toImmutableList()), to::setMethods);
        Utils.ifNonNull(from.getOriginList(), GrpcConversions.toImmutableListOf(Cors.Origin::of), to::setOrigins);
        to.setResponseHeaders((Iterable<String>)from.getResponseHeaderList());
        return to.build();
    }

    private String entityEncode(Acl.Entity from) {
        if (from instanceof Acl.RawEntity) {
            return from.getValue();
        }
        if (from instanceof Acl.User) {
            switch (from.getValue()) {
                case "allAuthenticatedUsers": {
                    return "allAuthenticatedUsers";
                }
                case "allUsers": {
                    return "allUsers";
                }
            }
        }
        return from.getType().name().toLowerCase() + "-" + from.getValue();
    }

    private Acl.Entity entityDecode(String from) {
        if (from.startsWith("user-")) {
            return new Acl.User(from.substring(5));
        }
        if (from.equals("allUsers")) {
            return Acl.User.ofAllUsers();
        }
        if (from.equals("allAuthenticatedUsers")) {
            return Acl.User.ofAllAuthenticatedUsers();
        }
        if (from.startsWith("group-")) {
            return new Acl.Group(from.substring(6));
        }
        if (from.startsWith("domain-")) {
            return new Acl.Domain(from.substring(7));
        }
        if (from.startsWith("project-")) {
            int idx = from.indexOf(45, 8);
            String team = from.substring(8, idx);
            String projectId = from.substring(idx + 1);
            return new Acl.Project(Acl.Project.ProjectRole.valueOf(team.toUpperCase()), projectId);
        }
        return new Acl.RawEntity(from);
    }

    private Acl objectAclDecode(ObjectAccessControl from) {
        Acl.Role role = Acl.Role.valueOf(from.getRole());
        Acl.Entity entity = (Acl.Entity)this.entityCodec.decode(from.getEntity());
        Acl.Builder to = Acl.newBuilder(entity, role);
        if (!from.getId().isEmpty()) {
            to.setId(from.getId());
        }
        if (!from.getEtag().isEmpty()) {
            to.setEtag(from.getEtag());
        }
        return to.build();
    }

    private ObjectAccessControl objectAclEncode(Acl from) {
        ObjectAccessControl.Builder to = ObjectAccessControl.newBuilder();
        Utils.ifNonNull(from.getEntity(), this.entityCodec::encode, arg_0 -> ((ObjectAccessControl.Builder)to).setEntity(arg_0));
        Utils.ifNonNull(from.getRole(), StringEnumValue::name, arg_0 -> ((ObjectAccessControl.Builder)to).setRole(arg_0));
        Utils.ifNonNull(from.getId(), arg_0 -> ((ObjectAccessControl.Builder)to).setId(arg_0));
        Utils.ifNonNull(from.getEtag(), arg_0 -> ((ObjectAccessControl.Builder)to).setEtag(arg_0));
        return to.build();
    }

    private Acl bucketAclDecode(BucketAccessControl from) {
        Acl.Role role = Acl.Role.valueOf(from.getRole());
        Acl.Entity entity = this.entityDecode(from.getEntity());
        Acl.Builder to = Acl.newBuilder(entity, role).setId(from.getId());
        if (!from.getEtag().isEmpty()) {
            to.setEtag(from.getEtag());
        }
        return to.build();
    }

    private BucketAccessControl bucketAclEncode(Acl from) {
        BucketAccessControl.Builder to = BucketAccessControl.newBuilder();
        Utils.ifNonNull(from.getEntity(), this.entityCodec::encode, arg_0 -> ((BucketAccessControl.Builder)to).setEntity(arg_0));
        Utils.ifNonNull(from.getRole(), StringEnumValue::toString, arg_0 -> ((BucketAccessControl.Builder)to).setRole(arg_0));
        Utils.ifNonNull(from.getId(), arg_0 -> ((BucketAccessControl.Builder)to).setId(arg_0));
        Utils.ifNonNull(from.getEtag(), arg_0 -> ((BucketAccessControl.Builder)to).setEtag(arg_0));
        return to.build();
    }

    private Bucket.IamConfig.UniformBucketLevelAccess ublaEncode(BucketInfo.IamConfiguration from) {
        Bucket.IamConfig.UniformBucketLevelAccess.Builder to = Bucket.IamConfig.UniformBucketLevelAccess.newBuilder();
        Utils.ifNonNull(from.isUniformBucketLevelAccessEnabled(), arg_0 -> ((Bucket.IamConfig.UniformBucketLevelAccess.Builder)to).setEnabled(arg_0));
        if (from.isUniformBucketLevelAccessEnabled() == Boolean.TRUE) {
            Utils.ifNonNull(from.getUniformBucketLevelAccessLockedTimeOffsetDateTime(), this.timestampCodec::encode, arg_0 -> ((Bucket.IamConfig.UniformBucketLevelAccess.Builder)to).setLockTime(arg_0));
        }
        return to.build();
    }

    private BucketInfo.Autoclass autoclassDecode(Bucket.Autoclass from) {
        BucketInfo.Autoclass.Builder to = BucketInfo.Autoclass.newBuilder();
        to.setEnabled(from.getEnabled());
        Utils.ifNonNull(from.getToggleTime(), this.timestampCodec::decode, to::setToggleTime);
        String terminalStorageClass = from.getTerminalStorageClass();
        if (!terminalStorageClass.isEmpty()) {
            to.setTerminalStorageClass(StorageClass.valueOf(terminalStorageClass));
        }
        Utils.ifNonNull(from.getTerminalStorageClassUpdateTime(), this.timestampCodec::decode, to::setTerminalStorageClassUpdateTime);
        return to.build();
    }

    private Bucket.Autoclass autoclassEncode(BucketInfo.Autoclass from) {
        Bucket.Autoclass.Builder to = Bucket.Autoclass.newBuilder();
        Utils.ifNonNull(from.getEnabled(), arg_0 -> ((Bucket.Autoclass.Builder)to).setEnabled(arg_0));
        Utils.ifNonNull(from.getToggleTime(), this.timestampCodec::encode, arg_0 -> ((Bucket.Autoclass.Builder)to).setToggleTime(arg_0));
        Utils.ifNonNull(from.getTerminalStorageClass(), StringEnumValue::toString, arg_0 -> ((Bucket.Autoclass.Builder)to).setTerminalStorageClass(arg_0));
        Utils.ifNonNull(from.getTerminalStorageClassUpdateTime(), this.timestampCodec::encode, arg_0 -> ((Bucket.Autoclass.Builder)to).setTerminalStorageClassUpdateTime(arg_0));
        return to.build();
    }

    private BucketInfo.SoftDeletePolicy softDeletePolicyDecode(Bucket.SoftDeletePolicy from) {
        BucketInfo.SoftDeletePolicy.Builder to = BucketInfo.SoftDeletePolicy.newBuilder();
        Utils.ifNonNull(from.getRetentionDuration(), this.durationCodec::decode, to::setRetentionDuration);
        Utils.ifNonNull(from.getEffectiveTime(), this.timestampCodec::decode, to::setEffectiveTime);
        return to.build();
    }

    private Bucket.SoftDeletePolicy softDeletePolicyEncode(BucketInfo.SoftDeletePolicy from) {
        Bucket.SoftDeletePolicy.Builder to = Bucket.SoftDeletePolicy.newBuilder();
        Utils.ifNonNull(from.getRetentionDuration(), this.durationCodec::encode, arg_0 -> ((Bucket.SoftDeletePolicy.Builder)to).setRetentionDuration(arg_0));
        return to.build();
    }

    private Bucket.HierarchicalNamespace hierarchicalNamespaceEncode(BucketInfo.HierarchicalNamespace from) {
        Bucket.HierarchicalNamespace.Builder to = Bucket.HierarchicalNamespace.newBuilder();
        Utils.ifNonNull(from.getEnabled(), arg_0 -> ((Bucket.HierarchicalNamespace.Builder)to).setEnabled(arg_0));
        return to.build();
    }

    private BucketInfo.HierarchicalNamespace hierarchicalNamespaceDecode(Bucket.HierarchicalNamespace from) {
        BucketInfo.HierarchicalNamespace.Builder to = BucketInfo.HierarchicalNamespace.newBuilder();
        to.setEnabled(from.getEnabled());
        return to.build();
    }

    private Bucket.IamConfig iamConfigEncode(BucketInfo.IamConfiguration from) {
        Bucket.IamConfig.Builder to = Bucket.IamConfig.newBuilder();
        to.setUniformBucketLevelAccess(this.ublaEncode(from));
        if (from.getPublicAccessPrevention() != null) {
            Utils.ifNonNull(from.getPublicAccessPrevention().getValue(), arg_0 -> ((Bucket.IamConfig.Builder)to).setPublicAccessPrevention(arg_0));
        }
        return to.build();
    }

    private BucketInfo.IamConfiguration iamConfigDecode(Bucket.IamConfig from) {
        Bucket.IamConfig.UniformBucketLevelAccess ubla = from.getUniformBucketLevelAccess();
        BucketInfo.IamConfiguration.Builder to = BucketInfo.IamConfiguration.newBuilder();
        Utils.ifNonNull(ubla.getEnabled(), to::setIsUniformBucketLevelAccessEnabled);
        if (ubla.hasLockTime()) {
            to.setUniformBucketLevelAccessLockedTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(ubla.getLockTime()));
        }
        if (!from.getPublicAccessPrevention().isEmpty()) {
            to.setPublicAccessPrevention(BucketInfo.PublicAccessPrevention.parse(from.getPublicAccessPrevention()));
        }
        return to.build();
    }

    private Bucket.Lifecycle.Rule lifecycleRuleEncode(BucketInfo.LifecycleRule from) {
        Bucket.Lifecycle.Rule.Builder to = Bucket.Lifecycle.Rule.newBuilder();
        to.setAction(this.ruleActionEncode(from.getAction()));
        to.setCondition(this.ruleConditionEncode(from.getCondition()));
        return to.build();
    }

    private Bucket.Lifecycle.Rule.Condition ruleConditionEncode(BucketInfo.LifecycleRule.LifecycleCondition from) {
        Bucket.Lifecycle.Rule.Condition.Builder to = Bucket.Lifecycle.Rule.Condition.newBuilder();
        if (from.getAge() != null) {
            to.setAgeDays(from.getAge().intValue());
        }
        if (from.getIsLive() != null) {
            to.setIsLive(from.getIsLive().booleanValue());
        }
        if (from.getNumberOfNewerVersions() != null) {
            to.setNumNewerVersions(from.getNumberOfNewerVersions().intValue());
        }
        if (from.getDaysSinceNoncurrentTime() != null) {
            to.setDaysSinceNoncurrentTime(from.getDaysSinceNoncurrentTime().intValue());
        }
        if (from.getDaysSinceCustomTime() != null) {
            to.setDaysSinceCustomTime(from.getDaysSinceCustomTime().intValue());
        }
        Utils.ifNonNull(from.getCreatedBeforeOffsetDateTime(), this.odtDateCodec::encode, arg_0 -> ((Bucket.Lifecycle.Rule.Condition.Builder)to).setCreatedBefore(arg_0));
        Utils.ifNonNull(from.getNoncurrentTimeBeforeOffsetDateTime(), this.odtDateCodec::encode, arg_0 -> ((Bucket.Lifecycle.Rule.Condition.Builder)to).setNoncurrentTimeBefore(arg_0));
        Utils.ifNonNull(from.getCustomTimeBeforeOffsetDateTime(), this.odtDateCodec::encode, arg_0 -> ((Bucket.Lifecycle.Rule.Condition.Builder)to).setCustomTimeBefore(arg_0));
        Utils.ifNonNull(from.getMatchesStorageClass(), GrpcConversions.toImmutableListOf(StringEnumValue::toString), arg_0 -> ((Bucket.Lifecycle.Rule.Condition.Builder)to).addAllMatchesStorageClass(arg_0));
        Utils.ifNonNull(from.getMatchesPrefix(), arg_0 -> ((Bucket.Lifecycle.Rule.Condition.Builder)to).addAllMatchesPrefix(arg_0));
        Utils.ifNonNull(from.getMatchesSuffix(), arg_0 -> ((Bucket.Lifecycle.Rule.Condition.Builder)to).addAllMatchesSuffix(arg_0));
        return to.build();
    }

    private Bucket.Lifecycle.Rule.Action ruleActionEncode(BucketInfo.LifecycleRule.LifecycleAction from) {
        Bucket.Lifecycle.Rule.Action.Builder to = Bucket.Lifecycle.Rule.Action.newBuilder().setType(from.getActionType());
        if (from.getActionType().equals("SetStorageClass")) {
            to.setStorageClass(((BucketInfo.LifecycleRule.SetStorageClassLifecycleAction)from).getStorageClass().toString());
        }
        return to.build();
    }

    private BucketInfo.LifecycleRule lifecycleRuleDecode(Bucket.Lifecycle.Rule from) {
        BucketInfo.LifecycleRule.LifecycleAction lifecycleAction;
        Bucket.Lifecycle.Rule.Action action = from.getAction();
        switch (action.getType()) {
            case "Delete": {
                lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newDeleteAction();
                break;
            }
            case "SetStorageClass": {
                lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newSetStorageClassAction(StorageClass.valueOf(action.getStorageClass()));
                break;
            }
            case "AbortIncompleteMultipartUpload": {
                lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newAbortIncompleteMPUploadAction();
                break;
            }
            default: {
                BucketInfo.log.warning("The lifecycle action " + action.getType() + " is not supported by this version of the library. Attempting to update with this rule may cause errors. Please update to the latest version of google-cloud-storage.");
                lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newLifecycleAction("Unknown action");
            }
        }
        Bucket.Lifecycle.Rule.Condition condition = from.getCondition();
        BucketInfo.LifecycleRule.LifecycleCondition.Builder conditionBuilder = BucketInfo.LifecycleRule.LifecycleCondition.newBuilder();
        if (condition.hasAgeDays()) {
            conditionBuilder.setAge(condition.getAgeDays());
        }
        if (condition.hasCreatedBefore()) {
            conditionBuilder.setCreatedBeforeOffsetDateTime((OffsetDateTime)this.odtDateCodec.nullable().decode(condition.getCreatedBefore()));
        }
        if (condition.hasIsLive()) {
            conditionBuilder.setIsLive(condition.getIsLive());
        }
        if (condition.hasNumNewerVersions()) {
            conditionBuilder.setNumberOfNewerVersions(condition.getNumNewerVersions());
        }
        if (condition.hasDaysSinceNoncurrentTime()) {
            conditionBuilder.setDaysSinceNoncurrentTime(condition.getDaysSinceNoncurrentTime());
        }
        if (condition.hasNoncurrentTimeBefore()) {
            conditionBuilder.setNoncurrentTimeBeforeOffsetDateTime((OffsetDateTime)this.odtDateCodec.decode(condition.getNoncurrentTimeBefore()));
        }
        if (condition.hasCustomTimeBefore()) {
            conditionBuilder.setCustomTimeBeforeOffsetDateTime((OffsetDateTime)this.odtDateCodec.decode(condition.getCustomTimeBefore()));
        }
        if (condition.hasDaysSinceCustomTime()) {
            conditionBuilder.setDaysSinceCustomTime(condition.getDaysSinceCustomTime());
        }
        if (!condition.getMatchesStorageClassList().isEmpty()) {
            ImmutableList collect = (ImmutableList)condition.getMatchesStorageClassList().stream().map(StorageClass::valueOf).collect(ImmutableList.toImmutableList());
            conditionBuilder.setMatchesStorageClass((List<StorageClass>)collect);
        }
        if (!condition.getMatchesPrefixList().isEmpty()) {
            conditionBuilder.setMatchesPrefix((List<String>)condition.getMatchesPrefixList());
        }
        if (!condition.getMatchesSuffixList().isEmpty()) {
            conditionBuilder.setMatchesSuffix((List<String>)condition.getMatchesSuffixList());
        }
        return new BucketInfo.LifecycleRule(lifecycleAction, conditionBuilder.build());
    }

    private CustomerEncryption customerEncryptionEncode(BlobInfo.CustomerEncryption from) {
        return CustomerEncryption.newBuilder().setEncryptionAlgorithm(from.getEncryptionAlgorithm()).setKeySha256Bytes(ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)from.getKeySha256()))).build();
    }

    private BlobInfo.CustomerEncryption customerEncryptionDecode(CustomerEncryption from) {
        return new BlobInfo.CustomerEncryption(from.getEncryptionAlgorithm(), BaseEncoding.base64().encode(from.getKeySha256Bytes().toByteArray()));
    }

    private Object blobIdEncode(BlobId from) {
        Object.Builder to = Object.newBuilder();
        Utils.ifNonNull(from.getBucket(), Utils.bucketNameCodec::encode, arg_0 -> ((Object.Builder)to).setBucket(arg_0));
        Utils.ifNonNull(from.getName(), arg_0 -> ((Object.Builder)to).setName(arg_0));
        Utils.ifNonNull(from.getGeneration(), arg_0 -> ((Object.Builder)to).setGeneration(arg_0));
        return to.build();
    }

    private BlobId blobIdDecode(Object from) {
        String bucketName = (String)Utils.bucketNameCodec.decode(from.getBucket());
        return BlobId.of(bucketName, from.getName(), from.getGeneration());
    }

    private Object blobInfoEncode(BlobInfo from) {
        Object.Builder toBuilder = Object.newBuilder();
        Utils.ifNonNull(from.getBucket(), Utils.bucketNameCodec::encode, arg_0 -> ((Object.Builder)toBuilder).setBucket(arg_0));
        Utils.ifNonNull(from.getName(), arg_0 -> ((Object.Builder)toBuilder).setName(arg_0));
        Utils.ifNonNull(from.getGeneration(), arg_0 -> ((Object.Builder)toBuilder).setGeneration(arg_0));
        Utils.ifNonNull(from.getCacheControl(), arg_0 -> ((Object.Builder)toBuilder).setCacheControl(arg_0));
        Utils.ifNonNull(from.getSize(), arg_0 -> ((Object.Builder)toBuilder).setSize(arg_0));
        Utils.ifNonNull(from.getContentType(), arg_0 -> ((Object.Builder)toBuilder).setContentType(arg_0));
        Utils.ifNonNull(from.getContentEncoding(), arg_0 -> ((Object.Builder)toBuilder).setContentEncoding(arg_0));
        Utils.ifNonNull(from.getContentDisposition(), arg_0 -> ((Object.Builder)toBuilder).setContentDisposition(arg_0));
        Utils.ifNonNull(from.getContentLanguage(), arg_0 -> ((Object.Builder)toBuilder).setContentLanguage(arg_0));
        Utils.ifNonNull(from.getComponentCount(), arg_0 -> ((Object.Builder)toBuilder).setComponentCount(arg_0));
        if (from.getMd5() != null || from.getCrc32c() != null) {
            ObjectChecksums.Builder objectChecksums = ObjectChecksums.newBuilder();
            if (from.getMd5() != null) {
                objectChecksums.setMd5Hash(ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)from.getMd5())));
            }
            if (from.getCrc32c() != null) {
                objectChecksums.setCrc32C(((Integer)Utils.crc32cCodec.decode(from.getCrc32c())).intValue());
            }
            toBuilder.setChecksums(objectChecksums.build());
        }
        Utils.ifNonNull(from.getMetageneration(), arg_0 -> ((Object.Builder)toBuilder).setMetageneration(arg_0));
        Utils.ifNonNull(from.getDeleteTimeOffsetDateTime(), this.timestampCodec::encode, arg_0 -> ((Object.Builder)toBuilder).setDeleteTime(arg_0));
        Utils.ifNonNull(from.getUpdateTimeOffsetDateTime(), this.timestampCodec::encode, arg_0 -> ((Object.Builder)toBuilder).setUpdateTime(arg_0));
        Utils.ifNonNull(from.getCreateTimeOffsetDateTime(), this.timestampCodec::encode, arg_0 -> ((Object.Builder)toBuilder).setCreateTime(arg_0));
        Utils.ifNonNull(from.getCustomTimeOffsetDateTime(), this.timestampCodec::encode, arg_0 -> ((Object.Builder)toBuilder).setCustomTime(arg_0));
        Utils.ifNonNull(from.getSoftDeleteTime(), this.timestampCodec::encode, arg_0 -> ((Object.Builder)toBuilder).setSoftDeleteTime(arg_0));
        Utils.ifNonNull(from.getHardDeleteTime(), this.timestampCodec::encode, arg_0 -> ((Object.Builder)toBuilder).setHardDeleteTime(arg_0));
        Utils.ifNonNull(from.getCustomerEncryption(), this.customerEncryptionCodec::encode, arg_0 -> ((Object.Builder)toBuilder).setCustomerEncryption(arg_0));
        Utils.ifNonNull(from.getStorageClass(), StringEnumValue::toString, arg_0 -> ((Object.Builder)toBuilder).setStorageClass(arg_0));
        Utils.ifNonNull(from.getTimeStorageClassUpdatedOffsetDateTime(), this.timestampCodec::encode, arg_0 -> ((Object.Builder)toBuilder).setUpdateStorageClassTime(arg_0));
        Utils.ifNonNull(from.getKmsKeyName(), this::removeKmsVersion, arg_0 -> ((Object.Builder)toBuilder).setKmsKey(arg_0));
        Utils.ifNonNull(from.getEventBasedHold(), arg_0 -> ((Object.Builder)toBuilder).setEventBasedHold(arg_0));
        Utils.ifNonNull(from.getTemporaryHold(), arg_0 -> ((Object.Builder)toBuilder).setTemporaryHold(arg_0));
        Utils.ifNonNull(from.getRetentionExpirationTimeOffsetDateTime(), this.timestampCodec::encode, arg_0 -> ((Object.Builder)toBuilder).setRetentionExpireTime(arg_0));
        Utils.ifNonNull(from.getEtag(), arg_0 -> ((Object.Builder)toBuilder).setEtag(arg_0));
        Acl.Entity entity = from.getOwner();
        if (entity != null) {
            toBuilder.setOwner(Owner.newBuilder().setEntity(this.entityEncode(entity)).build());
        }
        Utils.ifNonNull(from.getMetadata(), this::removeNullValues, arg_0 -> ((Object.Builder)toBuilder).putAllMetadata(arg_0));
        Utils.ifNonNull(from.getAcl(), GrpcConversions.toImmutableListOf(this.objectAcl()::encode), arg_0 -> ((Object.Builder)toBuilder).addAllAcl(arg_0));
        return toBuilder.build();
    }

    private BlobInfo blobInfoDecode(Object from) {
        Owner owner;
        String storageClass;
        BlobInfo.Builder toBuilder = BlobInfo.newBuilder(BlobId.of((String)Utils.bucketNameCodec.decode(from.getBucket()), from.getName(), from.getGeneration()));
        Utils.ifNonNull(from.getCacheControl(), toBuilder::setCacheControl);
        Utils.ifNonNull(from.getSize(), toBuilder::setSize);
        Utils.ifNonNull(from.getContentType(), toBuilder::setContentType);
        Utils.ifNonNull(from.getContentEncoding(), toBuilder::setContentEncoding);
        Utils.ifNonNull(from.getContentDisposition(), toBuilder::setContentDisposition);
        Utils.ifNonNull(from.getContentLanguage(), toBuilder::setContentLanguage);
        Utils.ifNonNull(from.getComponentCount(), toBuilder::setComponentCount);
        if (from.hasChecksums()) {
            ByteString md5Hash;
            ObjectChecksums checksums = from.getChecksums();
            if (checksums.hasCrc32C()) {
                toBuilder.setCrc32c((String)Utils.crc32cCodec.encode(checksums.getCrc32C()));
            }
            if (!(md5Hash = checksums.getMd5Hash()).isEmpty()) {
                toBuilder.setMd5(BaseEncoding.base64().encode(md5Hash.toByteArray()));
            }
        }
        Utils.ifNonNull(from.getMetageneration(), toBuilder::setMetageneration);
        if (from.hasDeleteTime()) {
            toBuilder.setDeleteTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getDeleteTime()));
        }
        if (from.hasUpdateTime()) {
            toBuilder.setUpdateTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getUpdateTime()));
        }
        if (from.hasCreateTime()) {
            toBuilder.setCreateTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getCreateTime()));
        }
        if (from.hasCustomTime()) {
            toBuilder.setCustomTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getCustomTime()));
        }
        if (from.hasCustomerEncryption()) {
            toBuilder.setCustomerEncryption((BlobInfo.CustomerEncryption)this.customerEncryptionCodec.decode(from.getCustomerEncryption()));
        }
        if (from.hasSoftDeleteTime()) {
            toBuilder.setSoftDeleteTime((OffsetDateTime)this.timestampCodec.decode(from.getSoftDeleteTime()));
        }
        if (from.hasHardDeleteTime()) {
            toBuilder.setHardDeleteTime((OffsetDateTime)this.timestampCodec.decode(from.getHardDeleteTime()));
        }
        if (!(storageClass = from.getStorageClass()).isEmpty()) {
            toBuilder.setStorageClass(StorageClass.valueOf(storageClass));
        }
        if (from.hasUpdateStorageClassTime()) {
            toBuilder.setTimeStorageClassUpdatedOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getUpdateStorageClassTime()));
        }
        if (!from.getKmsKey().isEmpty()) {
            toBuilder.setKmsKeyName(from.getKmsKey());
        }
        if (from.hasEventBasedHold()) {
            toBuilder.setEventBasedHold(from.getEventBasedHold());
        }
        toBuilder.setTemporaryHold(from.getTemporaryHold());
        if (from.hasRetentionExpireTime()) {
            toBuilder.setRetentionExpirationTimeOffsetDateTime((OffsetDateTime)this.timestampCodec.decode(from.getRetentionExpireTime()));
        }
        if (!from.getMetadataMap().isEmpty()) {
            toBuilder.setMetadata(from.getMetadataMap());
        }
        if (from.hasOwner() && !(owner = from.getOwner()).getEntity().isEmpty()) {
            toBuilder.setOwner(this.entityDecode(owner.getEntity()));
        }
        if (!from.getEtag().isEmpty()) {
            toBuilder.setEtag(from.getEtag());
        }
        Utils.ifNonNull(from.getAclList(), GrpcConversions.toImmutableListOf(this.objectAcl()::decode), toBuilder::setAcl);
        return toBuilder.build();
    }

    private com.google.iam.v1.Policy policyEncode(Policy from) {
        Policy.Builder to = com.google.iam.v1.Policy.newBuilder();
        Utils.ifNonNull(from.getEtag(), this.byteStringB64StringCodec::decode, arg_0 -> ((Policy.Builder)to).setEtag(arg_0));
        Utils.ifNonNull(from.getVersion(), arg_0 -> ((Policy.Builder)to).setVersion(arg_0));
        from.getBindingsList().stream().map(this.bindingCodec::encode).forEach(arg_0 -> ((Policy.Builder)to).addBindings(arg_0));
        return to.build();
    }

    private Policy policyDecode(com.google.iam.v1.Policy from) {
        Policy.Builder to = Policy.newBuilder();
        ByteString etag = from.getEtag();
        if (!etag.isEmpty()) {
            to.setEtag((String)this.byteStringB64StringCodec.encode(etag));
        }
        to.setVersion(from.getVersion());
        List bindingsList = from.getBindingsList();
        if (!bindingsList.isEmpty()) {
            ImmutableList bindings = (ImmutableList)bindingsList.stream().map(this.bindingCodec::decode).collect(ImmutableList.toImmutableList());
            to.setBindings((List)bindings);
        }
        return to.build();
    }

    private com.google.iam.v1.Binding bindingEncode(Binding from) {
        Binding.Builder to = com.google.iam.v1.Binding.newBuilder();
        Utils.ifNonNull(from.getRole(), arg_0 -> ((Binding.Builder)to).setRole(arg_0));
        ImmutableList members = from.getMembers();
        if (!members.isEmpty()) {
            to.addAllMembers((Iterable)members);
        }
        Utils.ifNonNull(from.getCondition(), this.iamConditionCodec::encode, arg_0 -> ((Binding.Builder)to).setCondition(arg_0));
        return to.build();
    }

    private Binding bindingDecode(com.google.iam.v1.Binding from) {
        ProtocolStringList membersList;
        Binding.Builder to = Binding.newBuilder();
        String role = from.getRole();
        if (!role.isEmpty()) {
            to.setRole(role);
        }
        if (!(membersList = from.getMembersList()).isEmpty()) {
            to.setMembers((Iterable)membersList);
        }
        if (from.hasCondition()) {
            to.setCondition((Condition)this.iamConditionCodec.decode(from.getCondition()));
        }
        return to.build();
    }

    private Expr conditionEncode(Condition from) {
        Expr.Builder to = Expr.newBuilder();
        Utils.ifNonNull(from.getExpression(), arg_0 -> ((Expr.Builder)to).setExpression(arg_0));
        Utils.ifNonNull(from.getTitle(), arg_0 -> ((Expr.Builder)to).setTitle(arg_0));
        Utils.ifNonNull(from.getDescription(), arg_0 -> ((Expr.Builder)to).setDescription(arg_0));
        return to.build();
    }

    private Condition conditionDecode(Expr from) {
        String description;
        String title;
        Condition.Builder to = Condition.newBuilder();
        String expression = from.getExpression();
        if (!expression.isEmpty()) {
            to.setExpression(expression);
        }
        if (!(title = from.getTitle()).isEmpty()) {
            to.setTitle(title);
        }
        if (!(description = from.getDescription()).isEmpty()) {
            to.setDescription(description);
        }
        return to.build();
    }

    private Map<String, String> removeNullValues(Map<String, String> from) {
        HashMap<String, String> to = new HashMap<String, String>(from);
        to.values().removeAll(Collections.singleton(null));
        return to;
    }

    private String removeKmsVersion(String from) {
        PathTemplate versionedKmsTemplate = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{version}");
        if (versionedKmsTemplate.matches(from)) {
            Map res = versionedKmsTemplate.match(from);
            return CryptoKeyName.format((String)((String)res.get("project")), (String)((String)res.get("location")), (String)((String)res.get("key_ring")), (String)((String)res.get("crypto_key")));
        }
        return from;
    }

    private static <T> T todo() {
        throw new IllegalStateException("Not yet implemented");
    }

    private static <T1, T2> Function<List<T1>, ImmutableList<T2>> toImmutableListOf(Function<T1, T2> f) {
        return l -> (ImmutableList)l.stream().map(f).collect(ImmutableList.toImmutableList());
    }
}

