/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.encoding;

import com.google.cloud.firestore.encoding.BeanMapper;
import com.google.cloud.firestore.encoding.CustomClassMapper;
import com.google.cloud.firestore.encoding.DeserializeContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

class RecordMapper<T>
extends BeanMapper<T> {
    private static final Logger LOGGER = Logger.getLogger(RecordMapper.class.getName());
    private static final RecordInspector RECORD_INSPECTOR = new RecordInspector();
    private final Map<String, Method> accessors = new HashMap<String, Method>();
    private final Constructor<T> constructor;
    private final Map<String, Integer> constructorParamIndexes = new HashMap<String, Integer>();

    RecordMapper(Class<T> clazz) {
        super(clazz);
        this.constructor = RecordMapper.RECORD_INSPECTOR.getCanonicalConstructor(clazz);
        AnnotatedElement[] recordComponents = RecordMapper.RECORD_INSPECTOR.getRecordComponents(clazz);
        if (recordComponents.length == 0) {
            throw new RuntimeException("No properties to serialize found on class " + clazz.getName());
        }
        try {
            for (int i = 0; i < recordComponents.length; ++i) {
                Field field = clazz.getDeclaredField(RecordMapper.RECORD_INSPECTOR.getName(recordComponents[i]));
                String propertyName = this.propertyName(field);
                this.constructorParamIndexes.put(propertyName, i);
                this.accessors.put(propertyName, RecordMapper.RECORD_INSPECTOR.getAccessor(recordComponents[i]));
                this.applyFieldAnnotations(field);
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    Map<String, Object> serialize(T object, DeserializeContext.ErrorPath path) {
        this.verifyValidType(object);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Method> entry : this.accessors.entrySet()) {
            Object propertyValue;
            String property = entry.getKey();
            if (this.documentIdPropertyNames.contains(property)) continue;
            Method accessor = entry.getValue();
            try {
                propertyValue = accessor.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            Object serializedValue = this.getSerializedValue(property, propertyValue, path);
            result.put(property, serializedValue);
        }
        return result;
    }

    @Override
    T deserialize(Map<String, Object> values, Map<TypeVariable<Class<T>>, Type> types, DeserializeContext context) {
        Object[] constructorParams = new Object[this.constructor.getParameterCount()];
        HashSet<String> deserializedProperties = new HashSet<String>(values.size());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String propertyName = entry.getKey();
            if (this.accessors.containsKey(propertyName)) {
                Method accessor = this.accessors.get(propertyName);
                Type resolvedType = this.resolveType(accessor.getGenericReturnType(), types);
                DeserializeContext.ErrorPath childPath = context.errorPath.child(propertyName);
                Object value = CustomClassMapper.deserializeToType(entry.getValue(), resolvedType, context.newInstanceWithErrorPath(childPath));
                constructorParams[this.constructorParamIndexes.get((Object)propertyName).intValue()] = value;
                deserializedProperties.add(propertyName);
                continue;
            }
            String message = "No accessor for " + propertyName + " found on class " + this.getClazz().getName();
            if (this.isThrowOnUnknownProperties()) {
                throw new RuntimeException(message);
            }
            if (!this.isWarnOnUnknownProperties()) continue;
            LOGGER.warning(message);
        }
        this.populateDocumentIdProperties(types, context, constructorParams, deserializedProperties);
        try {
            return this.constructor.newInstance(constructorParams);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void populateDocumentIdProperties(Map<TypeVariable<Class<T>>, Type> types, DeserializeContext context, Object[] params, Set<String> deserializedProperties) {
        for (String docIdPropertyName : this.documentIdPropertyNames) {
            this.checkForDocIdConflict(docIdPropertyName, deserializedProperties, context);
            if (!this.accessors.containsKey(docIdPropertyName)) continue;
            Type resolvedType = this.resolveType(this.accessors.get(docIdPropertyName).getGenericReturnType(), types);
            Object id = resolvedType == String.class ? context.documentRef.getId() : context.documentRef;
            params[this.constructorParamIndexes.get((Object)docIdPropertyName).intValue()] = id;
        }
    }

    private static final class RecordInspector {
        private final Method _getRecordComponents;
        private final Method _getName;
        private final Method _getType;
        private final Method _getAccessor;

        private RecordInspector() {
            try {
                this._getRecordComponents = Class.class.getMethod("getRecordComponents", new Class[0]);
                Class<?> recordComponentClass = Class.forName("java.lang.reflect.RecordComponent");
                this._getName = recordComponentClass.getMethod("getName", new Class[0]);
                this._getType = recordComponentClass.getMethod("getType", new Class[0]);
                this._getAccessor = recordComponentClass.getMethod("getAccessor", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new IllegalStateException("Failed to access class or methods needed to support record serialization", e);
            }
        }

        private <T> Constructor<T> getCanonicalConstructor(Class<T> cls) {
            try {
                Class[] paramTypes = (Class[])Arrays.stream(this.getRecordComponents(cls)).map(this::getType).toArray(Class[]::new);
                Constructor<T> constructor = cls.getDeclaredConstructor(paramTypes);
                constructor.setAccessible(true);
                return constructor;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }

        private AnnotatedElement[] getRecordComponents(Class<?> recordType) {
            try {
                return (AnnotatedElement[])this._getRecordComponents.invoke(recordType, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to load components of record " + recordType.getName(), e);
            }
        }

        private Class<?> getType(AnnotatedElement recordComponent) {
            try {
                return (Class)this._getType.invoke((Object)recordComponent, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to get record component type", e);
            }
        }

        private String getName(AnnotatedElement recordComponent) {
            try {
                return (String)this._getName.invoke((Object)recordComponent, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to get record component name", e);
            }
        }

        private Method getAccessor(AnnotatedElement recordComponent) {
            try {
                Method accessor = (Method)this._getAccessor.invoke((Object)recordComponent, new Object[0]);
                accessor.setAccessible(true);
                return accessor;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to get record component accessor", e);
            }
        }
    }
}

