/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.ruby;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.maven.polyglot.io.ModelWriterSupport;
import org.sonatype.maven.polyglot.ruby.RubyPrintWriter;

@Singleton
@Named(value="ruby")
public class RubyModelWriter
extends ModelWriterSupport {
    protected Logger log = LoggerFactory.getLogger(RubyModelWriter.class);

    public void write(Writer output, Map<String, Object> options, Model model) throws IOException {
        assert (output != null);
        assert (model != null);
        ModelPrinter p = new ModelPrinter(output);
        p.print(model);
    }

    static class ModelPrinter {
        private final RubyPrintWriter p;

        ModelPrinter(Writer output) {
            this.p = new RubyPrintWriter(output);
        }

        void print(Model model) {
            this.project(model);
            this.p.flush();
            this.p.close();
        }

        void repositories(Repository ... repositories) {
            this.printRepositories("repository", repositories);
            if (repositories.length > 0) {
                this.p.println();
            }
        }

        void pluginRepositories(Repository ... repositories) {
            this.printRepositories("plugin_repository", repositories);
            if (repositories.length > 0) {
                this.p.println();
            }
        }

        void distribution(DistributionManagement distribution) {
            if (distribution != null) {
                this.p.printStartBlock("distribution");
                if (distribution.getRepository() != null) {
                    this.printRepositories("repository", new Repository[]{distribution.getRepository()});
                }
                if (distribution.getSnapshotRepository() != null) {
                    this.printRepositories("snapshot_repository", new Repository[]{distribution.getSnapshotRepository()});
                }
                if (distribution.getSite() != null) {
                    Site site = distribution.getSite();
                    this.p.printWithOptions("site", this.options("id", site.getId(), "name", site.getName(), "url", site.getUrl()), new String[0]);
                }
                this.p.printEndBlock();
                this.p.println();
            }
        }

        private Map<String, Object> options(Object ... args) {
            LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
            String key = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                if (key == null) {
                    key = arg.toString();
                } else {
                    if (arg != null) {
                        options.put(key, arg);
                    }
                    key = null;
                }
                ++n2;
            }
            return options;
        }

        void sourceControl(Scm scm) {
            if (scm != null) {
                this.p.printWithOptions("source_control", this.options("url", scm.getUrl(), "connection", scm.getConnection(), "developer_connection", scm.getDeveloperConnection(), "tag", scm.getTag().equals("HEAD") ? null : scm.getTag()), new String[0]);
                this.p.println();
            }
        }

        private void printRepositories(String name, Repository ... repositories) {
            Repository[] repositoryArray = repositories;
            int n = repositories.length;
            int n2 = 0;
            while (n2 < n) {
                Repository r = repositoryArray[n2];
                if (r.getReleases() == null && r.getSnapshots() == null) {
                    this.p.printWithOptions(name, this.options("id", r.getId(), "name", r.getName(), "url", r.getUrl()), new String[0]);
                } else {
                    this.p.printStartBlock(name, this.options("id", r.getId(), "name", r.getName(), "url", r.getUrl()), new String[0]);
                    this.printRepositoryPolicy("releases", r.getReleases());
                    this.printRepositoryPolicy("snapshots", r.getSnapshots());
                    this.p.printEndBlock();
                }
                ++n2;
            }
        }

        private void printRepositoryPolicy(String name, RepositoryPolicy policy) {
            if (policy != null) {
                if (policy.getChecksumPolicy() == null && policy.getUpdatePolicy() == null) {
                    this.p.println(String.valueOf(name) + " " + policy.isEnabled());
                } else {
                    this.p.println("TODO: " + policy);
                }
            }
        }

        void project(Model model) {
            String name = model.getName();
            if (name == null) {
                name = model.getArtifactId();
            }
            this.p.printStartBlock("project", name, model.getUrl());
            this.p.println();
            this.p.println("model_version", model.getModelVersion());
            this.p.println("inception_year", model.getInceptionYear());
            this.id(model);
            this.parent(model.getParent());
            this.p.println("packaging", model.getPackaging());
            this.p.println();
            this.description(model.getDescription());
            this.developers(model.getDevelopers());
            this.issueManagement(model.getIssueManagement());
            this.mailingLists(model.getMailingLists());
            this.repositories(this.toRepositoryArray(model.getRepositories()));
            this.pluginRepositories(this.toRepositoryArray(model.getPluginRepositories()));
            this.sourceControl(model.getScm());
            this.distribution(model.getDistributionManagement());
            this.properties(model.getProperties());
            this.dependencies(model.getDependencies());
            this.modules(model.getModules());
            this.managements(model.getDependencyManagement(), (BuildBase)model.getBuild());
            this.build((BuildBase)model.getBuild(), model.getBuild());
            this.profiles(model.getProfiles());
            this.reporting(model.getReporting());
            this.p.printEndBlock();
        }

        private void mailingLists(List<MailingList> mailingLists) {
            for (MailingList list : mailingLists) {
                this.p.printStartBlock("mailing_list", list.getName());
                this.p.println("subscribe", list.getSubscribe());
                this.p.println("unsubscribe", list.getUnsubscribe());
                this.p.println("post", list.getPost());
                list.getOtherArchives().add(0, list.getArchive());
                this.p.println("archives", this.toArray(list.getOtherArchives()));
                list.getOtherArchives().remove(0);
                this.p.printEndBlock();
                this.p.println();
            }
        }

        private void issueManagement(IssueManagement issueManagement) {
            if (issueManagement != null) {
                this.p.println("issue_management", issueManagement.getUrl(), issueManagement.getSystem());
                this.p.println();
            }
        }

        private void developers(List<Developer> developers) {
            for (Developer dev : developers) {
                this.p.printStartBlock("developer", dev.getId());
                this.p.println("name", dev.getName());
                this.p.println("email", dev.getEmail());
                this.p.println("roles", this.toArray(dev.getRoles()));
                this.p.printEndBlock();
                this.p.println();
            }
        }

        void reporting(Reporting reporting) {
            if (reporting != null) {
                this.p.printStartBlock("reporting");
                this.plugins(reporting.getPlugins());
                this.p.printEndBlock();
                this.p.println();
            }
        }

        void profiles(List<Profile> profiles) {
            if (profiles != null) {
                for (Profile profile : profiles) {
                    this.p.print("profile");
                    if (profile.getId() == null) continue;
                    this.p.append(" '").append(profile.getId()).append("'");
                    this.p.printStartBlock();
                    this.p.println();
                    if (profile.getActivation() != null) {
                        ActivationOS os;
                        String jdk;
                        ActivationFile file;
                        LinkedHashMap<String, Object> options;
                        Activation activation = profile.getActivation();
                        this.p.printStartBlock("activation");
                        ActivationProperty prop = activation.getProperty();
                        if (prop != null) {
                            options = new LinkedHashMap<String, Object>();
                            options.put("name", prop.getName());
                            if (prop.getValue() != null) {
                                options.put("value", prop.getValue());
                            }
                            this.p.printWithOptions("property", options, new String[0]);
                        }
                        if ((file = activation.getFile()) != null) {
                            options = new LinkedHashMap();
                            if (file.getExists() != null) {
                                options.put("exists", file.getExists());
                            }
                            if (file.getMissing() != null) {
                                options.put("missing", file.getMissing());
                            }
                            this.p.printWithOptions("file", options, new String[0]);
                        }
                        if ((jdk = activation.getJdk()) != null) {
                            this.p.print("jdk", jdk);
                        }
                        if (activation.isActiveByDefault()) {
                            this.p.print("active_by_default", "true");
                        }
                        if ((os = activation.getOs()) != null) {
                            options = new LinkedHashMap();
                            if (os.getArch() != null) {
                                options.put("arch", os.getArch());
                            }
                            if (os.getFamily() != null) {
                                options.put("family", os.getFamily());
                            }
                            if (os.getName() != null) {
                                options.put("name", os.getName());
                            }
                            if (os.getVersion() != null) {
                                options.put("version", os.getVersion());
                            }
                            this.p.printWithOptions("os", options, new String[0]);
                        }
                        this.p.printEndBlock();
                        this.p.println();
                    }
                    this.repositories(this.toRepositoryArray(profile.getRepositories()));
                    this.pluginRepositories(this.toRepositoryArray(profile.getPluginRepositories()));
                    this.distribution(profile.getDistributionManagement());
                    this.properties(profile.getProperties());
                    this.dependencies(profile.getDependencies());
                    this.modules(profile.getModules());
                    this.managements(profile.getDependencyManagement(), profile.getBuild());
                    this.build(profile.getBuild());
                    this.reporting(profile.getReporting());
                    this.p.printEndBlock();
                    this.p.println();
                }
            }
        }

        void description(String description) {
            if (description != null) {
                this.p.println("description", description);
                this.p.println();
            }
        }

        void build(BuildBase build) {
            this.build(build, null);
        }

        void build(BuildBase build, Build b) {
            if (build != null) {
                this.plugins(build.getPlugins());
                if (build.getDefaultGoal() != null || build.getDirectory() != null || b != null && (b.getOutputDirectory() != null || b.getTestOutputDirectory() != null || b.getSourceDirectory() != null || b.getTestSourceDirectory() != null) || build.getFinalName() != null || build.getResources().size() > 0 || build.getTestResources().size() > 0) {
                    this.p.println();
                    this.p.printStartBlock("build");
                    if (build.getDefaultGoal() != null) {
                        this.p.println("default_goal", build.getDefaultGoal());
                    }
                    if (build.getDirectory() != null) {
                        this.p.println("directory", build.getDirectory());
                    }
                    if (b != null) {
                        if (b.getOutputDirectory() != null) {
                            this.p.println("output_directory", b.getOutputDirectory());
                        }
                        if (b.getTestOutputDirectory() != null) {
                            this.p.println("test_output_directory", b.getTestOutputDirectory());
                        }
                        if (b.getSourceDirectory() != null) {
                            this.p.println("source_directory", b.getSourceDirectory());
                        }
                        if (b.getTestSourceDirectory() != null) {
                            this.p.println("test_source_directory", b.getTestSourceDirectory());
                        }
                    }
                    if (build.getFinalName() != null) {
                        this.p.println("final_name", build.getFinalName());
                    }
                    this.resource("resource", build.getResources());
                    this.resource("test_resource", build.getTestResources());
                    this.p.printEndBlock();
                    this.p.println();
                }
            }
        }

        private void resource(String name, List<Resource> resources) {
            for (Resource resource : resources) {
                this.p.println();
                this.p.printStartBlock(name);
                this.p.println("directory", resource.getDirectory());
                this.p.println("includes", this.toArray(resource.getIncludes()));
                this.p.println("excludes", this.toArray(resource.getExcludes()));
                this.p.println("target_path", resource.getTargetPath());
                this.p.println("filtering", resource.isFiltering() ? "true" : null);
                this.p.printEndBlock();
            }
        }

        void managements(DependencyManagement dependencyManagement, BuildBase build) {
            if (dependencyManagement != null && !dependencyManagement.getDependencies().isEmpty() || build != null && build.getPluginManagement() != null && !build.getPluginManagement().getPlugins().isEmpty()) {
                this.p.printStartBlock("overrides");
                if (dependencyManagement != null) {
                    this.dependencies(dependencyManagement.getDependencies());
                }
                if (build != null && build.getPluginManagement() != null) {
                    this.plugins(build.getPluginManagement().getPlugins());
                }
                this.p.printEndBlock();
                this.p.println();
            }
        }

        void id(Model model) {
            String version;
            String groupId = model.getGroupId();
            if (groupId == null & model.getParent() != null) {
                groupId = model.getParent().getGroupId();
            }
            if ((version = model.getVersion()) == null && model.getParent() != null) {
                version = model.getParent().getVersion();
            }
            this.p.println("id", String.valueOf(groupId) + ":" + model.getArtifactId() + ":" + version);
        }

        void parent(Parent parent) {
            if (parent != null) {
                this.p.print("inherit", String.valueOf(parent.getGroupId()) + ":" + parent.getArtifactId() + ":" + parent.getVersion());
                if (parent.getRelativePath() != null) {
                    if (parent.getRelativePath().equals("../pom.xml")) {
                        this.p.println();
                    } else {
                        this.p.append(", '" + parent.getRelativePath() + "'").println();
                    }
                } else {
                    this.p.println();
                }
            }
        }

        void properties(Properties properties) {
            if (!properties.isEmpty()) {
                ArrayList<Object> keys = new ArrayList<Object>(properties.keySet());
                String prefix = "properties( ";
                String indent = prefix.replaceAll(".", " ");
                this.p.print(prefix);
                int i = 0;
                while (i < keys.size()) {
                    Object value;
                    Object key = keys.get(i);
                    if (i != 0) {
                        this.p.print(indent);
                    }
                    if ((value = properties.get(key)) != null) {
                        if (value instanceof String) {
                            this.p.append("'" + key + "' => '" + value + "'");
                        } else {
                            this.p.append("'" + key + "' => " + value);
                        }
                        if (i + 1 != keys.size()) {
                            this.p.append(",");
                        } else {
                            this.p.append(" )");
                        }
                        this.p.println();
                    }
                    ++i;
                }
                this.p.println();
            }
        }

        void modules(List<String> modules) {
            if (!modules.isEmpty()) {
                this.p.print("modules [ ");
                int i = 0;
                while (i < modules.size()) {
                    String module = modules.get(i);
                    if (i != 0) {
                        this.p.append("            ");
                    }
                    this.p.append("'").append(module).append("'");
                    if (i + 1 != modules.size()) {
                        this.p.append(",").println();
                    }
                    ++i;
                }
                this.p.append(" ]").println();
                this.p.println();
            }
        }

        void dependencies(List<Dependency> deps) {
            int i = 0;
            while (i < deps.size()) {
                Dependency d = deps.get(i);
                HashMap<String, Object> options = new HashMap<String, Object>();
                String gav = d.getVersion() != null ? String.valueOf(d.getGroupId()) + ":" + d.getArtifactId() + ":" + d.getVersion() : String.valueOf(d.getGroupId()) + ":" + d.getArtifactId();
                if (d.getClassifier() != null) {
                    if (d.getVersion() == null) {
                        options.put("classifier", d.getClassifier());
                    } else {
                        gav = String.valueOf(gav) + ":" + d.getClassifier();
                    }
                }
                if (d.getScope() != null) {
                    options.put("scope", d.getScope());
                }
                if (d.getOptional() != null) {
                    options.put("optional", d.isOptional());
                }
                if (d.getExclusions().size() == 1) {
                    Exclusion e = (Exclusion)d.getExclusions().get(0);
                    String ga = String.valueOf(e.getGroupId()) + ":" + e.getArtifactId();
                    options.put("exclusions", ga);
                } else if (d.getExclusions().size() > 1) {
                    ArrayList<String> exclusions = new ArrayList<String>(d.getExclusions().size());
                    for (Exclusion e : d.getExclusions()) {
                        String ga = String.valueOf(e.getGroupId()) + ":" + e.getArtifactId();
                        exclusions.add(ga);
                    }
                    options.put("exclusions", exclusions);
                }
                String prefix = options.size() == 0 ? String.valueOf(d.getType()) + " " : String.valueOf(d.getType()) + "( ";
                String indent = prefix.replaceAll(".", " ");
                this.p.print(prefix);
                this.p.append("'").append(gav).append("'");
                if (options.size() > 0) {
                    for (Map.Entry item : options.entrySet()) {
                        this.p.append(",");
                        this.p.println();
                        this.p.print(indent);
                        this.p.append(":");
                        this.p.append((CharSequence)item.getKey());
                        this.p.append(" => ");
                        if (item.getValue() instanceof String) {
                            this.p.append("'");
                            this.p.append(item.getValue().toString());
                            this.p.append("'");
                            continue;
                        }
                        if (item.getValue() instanceof Boolean) {
                            this.p.append(item.getValue().toString());
                            continue;
                        }
                        List list = (List)item.getValue();
                        boolean first = true;
                        this.p.append("[ ");
                        for (String ex : list) {
                            if (first) {
                                first = false;
                            } else {
                                this.p.append(",");
                                this.p.println();
                                this.p.print(indent);
                                this.p.append("                 ");
                            }
                            this.p.append("'");
                            this.p.append(ex);
                            this.p.append("'");
                        }
                        this.p.append(" ]");
                    }
                    this.p.append(" )");
                }
                this.p.println();
                ++i;
            }
            if (!deps.isEmpty()) {
                this.p.println();
            }
        }

        <T extends ConfigurationContainer> void plugins(List<T> plugins) {
            int i = 0;
            while (i < plugins.size()) {
                ConfigurationContainer container = (ConfigurationContainer)plugins.get(i);
                String prefix = container.getConfiguration() == null ? "plugin " : "plugin( ";
                String indent = prefix.replaceAll(".", " ");
                this.p.print(prefix);
                Plugin plugin = null;
                ReportPlugin rplugin = null;
                if (container instanceof Plugin) {
                    plugin = (Plugin)container;
                    this.pluginProlog(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion());
                } else {
                    rplugin = (ReportPlugin)container;
                    this.pluginProlog(rplugin.getGroupId(), rplugin.getArtifactId(), rplugin.getVersion());
                }
                if (!container.isInherited()) {
                    this.p.append(", ");
                    this.p.appendName("inherited").append(" => false");
                }
                if (plugin != null && plugin.isExtensions()) {
                    this.p.append(", ");
                    this.p.appendName("extensions").append(" => true");
                }
                this.p.printConfiguration(indent, container.getConfiguration());
                if (!(plugin == null || plugin.getExecutions().isEmpty() && plugin.getDependencies().isEmpty())) {
                    this.p.printStartBlock();
                    this.dependencies(plugin.getDependencies());
                    for (PluginExecution exec : plugin.getExecutions()) {
                        this.p.printWithOptions("execute_goals", this.options("id", "default".equals(exec.getId()) ? null : exec.getId(), "inherited", exec.isInherited() ? null : "false", "phase", exec.getPhase()), exec.getConfiguration(), this.toArray(exec.getGoals()));
                    }
                    this.p.printEndBlock();
                }
                if (rplugin != null && !rplugin.getReportSets().isEmpty()) {
                    this.p.printStartBlock();
                    for (ReportSet set : rplugin.getReportSets()) {
                        this.p.printWithOptions("report_set", this.options("id", "default".equals(set.getId()) ? null : set.getId(), "inherited", set.isInherited() ? null : "false"), set.getConfiguration(), this.toArray(set.getReports()));
                    }
                    this.p.printEndBlock();
                }
                this.p.println();
                ++i;
            }
        }

        private String[] toArray(List<String> list) {
            return list.toArray(new String[list.size()]);
        }

        private Repository[] toRepositoryArray(List<Repository> list) {
            return list.toArray(new Repository[list.size()]);
        }

        private void pluginProlog(String groupId, String artifactId, String version) {
            if ("org.apache.maven.plugins".equals(groupId) && artifactId.startsWith("maven-")) {
                String name = artifactId.replaceAll("maven-|-plugin", "");
                if (name.contains("-")) {
                    this.p.append(":'").append(name).append("'");
                } else {
                    this.p.append(":").append(name);
                }
                if (version != null) {
                    this.p.append(", '").append(version).append("'");
                }
            } else {
                this.p.append("'").append(groupId).append(":").append(artifactId);
                if (version != null) {
                    this.p.append(":").append(version);
                }
                this.p.append("'");
            }
        }
    }
}

