/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.commands;

import org.keycloak.client.admin.cli.KcAdmMain;
import org.keycloak.client.cli.common.BaseConfigCredentialsCmd;
import org.keycloak.client.cli.config.ConfigData;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.IoUtil;
import picocli.CommandLine;

@CommandLine.Command(name="credentials", description={"--server SERVER_URL --realm REALM [ARGUMENTS]"})
public class ConfigCredentialsCmd
extends BaseConfigCredentialsCmd {
    @CommandLine.Option(names={"--status"}, description={"Validity of the connection with server"})
    boolean status;

    public ConfigCredentialsCmd() {
        super(KcAdmMain.COMMAND_STATE);
    }

    @Override
    protected boolean nothingToDo() {
        return super.nothingToDo() && !this.status;
    }

    @Override
    public void process() {
        if (this.status) {
            ConfigData config = ConfigUtil.loadConfig();
            long now = System.currentTimeMillis();
            if (ConfigUtil.credentialsAvailable(config) && now + 5000L < config.sessionRealmConfigData().getExpiresAt()) {
                IoUtil.printOut("Logged in (server: " + config.getServerUrl() + ", realm: " + config.getRealm() + ", expired: false, timeToExpiry: " + (config.sessionRealmConfigData().getExpiresAt() - now) / 1000L + "s from now)");
            } else {
                IoUtil.printOut("You are not logged in");
            }
        } else {
            super.process();
        }
    }
}

