/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.jaxrs;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Variant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class VariantListBuilderImpl
extends Variant.VariantListBuilder {
    private final ArrayList<Variant> variants = new ArrayList();
    private final ArrayList<Locale> currentLanguages = new ArrayList();
    private final ArrayList<String> currentEncodings = new ArrayList();
    private final ArrayList<MediaType> currentTypes = new ArrayList();

    public List<Variant> build() {
        this.add();
        ArrayList<Variant> copy = new ArrayList<Variant>(this.variants);
        this.variants.clear();
        this.currentLanguages.clear();
        this.currentEncodings.clear();
        this.currentTypes.clear();
        return copy;
    }

    public Variant.VariantListBuilder add() {
        int langSize = this.currentLanguages.size();
        int encodingSize = this.currentEncodings.size();
        int typeSize = this.currentTypes.size();
        int i = 0;
        if (langSize == 0 && encodingSize == 0 && typeSize == 0) {
            return this;
        }
        do {
            MediaType type = null;
            if (i < typeSize) {
                type = this.currentTypes.get(i);
            }
            int j = 0;
            do {
                String encoding = null;
                if (j < encodingSize) {
                    encoding = this.currentEncodings.get(j);
                }
                int k = 0;
                do {
                    Locale language = null;
                    if (k < langSize) {
                        language = this.currentLanguages.get(k);
                    }
                    this.variants.add(new Variant(type, language, encoding));
                } while (++k < langSize);
            } while (++j < encodingSize);
        } while (++i < typeSize);
        this.currentLanguages.clear();
        this.currentEncodings.clear();
        this.currentTypes.clear();
        return this;
    }

    public Variant.VariantListBuilder languages(Locale ... languages) {
        this.currentLanguages.addAll(Arrays.asList(languages));
        return this;
    }

    public Variant.VariantListBuilder encodings(String ... encodings) {
        this.currentEncodings.addAll(Arrays.asList(encodings));
        return this;
    }

    public Variant.VariantListBuilder mediaTypes(MediaType ... mediaTypes) {
        this.currentTypes.addAll(Arrays.asList(mediaTypes));
        return this;
    }
}

