/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.internal.Describables;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.buildtree.BuildTreeFinishExecutor;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeModelAction;
import org.gradle.internal.buildtree.BuildTreeModelCreator;
import org.gradle.internal.buildtree.BuildTreeWorkController;
import org.gradle.internal.model.StateTransitionController;
import org.gradle.internal.model.StateTransitionControllerFactory;

public class DefaultBuildTreeLifecycleController
implements BuildTreeLifecycleController {
    private final BuildLifecycleController buildLifecycleController;
    private final BuildTreeWorkController workController;
    private final BuildTreeModelCreator modelCreator;
    private final BuildTreeFinishExecutor finishExecutor;
    private final StateTransitionController<State> state;

    public DefaultBuildTreeLifecycleController(BuildLifecycleController buildLifecycleController, BuildTreeWorkController workController, BuildTreeModelCreator modelCreator, BuildTreeFinishExecutor finishExecutor, StateTransitionControllerFactory controllerFactory) {
        this.buildLifecycleController = buildLifecycleController;
        this.workController = workController;
        this.modelCreator = modelCreator;
        this.finishExecutor = finishExecutor;
        this.state = controllerFactory.newController(Describables.of((Object)"build tree state"), State.NotStarted);
    }

    @Override
    public void beforeBuild(Consumer<? super GradleInternal> action) {
        this.state.inState(State.NotStarted, () -> action.accept(this.buildLifecycleController.getGradle()));
    }

    @Override
    public void scheduleAndRunTasks() {
        this.scheduleAndRunTasks(null);
    }

    @Override
    public void scheduleAndRunTasks(EntryTaskSelector selector) {
        this.runBuild(() -> this.workController.scheduleAndRunRequestedTasks(selector));
    }

    @Override
    public <T> T fromBuildModel(boolean runTasks, BuildTreeModelAction<? extends T> action) {
        return this.runBuild(() -> {
            ExecutionResult<Void> result;
            this.modelCreator.beforeTasks(action);
            if (runTasks && !(result = this.workController.scheduleAndRunRequestedTasks(null)).getFailures().isEmpty()) {
                return result.asFailure();
            }
            Object model = this.modelCreator.fromBuildModel(action);
            return ExecutionResult.succeeded(model);
        });
    }

    @Override
    public <T> T withEmptyBuild(Function<? super SettingsInternal, T> action) {
        return this.runBuild(() -> {
            Object result = this.buildLifecycleController.withSettings(action);
            return ExecutionResult.succeeded(result);
        });
    }

    private <T> T runBuild(Supplier<ExecutionResult<? extends T>> action) {
        return (T)this.state.transition(State.NotStarted, State.Complete, () -> {
            ExecutionResult result;
            try {
                result = (ExecutionResult)action.get();
            }
            catch (Throwable t) {
                result = ExecutionResult.failed(t);
            }
            RuntimeException finalReportableFailure = this.finishExecutor.finishBuildTree(result.getFailures());
            if (finalReportableFailure != null) {
                throw finalReportableFailure;
            }
            return result.getValue();
        });
    }

    private static enum State implements StateTransitionController.State
    {
        NotStarted,
        Complete;

    }
}

