/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.option.ModOption;
import net.sf.freecol.common.resources.ResourceManager;

public final class ModOptionUI
extends OptionUI<ModOption> {
    private final GUI gui;
    private final JComboBox<FreeColModFile> box;

    public ModOptionUI(GUI gui, ModOption option, boolean editable) {
        super(option, editable);
        this.gui = gui;
        DefaultComboBoxModel<FreeColModFile> model = new DefaultComboBoxModel<FreeColModFile>();
        for (FreeColModFile choice : option.getChoices()) {
            model.addElement(choice);
        }
        this.box = new JComboBox();
        this.box.setModel(model);
        this.box.setRenderer(new BoxRenderer(gui));
        if (option.getValue() != null) {
            this.box.setSelectedItem(option.getValue());
        }
        this.initialize();
    }

    private static void labelModFile(GUI gui, JLabel label, FreeColModFile modFile) {
        boolean containsSpecification;
        String key = "mod." + modFile.getId();
        label.setText(Messages.getName(key));
        if (Messages.containsKey(Messages.shortDescriptionKey(key))) {
            label.setToolTipText(Messages.getShortDescription(key));
        }
        if (containsSpecification = modFile.hasSpecification()) {
            label.setIcon(new ImageIcon(ResourceManager.getImage("image.ui.includesSpecification")));
        } else {
            label.setIcon(new ImageIcon(ResourceManager.getImage("image.ui.noSpecification")));
        }
        boolean shouldBeEnabled = gui.canGameChangingModsBeAdded() || !containsSpecification;
        label.setEnabled(shouldBeEnabled);
    }

    @Override
    public ListCellRenderer getListCellRenderer() {
        return new ModOptionRenderer(this.gui);
    }

    @Override
    public void updateOption() {
        ((ModOption)this.getOption()).setValue((FreeColModFile)this.box.getSelectedItem());
    }

    @Override
    public JComboBox getComponent() {
        return this.box;
    }

    @Override
    public void reset() {
        this.box.setSelectedItem(((ModOption)this.getOption()).getValue());
    }

    private static class ModOptionRenderer
    extends FreeColComboBoxRenderer<ModOption> {
        private final GUI gui;

        private ModOptionRenderer(GUI gui) {
            this.gui = gui;
        }

        @Override
        public void setLabelValues(JLabel label, ModOption value) {
            FreeColModFile modFile = value.getValue();
            if (modFile == null) {
                label.setText(value.toString());
            } else {
                ModOptionUI.labelModFile(this.gui, label, modFile);
            }
        }
    }

    private static class BoxRenderer
    extends FreeColComboBoxRenderer<FreeColModFile> {
        private final GUI gui;

        private BoxRenderer(GUI gui) {
            this.gui = gui;
        }

        @Override
        public void setLabelValues(JLabel label, FreeColModFile value) {
            if (value != null) {
                ModOptionUI.labelModFile(this.gui, label, value);
            }
        }
    }
}

