/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.namespace;

import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;

public final class NameSpaceHelper {
    public static DependencyDescriptor toSystem(DependencyDescriptor dependencyDescriptor, Namespace namespace) {
        return DefaultDependencyDescriptor.transformInstance(dependencyDescriptor, namespace);
    }

    public static DependencyDescriptor transform(DependencyDescriptor dependencyDescriptor, NamespaceTransformer namespaceTransformer, boolean bl) {
        return DefaultDependencyDescriptor.transformInstance(dependencyDescriptor, namespaceTransformer, bl);
    }

    public static ModuleDescriptor toSystem(ModuleDescriptor moduleDescriptor, Namespace namespace) {
        return DefaultModuleDescriptor.transformInstance(moduleDescriptor, namespace);
    }

    public static Artifact transform(Artifact artifact, NamespaceTransformer object) {
        if (object.isIdentity()) {
            return artifact;
        }
        object = object.transform(artifact.getModuleRevisionId());
        if (artifact.getModuleRevisionId().equals(object)) {
            return artifact;
        }
        return new DefaultArtifact((ModuleRevisionId)object, artifact.getPublicationDate(), artifact.getName(), artifact.getType(), artifact.getExt(), artifact.getUrl(), artifact.getQualifiedExtraAttributes());
    }

    public static MetadataArtifactDownloadReport transform(MetadataArtifactDownloadReport metadataArtifactDownloadReport, NamespaceTransformer object) {
        if (object.isIdentity()) {
            return metadataArtifactDownloadReport;
        }
        object = new MetadataArtifactDownloadReport(NameSpaceHelper.transform(metadataArtifactDownloadReport.getArtifact(), (NamespaceTransformer)object));
        ((MetadataArtifactDownloadReport)object).setSearched(metadataArtifactDownloadReport.isSearched());
        ((ArtifactDownloadReport)object).setDownloadStatus(metadataArtifactDownloadReport.getDownloadStatus());
        ((ArtifactDownloadReport)object).setDownloadDetails(metadataArtifactDownloadReport.getDownloadDetails());
        ((ArtifactDownloadReport)object).setArtifactOrigin(metadataArtifactDownloadReport.getArtifactOrigin());
        ((ArtifactDownloadReport)object).setDownloadTimeMillis(metadataArtifactDownloadReport.getDownloadTimeMillis());
        ((MetadataArtifactDownloadReport)object).setOriginalLocalFile(metadataArtifactDownloadReport.getOriginalLocalFile());
        ((ArtifactDownloadReport)object).setLocalFile(metadataArtifactDownloadReport.getLocalFile());
        ((ArtifactDownloadReport)object).setSize(metadataArtifactDownloadReport.getSize());
        return object;
    }

    public static ArtifactId transform(ArtifactId artifactId, NamespaceTransformer object) {
        if (object.isIdentity()) {
            return artifactId;
        }
        object = NameSpaceHelper.transform(artifactId.getModuleId(), (NamespaceTransformer)object);
        if (((ModuleId)object).equals(artifactId.getModuleId())) {
            return artifactId;
        }
        return new ArtifactId((ModuleId)object, artifactId.getName(), artifactId.getType(), artifactId.getExt());
    }

    public static ModuleId transform(ModuleId moduleId, NamespaceTransformer namespaceTransformer) {
        if (namespaceTransformer.isIdentity()) {
            return moduleId;
        }
        return namespaceTransformer.transform(new ModuleRevisionId(moduleId, "")).getModuleId();
    }
}

