/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrGraphicsBindingVulkanKHR;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class XrGraphicsBindingVulkan2KHR
extends XrGraphicsBindingVulkanKHR {
    public XrGraphicsBindingVulkan2KHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public XrGraphicsBindingVulkan2KHR type(@NativeType(value="XrStructureType") int value) {
        XrGraphicsBindingVulkan2KHR.ntype(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR type$Default() {
        return this.type(1000025000);
    }

    @Override
    public XrGraphicsBindingVulkan2KHR next(@NativeType(value="void const *") long value) {
        XrGraphicsBindingVulkan2KHR.nnext(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR instance(VkInstance value) {
        XrGraphicsBindingVulkan2KHR.ninstance(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR physicalDevice(VkPhysicalDevice value) {
        XrGraphicsBindingVulkan2KHR.nphysicalDevice(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR device(VkDevice value) {
        XrGraphicsBindingVulkan2KHR.ndevice(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR queueFamilyIndex(@NativeType(value="uint32_t") int value) {
        XrGraphicsBindingVulkan2KHR.nqueueFamilyIndex(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR queueIndex(@NativeType(value="uint32_t") int value) {
        XrGraphicsBindingVulkan2KHR.nqueueIndex(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR set(int type, long next, VkInstance instance, VkPhysicalDevice physicalDevice, VkDevice device, int queueFamilyIndex, int queueIndex) {
        this.type(type);
        this.next(next);
        this.instance(instance);
        this.physicalDevice(physicalDevice);
        this.device(device);
        this.queueFamilyIndex(queueFamilyIndex);
        this.queueIndex(queueIndex);
        return this;
    }

    public XrGraphicsBindingVulkan2KHR set(XrGraphicsBindingVulkan2KHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrGraphicsBindingVulkan2KHR malloc() {
        return (XrGraphicsBindingVulkan2KHR)XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrGraphicsBindingVulkan2KHR calloc() {
        return (XrGraphicsBindingVulkan2KHR)XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrGraphicsBindingVulkan2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrGraphicsBindingVulkan2KHR)XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrGraphicsBindingVulkan2KHR create(long address) {
        return (XrGraphicsBindingVulkan2KHR)XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, (long)address);
    }

    @Nullable
    public static XrGraphicsBindingVulkan2KHR createSafe(long address) {
        return address == 0L ? null : (XrGraphicsBindingVulkan2KHR)XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrGraphicsBindingVulkan2KHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGraphicsBindingVulkan2KHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrGraphicsBindingVulkan2KHR malloc(MemoryStack stack) {
        return (XrGraphicsBindingVulkan2KHR)XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrGraphicsBindingVulkan2KHR calloc(MemoryStack stack) {
        return (XrGraphicsBindingVulkan2KHR)XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends XrGraphicsBindingVulkanKHR.Buffer {
        private static final XrGraphicsBindingVulkan2KHR ELEMENT_FACTORY = XrGraphicsBindingVulkan2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrGraphicsBindingVulkan2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGraphicsBindingVulkan2KHR.ntype(this.address(), value);
            return this;
        }

        @Override
        public Buffer type$Default() {
            return this.type(1000025000);
        }

        @Override
        public Buffer next(@NativeType(value="void const *") long value) {
            XrGraphicsBindingVulkan2KHR.nnext(this.address(), value);
            return this;
        }

        @Override
        public Buffer instance(VkInstance value) {
            XrGraphicsBindingVulkan2KHR.ninstance(this.address(), value);
            return this;
        }

        @Override
        public Buffer physicalDevice(VkPhysicalDevice value) {
            XrGraphicsBindingVulkan2KHR.nphysicalDevice(this.address(), value);
            return this;
        }

        @Override
        public Buffer device(VkDevice value) {
            XrGraphicsBindingVulkan2KHR.ndevice(this.address(), value);
            return this;
        }

        @Override
        public Buffer queueFamilyIndex(@NativeType(value="uint32_t") int value) {
            XrGraphicsBindingVulkan2KHR.nqueueFamilyIndex(this.address(), value);
            return this;
        }

        @Override
        public Buffer queueIndex(@NativeType(value="uint32_t") int value) {
            XrGraphicsBindingVulkan2KHR.nqueueIndex(this.address(), value);
            return this;
        }
    }
}

