/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.gson.internal.bind;

import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.com.google.gson.TypeAdapter;
import org.jetbrains.kotlin.com.google.gson.TypeAdapterFactory;
import org.jetbrains.kotlin.com.google.gson.internal.JavaVersion;
import org.jetbrains.kotlin.com.google.gson.internal.PreJava9DateFormatProvider;
import org.jetbrains.kotlin.com.google.gson.reflect.TypeToken;
import org.jetbrains.kotlin.com.google.gson.stream.JsonWriter;

public final class DateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new DateTypeAdapter() : null;
        }
    };
    private final List<DateFormat> dateFormats = new ArrayList<DateFormat>();

    public DateTypeAdapter() {
        this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2));
        }
        if (JavaVersion.isJava9OrLater()) {
            this.dateFormats.add(PreJava9DateFormatProvider.getUSDateTimeFormat(2, 2));
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Date value2) throws IOException {
        if (value2 == null) {
            out.nullValue();
            return;
        }
        String dateFormatAsString = this.dateFormats.get(0).format(value2);
        out.value(dateFormatAsString);
    }
}

