/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavadocParser {
    private static final TokenSet TAG_VALUES_SET = TokenSet.create(JavaDocTokenType.DOC_TAG_VALUE_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_COMMA, JavaDocTokenType.DOC_TAG_VALUE_DOT, JavaDocTokenType.DOC_TAG_VALUE_LPAREN, JavaDocTokenType.DOC_TAG_VALUE_RPAREN, JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_LT, JavaDocTokenType.DOC_TAG_VALUE_GT);
    private static final TokenSet INLINE_TAG_BORDERS_SET = TokenSet.create(JavaDocTokenType.DOC_INLINE_TAG_START, JavaDocTokenType.DOC_INLINE_TAG_END);
    private static final TokenSet SKIP_TOKENS = TokenSet.create(JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS);
    private static final Set<String> REFERENCE_TAGS = ContainerUtil.set("@throws", "@exception", "@provides", "@uses");
    private static final Key<Integer> BRACE_SCOPE_KEY = Key.create("Javadoc.Parser.Brace.Scope");

    public static void parseJavadocReference(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            JavadocParser.$$$reportNull$$$0(0);
        }
        JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder2, true, true, false, false);
        JavadocParser.swallowTokens(builder2);
    }

    public static void parseJavadocType(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            JavadocParser.$$$reportNull$$$0(1);
        }
        JavaParser.INSTANCE.getReferenceParser().parseType(builder2, 7);
        JavadocParser.swallowTokens(builder2);
    }

    private static void swallowTokens(PsiBuilder builder2) {
        while (!builder2.eof()) {
            builder2.advanceLexer();
        }
    }

    public static void parseDocCommentText(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            JavadocParser.$$$reportNull$$$0(2);
        }
        builder2.enforceCommentTokens(SKIP_TOKENS);
        while (!builder2.eof()) {
            IElementType tokenType = JavadocParser.getTokenType(builder2);
            if (tokenType == JavaDocTokenType.DOC_TAG_NAME) {
                JavadocParser.parseTag(builder2);
                continue;
            }
            JavadocParser.parseDataItem(builder2, null, false);
        }
    }

    private static void parseTag(PsiBuilder builder2) {
        IElementType tokenType;
        String tagName = builder2.getTokenText();
        PsiBuilder.Marker tag = builder2.mark();
        builder2.advanceLexer();
        while ((tokenType = JavadocParser.getTokenType(builder2)) != null && tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_END) {
            JavadocParser.parseDataItem(builder2, tagName, false);
        }
        tag.done(JavaDocElementType.DOC_TAG);
    }

    private static void parseDataItem(PsiBuilder builder2, @Nullable String tagName, boolean isInline) {
        IElementType tokenType = JavadocParser.getTokenType(builder2);
        if (tokenType == JavaDocTokenType.DOC_INLINE_TAG_START) {
            int braceScope = JavadocParser.getBraceScope(builder2);
            if (braceScope > 0) {
                JavadocParser.setBraceScope(builder2, braceScope + 1);
                builder2.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder2.advanceLexer();
                return;
            }
            PsiBuilder.Marker tag = builder2.mark();
            builder2.advanceLexer();
            tokenType = JavadocParser.getTokenType(builder2);
            if (tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                tag.rollbackTo();
                builder2.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder2.advanceLexer();
                return;
            }
            JavadocParser.setBraceScope(builder2, braceScope + 1);
            String inlineTagName = "";
            while (true) {
                if ((tokenType = JavadocParser.getTokenType(builder2)) == JavaDocTokenType.DOC_TAG_NAME) {
                    inlineTagName = builder2.getTokenText();
                } else if (tokenType == null || tokenType == JavaDocTokenType.DOC_COMMENT_END) break;
                JavadocParser.parseDataItem(builder2, inlineTagName, true);
                if (tokenType != JavaDocTokenType.DOC_INLINE_TAG_END) continue;
                braceScope = JavadocParser.getBraceScope(builder2);
                if (braceScope > 0) {
                    JavadocParser.setBraceScope(builder2, --braceScope);
                }
                if (braceScope == 0) break;
            }
            tag.done(JavaDocElementType.DOC_INLINE_TAG);
        } else if (TAG_VALUES_SET.contains(tokenType)) {
            if ("@see".equals(tagName) && !isInline || "@link".equals(tagName) && isInline || JavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_1_4) && "@linkplain".equals(tagName) && isInline) {
                JavadocParser.parseSeeTagValue(builder2, false);
            } else if (!isInline && REFERENCE_TAGS.contains(tagName)) {
                PsiBuilder.Marker tagValue = builder2.mark();
                builder2.remapCurrentToken(JavaDocElementType.DOC_REFERENCE_HOLDER);
                builder2.advanceLexer();
                tagValue.done(JavaDocElementType.DOC_TAG_VALUE_ELEMENT);
            } else if (!isInline && "@param".equals(tagName)) {
                JavadocParser.parseParameterRef(builder2);
            } else if (JavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_1_5) && "@value".equals(tagName) && isInline) {
                JavadocParser.parseSeeTagValue(builder2, true);
            } else {
                JavadocParser.parseSimpleTagValue(builder2);
            }
        } else {
            JavadocParser.remapAndAdvance(builder2);
        }
    }

    private static void parseSeeTagValue(PsiBuilder builder2, boolean allowBareFieldReference) {
        IElementType tokenType = JavadocParser.getTokenType(builder2);
        if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            JavadocParser.parseMethodRef(builder2, builder2.mark());
        } else if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            PsiBuilder.Marker refStart = builder2.mark();
            builder2.remapCurrentToken(JavaDocElementType.DOC_REFERENCE_HOLDER);
            builder2.advanceLexer();
            if (JavadocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
                JavadocParser.parseMethodRef(builder2, refStart);
            } else if (allowBareFieldReference) {
                refStart.rollbackTo();
                builder2.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
                JavadocParser.parseMethodRef(builder2, builder2.mark());
            } else {
                refStart.drop();
            }
        } else {
            PsiBuilder.Marker tagValue = builder2.mark();
            builder2.advanceLexer();
            tagValue.done(JavaDocElementType.DOC_TAG_VALUE_ELEMENT);
        }
    }

    private static void parseMethodRef(PsiBuilder builder2, PsiBuilder.Marker refStart) {
        if (JavadocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            builder2.advanceLexer();
        }
        if (JavadocParser.getTokenType(builder2) != JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            refStart.done(JavaDocElementType.DOC_METHOD_OR_FIELD_REF);
            return;
        }
        builder2.advanceLexer();
        if (JavadocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_LPAREN) {
            IElementType tokenType;
            builder2.advanceLexer();
            PsiBuilder.Marker subValue = builder2.mark();
            while (TAG_VALUES_SET.contains(tokenType = JavadocParser.getTokenType(builder2))) {
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                    builder2.remapCurrentToken(JavaDocElementType.DOC_TYPE_HOLDER);
                    builder2.advanceLexer();
                    while (TAG_VALUES_SET.contains(tokenType = JavadocParser.getTokenType(builder2)) && tokenType != JavaDocTokenType.DOC_TAG_VALUE_COMMA && tokenType != JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                        builder2.advanceLexer();
                    }
                    continue;
                }
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                    subValue.done(JavaDocElementType.DOC_TAG_VALUE_ELEMENT);
                    builder2.advanceLexer();
                    refStart.done(JavaDocElementType.DOC_METHOD_OR_FIELD_REF);
                    return;
                }
                builder2.advanceLexer();
            }
            subValue.done(JavaDocElementType.DOC_TAG_VALUE_ELEMENT);
        }
        refStart.done(JavaDocElementType.DOC_METHOD_OR_FIELD_REF);
    }

    private static void parseParameterRef(PsiBuilder builder2) {
        PsiBuilder.Marker tagValue = builder2.mark();
        while (TAG_VALUES_SET.contains(JavadocParser.getTokenType(builder2))) {
            builder2.advanceLexer();
        }
        tagValue.done(JavaDocElementType.DOC_PARAMETER_REF);
    }

    private static void parseSimpleTagValue(PsiBuilder builder2) {
        PsiBuilder.Marker tagData = builder2.mark();
        while (true) {
            IElementType tokenType;
            if ((tokenType = JavadocParser.getTokenType(builder2)) == JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                builder2.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
            } else if (!TAG_VALUES_SET.contains(tokenType)) break;
            builder2.advanceLexer();
        }
        tagData.done(JavaDocElementType.DOC_TAG_VALUE_ELEMENT);
    }

    @Nullable
    private static IElementType getTokenType(PsiBuilder builder2) {
        IElementType tokenType;
        while ((tokenType = builder2.getTokenType()) == JavaDocTokenType.DOC_SPACE) {
            builder2.remapCurrentToken(TokenType.WHITE_SPACE);
            builder2.advanceLexer();
        }
        return tokenType;
    }

    private static int getBraceScope(PsiBuilder builder2) {
        Integer braceScope = builder2.getUserData(BRACE_SCOPE_KEY);
        return braceScope != null ? braceScope : 0;
    }

    private static void setBraceScope(PsiBuilder builder2, int braceScope) {
        builder2.putUserData(BRACE_SCOPE_KEY, braceScope);
    }

    private static void remapAndAdvance(PsiBuilder builder2) {
        if (INLINE_TAG_BORDERS_SET.contains(builder2.getTokenType()) && JavadocParser.getBraceScope(builder2) != 1) {
            builder2.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
        }
        builder2.advanceLexer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "builder";
        objectArray2[1] = "com/intellij/lang/java/parser/JavadocParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJavadocReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJavadocType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDocCommentText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

