/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.codehaus.mojo.versions.api.ArtifactAssociation;

final class DefaultArtifactAssociation
implements ArtifactAssociation {
    private final Artifact artifact;
    private final boolean usePluginRepositories;

    DefaultArtifactAssociation(Artifact artifact, boolean usePluginRepositories) {
        Objects.requireNonNull(artifact);
        this.artifact = artifact;
        this.usePluginRepositories = usePluginRepositories;
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    @Override
    public boolean isUsePluginRepositories() {
        return this.usePluginRepositories;
    }

    @Override
    public int compareTo(ArtifactAssociation o) {
        if (this == o) {
            return 0;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return 1;
        }
        DefaultArtifactAssociation that = (DefaultArtifactAssociation)o;
        int rv = this.getArtifact().getGroupId().compareTo(that.getArtifact().getGroupId());
        if (rv != 0) {
            return rv;
        }
        rv = this.getArtifact().getArtifactId().compareTo(that.getArtifact().getArtifactId());
        if (rv != 0) {
            return rv;
        }
        if (this.usePluginRepositories != that.usePluginRepositories) {
            return this.usePluginRepositories ? 1 : -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultArtifactAssociation that = (DefaultArtifactAssociation)o;
        if (this.usePluginRepositories != that.usePluginRepositories) {
            return false;
        }
        if (!this.getArtifact().getArtifactId().equals(that.getArtifact().getArtifactId())) {
            return false;
        }
        return this.getArtifact().getGroupId().equals(that.getArtifact().getGroupId());
    }

    public int hashCode() {
        int result = this.getArtifact().getGroupId().hashCode();
        result = 31 * result + this.getArtifact().getArtifactId().hashCode();
        result = 31 * result + (this.usePluginRepositories ? 1 : 0);
        return result;
    }

    public String toString() {
        return (this.usePluginRepositories ? "plugin:" : "artifact:") + ArtifactUtils.versionlessKey((Artifact)this.artifact);
    }
}

