/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.client.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.staging.api.dto.StagingActionDTO;
import com.sonatype.nexus.staging.api.dto.StagingActionRequestDTO;
import com.sonatype.nexus.staging.api.dto.StagingProfileDTO;
import com.sonatype.nexus.staging.api.dto.StagingProfileListResponseDTO;
import com.sonatype.nexus.staging.api.dto.StagingProfileRepositoriesListResponseDTO;
import com.sonatype.nexus.staging.api.dto.StagingProfileRepositoryDTO;
import com.sonatype.nexus.staging.api.dto.StagingProfileResponseDTO;
import com.sonatype.nexus.staging.api.dto.StagingPromoteDTO;
import com.sonatype.nexus.staging.api.dto.StagingPromoteRequestDTO;
import com.sonatype.nexus.staging.api.dto.StagingPromoteResponseDTO;
import com.sonatype.nexus.staging.api.dto.StagingXStreamConfigurator;
import com.sonatype.nexus.staging.client.Profile;
import com.sonatype.nexus.staging.client.ProfileMatchingParameters;
import com.sonatype.nexus.staging.client.StagingRepository;
import com.sonatype.nexus.staging.client.StagingWorkflowV2Service;
import com.sonatype.nexus.staging.client.internal.ExceptionConverter;
import com.sonatype.nexus.staging.client.internal.JerseyStagingProfile;
import com.sonatype.nexus.staging.client.internal.TransitioningListener;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.client.core.NexusClient;
import org.sonatype.nexus.client.core.spi.SubsystemSupport;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;

public class StagingWorkflowV2ServiceImpl
extends SubsystemSupport<JerseyNexusClient>
implements StagingWorkflowV2Service {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public StagingWorkflowV2ServiceImpl(JerseyNexusClient nexusClient) {
        super((NexusClient)nexusClient);
        StagingXStreamConfigurator.configureXStream(nexusClient.getXStream());
    }

    @Override
    public List<Profile> listProfiles() {
        StagingProfileListResponseDTO clientResponse = (StagingProfileListResponseDTO)new ExceptionConverter<StagingProfileListResponseDTO>(this){

            @Override
            public StagingProfileListResponseDTO perform() {
                return (StagingProfileListResponseDTO)((JerseyNexusClient)StagingWorkflowV2ServiceImpl.this.getNexusClient()).serviceResource("staging/profiles").get(StagingProfileListResponseDTO.class);
            }
        }.runAndReturn();
        return this.transformProfiles(clientResponse.getData());
    }

    @Override
    public List<StagingRepository> listStagingRepositories() {
        StagingProfileRepositoriesListResponseDTO clientResponse = (StagingProfileRepositoriesListResponseDTO)new ExceptionConverter<StagingProfileRepositoriesListResponseDTO>(this){

            @Override
            public StagingProfileRepositoriesListResponseDTO perform() {
                return (StagingProfileRepositoriesListResponseDTO)((JerseyNexusClient)StagingWorkflowV2ServiceImpl.this.getNexusClient()).serviceResource("staging/profile_repositories").get(StagingProfileRepositoriesListResponseDTO.class);
            }
        }.runAndReturn();
        return this.transformRepositories(clientResponse.getData());
    }

    @Override
    public List<StagingRepository> listStagingRepositories(final String profileId) {
        StagingProfileRepositoriesListResponseDTO clientResponse = (StagingProfileRepositoriesListResponseDTO)new ExceptionConverter<StagingProfileRepositoriesListResponseDTO>(this){

            @Override
            public StagingProfileRepositoriesListResponseDTO perform() {
                return (StagingProfileRepositoriesListResponseDTO)((JerseyNexusClient)StagingWorkflowV2ServiceImpl.this.getNexusClient()).serviceResource("staging/profile_repositories/" + profileId).get(StagingProfileRepositoriesListResponseDTO.class);
            }
        }.runAndReturn();
        return this.transformRepositories(clientResponse.getData());
    }

    @Override
    public Profile matchProfile(ProfileMatchingParameters params) {
        StagingProfileListResponseDTO clientResponse;
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"t", (Object)params.getContentClass());
        queryParams.add((Object)"g", (Object)params.getGroupId());
        queryParams.add((Object)"a", (Object)params.getArtifactId());
        if (params.getVersion() != null) {
            queryParams.add((Object)"v", (Object)params.getVersion());
        }
        if ((clientResponse = (StagingProfileListResponseDTO)new ExceptionConverter<StagingProfileListResponseDTO>(this, (MultivaluedMap)queryParams){
            final /* synthetic */ MultivaluedMap val$queryParams;
            {
                this.val$queryParams = multivaluedMap;
                super(x0);
            }

            @Override
            public StagingProfileListResponseDTO perform() {
                return (StagingProfileListResponseDTO)((JerseyNexusClient)StagingWorkflowV2ServiceImpl.this.getNexusClient()).serviceResource("staging/profile_evaluate", this.val$queryParams).get(StagingProfileListResponseDTO.class);
            }
        }.runAndReturn()).getData().isEmpty()) {
            return null;
        }
        StagingProfileDTO firstMatched = clientResponse.getData().get(0);
        JerseyStagingProfile result = new JerseyStagingProfile((JerseyNexusClient)this.getNexusClient(), firstMatched);
        return result;
    }

    @Override
    public Profile selectProfile(final String profileId) {
        StagingProfileResponseDTO clientResponse = (StagingProfileResponseDTO)new ExceptionConverter<StagingProfileResponseDTO>(this){

            @Override
            public StagingProfileResponseDTO perform() {
                return (StagingProfileResponseDTO)((JerseyNexusClient)StagingWorkflowV2ServiceImpl.this.getNexusClient()).serviceResource("staging/profiles/" + profileId).get(StagingProfileResponseDTO.class);
            }
        }.runAndReturn();
        StagingProfileDTO firstMatched = clientResponse.getData();
        JerseyStagingProfile result = new JerseyStagingProfile((JerseyNexusClient)this.getNexusClient(), firstMatched);
        return result;
    }

    @Override
    public String startStaging(final Profile profile, String message, Map<String, String> tags) {
        StagingPromoteRequestDTO requestDto = new StagingPromoteRequestDTO();
        requestDto.setData(new StagingPromoteDTO());
        requestDto.getData().setDescription(message);
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        if (tags != null) {
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                String value = entry.getValue();
                if (!StringUtils.isBlank((String)value)) {
                    queryParams.add((Object)("tag_" + entry.getKey()), (Object)value);
                    continue;
                }
                this.log.warn("Omitting tag which has blank value: {}", (Object)entry.getKey());
            }
        }
        StagingPromoteResponseDTO clientResponse = (StagingPromoteResponseDTO)new ExceptionConverter<StagingPromoteResponseDTO>(this, (MultivaluedMap)queryParams, requestDto){
            final /* synthetic */ MultivaluedMap val$queryParams;
            final /* synthetic */ StagingPromoteRequestDTO val$requestDto;
            {
                this.val$queryParams = multivaluedMap;
                this.val$requestDto = stagingPromoteRequestDTO;
                super(x0);
            }

            @Override
            public StagingPromoteResponseDTO perform() {
                return (StagingPromoteResponseDTO)((JerseyNexusClient)StagingWorkflowV2ServiceImpl.this.getNexusClient()).serviceResource("staging/profiles/" + profile.id() + "/start", this.val$queryParams).post(StagingPromoteResponseDTO.class, (Object)this.val$requestDto);
            }
        }.runAndReturn();
        return clientResponse.getData().getStagedRepositoryId();
    }

    @Override
    public String startedRepositoryBaseUrl(Profile profile, String repositoryId) {
        return ((JerseyNexusClient)this.getNexusClient()).resolveServicePath("staging/deployByRepositoryId/" + repositoryId);
    }

    @Override
    public void finishStaging(final Profile profile, final String repositoryId, String message) {
        final StagingPromoteRequestDTO requestDto = new StagingPromoteRequestDTO();
        requestDto.setData(new StagingPromoteDTO());
        requestDto.getData().setDescription(message);
        requestDto.getData().setStagedRepositoryId(repositoryId);
        new ExceptionConverter<StagingProfileListResponseDTO>(this){

            @Override
            public StagingProfileListResponseDTO perform() {
                ((JerseyNexusClient)StagingWorkflowV2ServiceImpl.this.getNexusClient()).serviceResource("staging/profiles/" + profile.id() + "/finish").post((Object)requestDto);
                StagingWorkflowV2ServiceImpl.this.monitorRepositoryTransition(null, repositoryId);
                return null;
            }
        }.runAndReturn();
    }

    @Override
    public void finishStagingRepositories(String message, final String ... stagingRepositoryIds) {
        StagingActionDTO action = new StagingActionDTO();
        action.setDescription(message);
        action.getStagedRepositoryIds().addAll(Arrays.asList(stagingRepositoryIds));
        final StagingActionRequestDTO request = new StagingActionRequestDTO();
        request.setData(action);
        new ExceptionConverter<StagingPromoteResponseDTO>(this){

            @Override
            public StagingPromoteResponseDTO perform() {
                ((JerseyNexusClient)StagingWorkflowV2ServiceImpl.this.getNexusClient()).serviceResource("staging/bulk/close").post((Object)request);
                StagingWorkflowV2ServiceImpl.this.monitorRepositoryTransition(null, stagingRepositoryIds);
                return null;
            }
        }.runAndReturn();
    }

    @Override
    public void dropStagingRepositories(String message, final String ... stagingRepositoryIds) {
        StagingActionDTO action = new StagingActionDTO();
        action.setDescription(message);
        action.getStagedRepositoryIds().addAll(Arrays.asList(stagingRepositoryIds));
        final StagingActionRequestDTO request = new StagingActionRequestDTO();
        request.setData(action);
        new ExceptionConverter<StagingPromoteResponseDTO>(this){

            @Override
            public StagingPromoteResponseDTO perform() {
                ((JerseyNexusClient)StagingWorkflowV2ServiceImpl.this.getNexusClient()).serviceResource("staging/bulk/drop").post((Object)request);
                StagingWorkflowV2ServiceImpl.this.monitorRepositoryTransition(null, stagingRepositoryIds);
                return null;
            }
        }.runAndReturn();
    }

    @Override
    public void releaseStagingRepositories(String message, String ... stagingRepositoryIds) {
        StagingActionDTO action = new StagingActionDTO();
        action.setDescription(message);
        action.getStagedRepositoryIds().addAll(Arrays.asList(stagingRepositoryIds));
        this.releaseStagingRepositories(action);
    }

    protected void releaseStagingRepositories(final StagingActionDTO action) {
        Preconditions.checkNotNull((Object)action, (Object)"Release action configuration required");
        Preconditions.checkArgument((action.getStagingProfileGroup() == null ? 1 : 0) != 0, (Object)"Invalid action configuration for release; stagingProfileGroup is not allowed");
        final StagingActionRequestDTO request = new StagingActionRequestDTO();
        request.setData(action);
        new ExceptionConverter<StagingPromoteResponseDTO>(this){

            @Override
            public StagingPromoteResponseDTO perform() {
                ((JerseyNexusClient)StagingWorkflowV2ServiceImpl.this.getNexusClient()).serviceResource("staging/bulk/promote").post((Object)request);
                StagingWorkflowV2ServiceImpl.this.monitorRepositoryTransition(null, action.getStagedRepositoryIds());
                return null;
            }
        }.runAndReturn();
    }

    @Override
    public String promoteStagingRepositories(String message, String buildPromotionProfileId, final String ... stagingRepositoryIds) {
        StagingActionDTO action = new StagingActionDTO();
        action.setDescription(message);
        action.setStagingProfileGroup(buildPromotionProfileId);
        action.getStagedRepositoryIds().addAll(Arrays.asList(stagingRepositoryIds));
        final StagingActionRequestDTO request = new StagingActionRequestDTO();
        request.setData(action);
        final PromotionGroupIdCollector collector = new PromotionGroupIdCollector();
        new ExceptionConverter<StagingPromoteResponseDTO>(this){

            @Override
            public StagingPromoteResponseDTO perform() {
                ((JerseyNexusClient)StagingWorkflowV2ServiceImpl.this.getNexusClient()).serviceResource("staging/bulk/promote").post((Object)request);
                StagingWorkflowV2ServiceImpl.this.monitorRepositoryTransition((TransitioningListener)collector, stagingRepositoryIds);
                return null;
            }
        }.runAndReturn();
        return collector.getPromotionGroupId();
    }

    @Override
    public StagingWorkflowV2ServiceImpl deployByRepository(String stagingRepositoryId, String path, File target) throws IOException {
        try {
            ((WebResource.Builder)((JerseyNexusClient)this.getNexusClient()).serviceResource(String.format("staging/deployByRepositoryId/%s/%s", Preconditions.checkNotNull((Object)stagingRepositoryId), Preconditions.checkNotNull((Object)path))).type(MediaType.APPLICATION_OCTET_STREAM_TYPE)).put((Object)target);
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        return this;
    }

    protected List<Profile> transformProfiles(List<StagingProfileDTO> response) {
        if (response == null || response.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Profile> result = new ArrayList<Profile>(response.size());
        for (StagingProfileDTO profile : response) {
            result.add(new JerseyStagingProfile((JerseyNexusClient)this.getNexusClient(), profile));
        }
        return result;
    }

    protected List<StagingRepository> transformRepositories(List<StagingProfileRepositoryDTO> response) {
        if (response == null || response.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StagingRepository> result = new ArrayList<StagingRepository>(response.size());
        for (StagingProfileRepositoryDTO profileRepository : response) {
            result.add(this.transformRepository(profileRepository));
        }
        return result;
    }

    protected StagingRepository transformRepository(StagingProfileRepositoryDTO response) {
        if (response == null) {
            return null;
        }
        return new StagingRepository(response.getRepositoryId(), this.stateOf(response), response.getCreated(), response.getUpdated(), response.getDescription(), response.getParentGroupId(), response.getUserId(), response.getUserAgent(), response.getIpAddress());
    }

    protected StagingRepository.State stateOf(StagingProfileRepositoryDTO repository) {
        String type = repository.getType();
        if ("open".equals(type)) {
            return StagingRepository.State.OPEN;
        }
        if ("closed".equals(type)) {
            return StagingRepository.State.CLOSED;
        }
        if ("promoted".equals(type)) {
            return StagingRepository.State.GROUPED;
        }
        return StagingRepository.State.UNKNOWN;
    }

    protected void monitorRepositoryTransition(TransitioningListener collector, String ... repositoryIds) {
    }

    protected void monitorRepositoryTransition(TransitioningListener collector, List<String> repositoryIds) {
        this.monitorRepositoryTransition(collector, repositoryIds.toArray(new String[repositoryIds.size()]));
    }

    private static class PromotionGroupIdCollector
    extends TransitioningListener {
        private String groupId;

        private PromotionGroupIdCollector() {
        }

        @Override
        public void onTransitionedSuccessfully(String repositoryId, StagingProfileRepositoryDTO repository) {
            this.groupId = repository.getParentGroupId();
        }

        public String getPromotionGroupId() {
            return this.groupId;
        }
    }
}

