/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.obrplugin.Config;
import org.apache.felix.obrplugin.ObrUpdate;
import org.apache.felix.obrplugin.ObrUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public final class ObrInstall
extends AbstractMojo {
    private String obrRepository;
    private List supportedProjectTypes = Arrays.asList("jar", "bundle");
    private ArtifactRepository localRepository;
    private MavenProject project;
    private List attachedArtifacts;
    private Artifact m_sourceArtifact;
    private Artifact m_docArtifact;

    public void execute() {
        String projectType = this.project.getPackaging();
        if (!this.supportedProjectTypes.contains(projectType)) {
            this.getLog().warn((CharSequence)("Ignoring project type " + projectType + " - supportedProjectTypes = " + this.supportedProjectTypes));
            return;
        }
        if ("NONE".equalsIgnoreCase(this.obrRepository) || "false".equalsIgnoreCase(this.obrRepository)) {
            this.getLog().info((CharSequence)"Local OBR update disabled (enable with -DobrRepository)");
            return;
        }
        for (Artifact artifact : this.attachedArtifacts) {
            if ("sources".equals(artifact.getClassifier())) {
                this.m_sourceArtifact = artifact;
                continue;
            }
            if (!"javadoc".equals(artifact.getClassifier())) continue;
            this.m_docArtifact = artifact;
        }
        Log log = this.getLog();
        try {
            String mavenRepository = this.localRepository.getBasedir();
            URI repositoryXml = ObrUtils.findRepositoryXml(mavenRepository, this.obrRepository);
            URI obrXmlFile = ObrUtils.findObrXml(this.project.getResources());
            Config userConfig = new Config();
            ObrUpdate update = new ObrUpdate(repositoryXml, obrXmlFile, this.project, mavenRepository, userConfig, log);
            update.parseRepositoryXml();
            this.updateLocalBundleMetadata(this.project.getArtifact(), update);
            Iterator i = this.attachedArtifacts.iterator();
            while (i.hasNext()) {
                this.updateLocalBundleMetadata((Artifact)i.next(), update);
            }
            update.writeRepositoryXml();
        }
        catch (Exception e) {
            log.warn((CharSequence)("Exception while updating local OBR: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private void updateLocalBundleMetadata(Artifact artifact, ObrUpdate update) throws MojoExecutionException {
        if (!this.supportedProjectTypes.contains(artifact.getType())) {
            return;
        }
        if (null == artifact.getFile() || artifact.getFile().isDirectory()) {
            this.getLog().error((CharSequence)"No artifact found, try \"mvn install bundle:install\"");
            return;
        }
        URI bundleJar = ObrUtils.getArtifactURI(this.localRepository, artifact);
        URI sourceJar = null;
        if (null != this.m_sourceArtifact) {
            sourceJar = ObrUtils.getArtifactURI(this.localRepository, this.m_sourceArtifact);
        }
        URI docJar = null;
        if (null != this.m_docArtifact) {
            docJar = ObrUtils.getArtifactURI(this.localRepository, this.m_docArtifact);
        }
        update.updateRepository(bundleJar, sourceJar, docJar);
    }
}

