/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Arrays;
import java.util.LongSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSpliterators;
import java.util.stream.StreamSupport;
import java.util.stream.Streams;

public interface LongStream
extends BaseStream<Long, LongStream> {
    public LongStream filter(LongPredicate var1);

    public LongStream map(LongUnaryOperator var1);

    public <U> Stream<U> mapToObj(LongFunction<? extends U> var1);

    public IntStream mapToInt(LongToIntFunction var1);

    public DoubleStream mapToDouble(LongToDoubleFunction var1);

    public LongStream flatMap(LongFunction<? extends LongStream> var1);

    public LongStream distinct();

    public LongStream sorted();

    public LongStream peek(LongConsumer var1);

    public LongStream limit(long var1);

    public LongStream skip(long var1);

    public void forEach(LongConsumer var1);

    public void forEachOrdered(LongConsumer var1);

    public long[] toArray();

    public long reduce(long var1, LongBinaryOperator var3);

    public OptionalLong reduce(LongBinaryOperator var1);

    public <R> R collect(Supplier<R> var1, ObjLongConsumer<R> var2, BiConsumer<R, R> var3);

    public long sum();

    public OptionalLong min();

    public OptionalLong max();

    public long count();

    public OptionalDouble average();

    public LongSummaryStatistics summaryStatistics();

    public boolean anyMatch(LongPredicate var1);

    public boolean allMatch(LongPredicate var1);

    public boolean noneMatch(LongPredicate var1);

    public OptionalLong findFirst();

    public OptionalLong findAny();

    public DoubleStream asDoubleStream();

    public Stream<Long> boxed();

    @Override
    public LongStream sequential();

    @Override
    public LongStream parallel();

    public PrimitiveIterator.OfLong iterator();

    public Spliterator.OfLong spliterator();

    public static Builder builder() {
        return new Streams.LongStreamBuilderImpl();
    }

    public static LongStream empty() {
        return StreamSupport.longStream(Spliterators.emptyLongSpliterator(), false);
    }

    public static LongStream of(long l) {
        return StreamSupport.longStream(new Streams.LongStreamBuilderImpl(l), false);
    }

    public static LongStream of(long ... lArray) {
        return Arrays.stream(lArray);
    }

    public static LongStream iterate(final long l, final LongUnaryOperator longUnaryOperator) {
        Objects.requireNonNull(longUnaryOperator);
        PrimitiveIterator.OfLong ofLong = new PrimitiveIterator.OfLong(){
            long t;
            {
                this.t = l;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public long nextLong() {
                long l2 = this.t;
                this.t = longUnaryOperator.applyAsLong(this.t);
                return l2;
            }
        };
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize(ofLong, 1296), false);
    }

    public static LongStream generate(LongSupplier longSupplier) {
        Objects.requireNonNull(longSupplier);
        return StreamSupport.longStream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfLong(Long.MAX_VALUE, longSupplier), false);
    }

    public static LongStream range(long l, long l2) {
        if (l >= l2) {
            return LongStream.empty();
        }
        if (l2 - l < 0L) {
            long l3 = l + Long.divideUnsigned(l2 - l, 2L) + 1L;
            return LongStream.concat(LongStream.range(l, l3), LongStream.range(l3, l2));
        }
        return StreamSupport.longStream(new Streams.RangeLongSpliterator(l, l2, false), false);
    }

    public static LongStream rangeClosed(long l, long l2) {
        if (l > l2) {
            return LongStream.empty();
        }
        if (l2 - l + 1L <= 0L) {
            long l3 = l + Long.divideUnsigned(l2 - l, 2L) + 1L;
            return LongStream.concat(LongStream.range(l, l3), LongStream.rangeClosed(l3, l2));
        }
        return StreamSupport.longStream(new Streams.RangeLongSpliterator(l, l2, true), false);
    }

    public static LongStream concat(LongStream longStream, LongStream longStream2) {
        Objects.requireNonNull(longStream);
        Objects.requireNonNull(longStream2);
        Streams.ConcatSpliterator.OfLong ofLong = new Streams.ConcatSpliterator.OfLong(longStream.spliterator(), longStream2.spliterator());
        LongStream longStream3 = StreamSupport.longStream(ofLong, longStream.isParallel() || longStream2.isParallel());
        return (LongStream)longStream3.onClose(Streams.composedClose(longStream, longStream2));
    }

    public static interface Builder
    extends LongConsumer {
        @Override
        public void accept(long var1);

        default public Builder add(long l) {
            this.accept(l);
            return this;
        }

        public LongStream build();
    }
}

