/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  gengetopt -i /home/runner/work/yubihsm-shell/yubihsm-shell/yubihsm-auth/cmdline.ggo --output-dir /home/runner/work/yubihsm-shell/yubihsm-shell/yubihsm-auth cmdline 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: " CMDLINE_PARSER_PACKAGE " [OPTION]...";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "  -a, --action=ENUM             Action to perform  (possible\n                                  values=\"calculate\", \"change-mgmkey\",\n                                  \"delete\", \"list\", \"put\", \"reset\",\n                                  \"retries\", \"version\", \"get-challenge\",\n                                  \"get-pubkey\")",
  "  -k, --mgmkey=STRING           Management key is required to put and delete\n                                  credentials. Sometimes, this key is also\n                                  referenced as 'Admin Access Code'\n                                  (default=`00000000000000000000000000000000')",
  "  -K, --new-mgmkey=STRING       New management key  (default=`')",
  "  -p, --credpwd=STRING          Credential password is used to access the\n                                  credential when logging into the YubiHSM2.\n                                  Sometimes, this password is also referenced\n                                  as 'User Access Code'  (default=`')",
  "  -l, --label=STRING            Credential label  (default=`')",
  "  -r, --reader=STRING           Only use a matching reader  (default=`')",
  "  -t, --touch=ENUM              Touch required  (possible values=\"off\",\n                                  \"on\" default=`off')",
  "  -c, --context=STRING          Session keys calculation context  (default=`')",
  "  -v, --verbose[=INT]           Print more information  (default=`0')",
  "\n Mode: derivation\n  Derive keys from a password using PBKDF2",
  "  -d, --derivation-password=STRING\n                                Derivation password for encryption and MAC keys\n                                  (default=`')",
  "\n Mode: explicit\n  Explicit encryption and MAC keys",
  "  -e, --enckey=STRING           Encryption key  (default=`')",
  "  -m, --mackey=STRING           MAC key  (default=`')",
  "\n Mode: asymmetric\n  Explicit ec-p256 private key",
  "  -s, --privkey=STRING          Private key  (default=`')",
    0
};

typedef enum {ARG_NO
  , ARG_STRING
  , ARG_INT
  , ARG_ENUM
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);


const char *cmdline_parser_action_values[] = {"calculate", "change-mgmkey", "delete", "list", "put", "reset", "retries", "version", "get-challenge", "get-pubkey", 0}; /*< Possible values for action. */
const char *cmdline_parser_touch_values[] = {"off", "on", 0}; /*< Possible values for touch. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->action_given = 0 ;
  args_info->mgmkey_given = 0 ;
  args_info->new_mgmkey_given = 0 ;
  args_info->credpwd_given = 0 ;
  args_info->label_given = 0 ;
  args_info->reader_given = 0 ;
  args_info->touch_given = 0 ;
  args_info->context_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->derivation_password_given = 0 ;
  args_info->enckey_given = 0 ;
  args_info->mackey_given = 0 ;
  args_info->privkey_given = 0 ;
  args_info->asymmetric_mode_counter = 0 ;
  args_info->derivation_mode_counter = 0 ;
  args_info->explicit_mode_counter = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->action_arg = action__NULL;
  args_info->action_orig = NULL;
  args_info->mgmkey_arg = gengetopt_strdup ("00000000000000000000000000000000");
  args_info->mgmkey_orig = NULL;
  args_info->new_mgmkey_arg = gengetopt_strdup ("");
  args_info->new_mgmkey_orig = NULL;
  args_info->credpwd_arg = gengetopt_strdup ("");
  args_info->credpwd_orig = NULL;
  args_info->label_arg = gengetopt_strdup ("");
  args_info->label_orig = NULL;
  args_info->reader_arg = gengetopt_strdup ("");
  args_info->reader_orig = NULL;
  args_info->touch_arg = touch_arg_off;
  args_info->touch_orig = NULL;
  args_info->context_arg = gengetopt_strdup ("");
  args_info->context_orig = NULL;
  args_info->verbose_arg = 0;
  args_info->verbose_orig = NULL;
  args_info->derivation_password_arg = gengetopt_strdup ("");
  args_info->derivation_password_orig = NULL;
  args_info->enckey_arg = gengetopt_strdup ("");
  args_info->enckey_orig = NULL;
  args_info->mackey_arg = gengetopt_strdup ("");
  args_info->mackey_orig = NULL;
  args_info->privkey_arg = gengetopt_strdup ("");
  args_info->privkey_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->action_help = gengetopt_args_info_help[2] ;
  args_info->mgmkey_help = gengetopt_args_info_help[3] ;
  args_info->new_mgmkey_help = gengetopt_args_info_help[4] ;
  args_info->credpwd_help = gengetopt_args_info_help[5] ;
  args_info->label_help = gengetopt_args_info_help[6] ;
  args_info->reader_help = gengetopt_args_info_help[7] ;
  args_info->touch_help = gengetopt_args_info_help[8] ;
  args_info->context_help = gengetopt_args_info_help[9] ;
  args_info->verbose_help = gengetopt_args_info_help[10] ;
  args_info->derivation_password_help = gengetopt_args_info_help[12] ;
  args_info->enckey_help = gengetopt_args_info_help[14] ;
  args_info->mackey_help = gengetopt_args_info_help[15] ;
  args_info->privkey_help = gengetopt_args_info_help[17] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(gengetopt_args_info_purpose);
	size_t len_usage = strlen(gengetopt_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", gengetopt_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", gengetopt_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(gengetopt_args_info_description) > 0) {
		printf("%s\n\n", gengetopt_args_info_description);
	}
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->action_orig));
  free_string_field (&(args_info->mgmkey_arg));
  free_string_field (&(args_info->mgmkey_orig));
  free_string_field (&(args_info->new_mgmkey_arg));
  free_string_field (&(args_info->new_mgmkey_orig));
  free_string_field (&(args_info->credpwd_arg));
  free_string_field (&(args_info->credpwd_orig));
  free_string_field (&(args_info->label_arg));
  free_string_field (&(args_info->label_orig));
  free_string_field (&(args_info->reader_arg));
  free_string_field (&(args_info->reader_orig));
  free_string_field (&(args_info->touch_orig));
  free_string_field (&(args_info->context_arg));
  free_string_field (&(args_info->context_orig));
  free_string_field (&(args_info->verbose_orig));
  free_string_field (&(args_info->derivation_password_arg));
  free_string_field (&(args_info->derivation_password_orig));
  free_string_field (&(args_info->enckey_arg));
  free_string_field (&(args_info->enckey_orig));
  free_string_field (&(args_info->mackey_arg));
  free_string_field (&(args_info->mackey_orig));
  free_string_field (&(args_info->privkey_arg));
  free_string_field (&(args_info->privkey_orig));
  
  

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->action_given)
    write_into_file(outfile, "action", args_info->action_orig, cmdline_parser_action_values);
  if (args_info->mgmkey_given)
    write_into_file(outfile, "mgmkey", args_info->mgmkey_orig, 0);
  if (args_info->new_mgmkey_given)
    write_into_file(outfile, "new-mgmkey", args_info->new_mgmkey_orig, 0);
  if (args_info->credpwd_given)
    write_into_file(outfile, "credpwd", args_info->credpwd_orig, 0);
  if (args_info->label_given)
    write_into_file(outfile, "label", args_info->label_orig, 0);
  if (args_info->reader_given)
    write_into_file(outfile, "reader", args_info->reader_orig, 0);
  if (args_info->touch_given)
    write_into_file(outfile, "touch", args_info->touch_orig, cmdline_parser_touch_values);
  if (args_info->context_given)
    write_into_file(outfile, "context", args_info->context_orig, 0);
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", args_info->verbose_orig, 0);
  if (args_info->derivation_password_given)
    write_into_file(outfile, "derivation-password", args_info->derivation_password_orig, 0);
  if (args_info->enckey_given)
    write_into_file(outfile, "enckey", args_info->enckey_orig, 0);
  if (args_info->mackey_given)
    write_into_file(outfile, "mackey", args_info->mackey_orig, 0);
  if (args_info->privkey_given)
    write_into_file(outfile, "privkey", args_info->privkey_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_ENUM:
    if (val) *((int *)field) = found;
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


static int check_modes(
  int given1[], const char *options1[],
                       int given2[], const char *options2[])
{
  int i = 0, j = 0, errors = 0;
  
  while (given1[i] >= 0) {
    if (given1[i]) {
      while (given2[j] >= 0) {
        if (given2[j]) {
          ++errors;
          fprintf(stderr, "%s: option %s conflicts with option %s\n",
                  package_name, options1[i], options2[j]);
        }
        ++j;
      }
    }
    ++i;
  }
  
  return errors;
}

int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "action",	1, NULL, 'a' },
        { "mgmkey",	1, NULL, 'k' },
        { "new-mgmkey",	1, NULL, 'K' },
        { "credpwd",	1, NULL, 'p' },
        { "label",	1, NULL, 'l' },
        { "reader",	1, NULL, 'r' },
        { "touch",	1, NULL, 't' },
        { "context",	1, NULL, 'c' },
        { "verbose",	2, NULL, 'v' },
        { "derivation-password",	1, NULL, 'd' },
        { "enckey",	1, NULL, 'e' },
        { "mackey",	1, NULL, 'm' },
        { "privkey",	1, NULL, 's' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVa:k:K:p:l:r:t:c:v::d:e:m:s:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'a':	/* Action to perform.  */
        
        
          if (update_arg( (void *)&(args_info->action_arg), 
               &(args_info->action_orig), &(args_info->action_given),
              &(local_args_info.action_given), optarg, cmdline_parser_action_values, 0, ARG_ENUM,
              check_ambiguity, override, 0, 0,
              "action", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'k':	/* Management key is required to put and delete credentials. Sometimes, this key is also referenced as 'Admin Access Code'.  */
        
        
          if (update_arg( (void *)&(args_info->mgmkey_arg), 
               &(args_info->mgmkey_orig), &(args_info->mgmkey_given),
              &(local_args_info.mgmkey_given), optarg, 0, "00000000000000000000000000000000", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "mgmkey", 'k',
              additional_error))
            goto failure;
        
          break;
        case 'K':	/* New management key.  */
        
        
          if (update_arg( (void *)&(args_info->new_mgmkey_arg), 
               &(args_info->new_mgmkey_orig), &(args_info->new_mgmkey_given),
              &(local_args_info.new_mgmkey_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "new-mgmkey", 'K',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* Credential password is used to access the credential when logging into the YubiHSM2. Sometimes, this password is also referenced as 'User Access Code'.  */
        
        
          if (update_arg( (void *)&(args_info->credpwd_arg), 
               &(args_info->credpwd_orig), &(args_info->credpwd_given),
              &(local_args_info.credpwd_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "credpwd", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* Credential label.  */
        
        
          if (update_arg( (void *)&(args_info->label_arg), 
               &(args_info->label_orig), &(args_info->label_given),
              &(local_args_info.label_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "label", 'l',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* Only use a matching reader.  */
        
        
          if (update_arg( (void *)&(args_info->reader_arg), 
               &(args_info->reader_orig), &(args_info->reader_given),
              &(local_args_info.reader_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "reader", 'r',
              additional_error))
            goto failure;
        
          break;
        case 't':	/* Touch required.  */
        
        
          if (update_arg( (void *)&(args_info->touch_arg), 
               &(args_info->touch_orig), &(args_info->touch_given),
              &(local_args_info.touch_given), optarg, cmdline_parser_touch_values, "off", ARG_ENUM,
              check_ambiguity, override, 0, 0,
              "touch", 't',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Session keys calculation context.  */
        
        
          if (update_arg( (void *)&(args_info->context_arg), 
               &(args_info->context_orig), &(args_info->context_given),
              &(local_args_info.context_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "context", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Print more information.  */
        
        
          if (update_arg( (void *)&(args_info->verbose_arg), 
               &(args_info->verbose_orig), &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "verbose", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* Derivation password for encryption and MAC keys.  */
          args_info->derivation_mode_counter += 1;
        
        
          if (update_arg( (void *)&(args_info->derivation_password_arg), 
               &(args_info->derivation_password_orig), &(args_info->derivation_password_given),
              &(local_args_info.derivation_password_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "derivation-password", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Encryption key.  */
          args_info->explicit_mode_counter += 1;
        
        
          if (update_arg( (void *)&(args_info->enckey_arg), 
               &(args_info->enckey_orig), &(args_info->enckey_given),
              &(local_args_info.enckey_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "enckey", 'e',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* MAC key.  */
          args_info->explicit_mode_counter += 1;
        
        
          if (update_arg( (void *)&(args_info->mackey_arg), 
               &(args_info->mackey_orig), &(args_info->mackey_given),
              &(local_args_info.mackey_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "mackey", 'm',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* Private key.  */
          args_info->asymmetric_mode_counter += 1;
        
        
          if (update_arg( (void *)&(args_info->privkey_arg), 
               &(args_info->privkey_orig), &(args_info->privkey_given),
              &(local_args_info.privkey_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "privkey", 's',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (args_info->asymmetric_mode_counter && args_info->derivation_mode_counter) {
    int asymmetric_given[] = {args_info->privkey_given,  -1};
    const char *asymmetric_desc[] = {"--privkey",  0};
    int derivation_given[] = {args_info->derivation_password_given,  -1};
    const char *derivation_desc[] = {"--derivation-password",  0};
    error_occurred += check_modes(asymmetric_given, asymmetric_desc, derivation_given, derivation_desc);
  }
  if (args_info->asymmetric_mode_counter && args_info->explicit_mode_counter) {
    int asymmetric_given[] = {args_info->privkey_given,  -1};
    const char *asymmetric_desc[] = {"--privkey",  0};
    int explicit_given[] = {args_info->enckey_given, args_info->mackey_given,  -1};
    const char *explicit_desc[] = {"--enckey", "--mackey",  0};
    error_occurred += check_modes(asymmetric_given, asymmetric_desc, explicit_given, explicit_desc);
  }
  if (args_info->derivation_mode_counter && args_info->explicit_mode_counter) {
    int derivation_given[] = {args_info->derivation_password_given,  -1};
    const char *derivation_desc[] = {"--derivation-password",  0};
    int explicit_given[] = {args_info->enckey_given, args_info->mackey_given,  -1};
    const char *explicit_desc[] = {"--enckey", "--mackey",  0};
    error_occurred += check_modes(derivation_given, derivation_desc, explicit_given, explicit_desc);
  }
  
	FIX_UNUSED(check_required);

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
