/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.Cell;
import SharpTools.CellPoint;
import SharpTools.CellRange;
import SharpTools.Debug;
import SharpTools.Formula;
import SharpTools.History;
import SharpTools.MainApplet;
import SharpTools.Node;
import SharpTools.ParserException;
import SharpTools.SharpClipboard;
import SharpTools.SharpTools;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SharpTableModel
extends DefaultTableModel {
    private boolean modified;
    private boolean passwordModified;
    private SharpTools sharp;
    private History history;

    public SharpTableModel(SharpTools sharp) {
        this.modified = false;
        this.sharp = sharp;
    }

    public SharpTableModel(SharpTools sharp, int numRows, int numColumns) {
        super(numRows, numColumns + 1);
        int row;
        for (row = SharpTools.baseRow; row < numRows; ++row) {
            Cell temp = new Cell(new Integer(row + 1));
            super.setValueAt(temp, row, 0);
        }
        for (row = SharpTools.baseRow; row < numRows; ++row) {
            for (int col = SharpTools.baseCol; col < numColumns + 1; ++col) {
                super.setValueAt(new Cell(""), row, col);
            }
        }
        this.modified = false;
        this.sharp = sharp;
    }

    public SharpTableModel(SharpTools sharp, Object[][] data) {
        this(sharp, data.length + SharpTools.baseRow, data[0].length + SharpTools.baseCol);
        for (int i = SharpTools.baseRow; i < data.length; ++i) {
            for (int j = SharpTools.baseCol; j < data[i].length; ++j) {
                this.doSetValueAt(data[i][j], i, j);
            }
        }
        this.modified = false;
        this.sharp = sharp;
    }

    @Override
    public String getColumnName(int col) {
        Debug.println("name of column " + col);
        if (col < SharpTools.baseCol) {
            return "";
        }
        return String.valueOf(Node.translateColumn(col));
    }

    void setHistory(History h) {
        this.history = h;
    }

    public Cell getCellAt(int aRow, int aColumn) {
        if (aRow < 0 || aRow >= this.getRowCount() || aColumn < 0 || aColumn >= this.getColumnCount()) {
            return null;
        }
        Cell temp = (Cell)super.getValueAt(aRow, aColumn);
        return temp;
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        return this.getCellAt(aRow, aColumn);
    }

    public void recalculate(int aRow, int aColumn) {
        if (this.isFormula(aRow, aColumn)) {
            try {
                Debug.println("recalculate");
                Number eVal = Formula.evaluate(this, aRow, aColumn);
                this.getCellAt(aRow, aColumn).setValue(eVal);
            }
            catch (ParserException e) {
                this.getCellAt(aRow, aColumn).setValue(e);
            }
        }
    }

    public void recalculate(CellPoint x) {
        this.recalculate(x.getRow(), x.getCol());
    }

    private static Object fieldParser(String input, CellPoint c) {
        if (input == null) {
            return new String("");
        }
        int row = c.getRow();
        int col = c.getCol();
        if (input.startsWith("=")) {
            Object form = null;
            try {
                return new Formula(input.substring(1), row, col);
            }
            catch (ParserException e) {
                return new Formula(input.substring(1), row, col, e);
            }
        }
        try {
            return new Float(input);
        }
        catch (NumberFormatException e2) {
            return input;
        }
    }

    public static Object fieldParser(String input) {
        if (input == null) {
            return new String("");
        }
        try {
            return new Float(input);
        }
        catch (NumberFormatException e) {
            return input;
        }
    }

    @Override
    public void setValueAt(Object aValue, int aRow, int aColumn) {
        CellPoint point = new CellPoint(aRow, aColumn);
        this.history.add(this, new CellRange(point, point));
        this.doSetValueAt(aValue, aRow, aColumn);
    }

    public void doSetValueAt(Object aValue, int aRow, int aColumn) {
        if (aValue == null) {
            aValue = new String("");
        }
        if (aValue instanceof String) {
            String input = (String)aValue;
            if (input.startsWith("=")) {
                Formula form = null;
                try {
                    form = new Formula(input.substring(1), aRow, aColumn);
                    this.setCellAt(form, aRow, aColumn);
                }
                catch (ParserException e) {
                    form = new Formula(input.substring(1), aRow, aColumn, e);
                    this.setCellAt(form, aRow, aColumn);
                    this.getCellAt(aRow, aColumn).setValue(e);
                }
            } else {
                try {
                    Float data = new Float(input);
                    this.setCellAt(data, aRow, aColumn);
                }
                catch (NumberFormatException e2) {
                    this.setCellAt(aValue, aRow, aColumn);
                }
            }
        } else if (aValue instanceof Formula) {
            try {
                Formula form = (Formula)aValue;
                this.setCellAt(new Formula(form, aRow, aColumn), aRow, aColumn);
            }
            catch (ParserException e) {
                Formula form2 = (Formula)aValue;
                form2 = new Formula(form2.toString(), aRow, aColumn, e);
                this.setCellAt(form2, aRow, aColumn);
                this.getCellAt(aRow, aColumn).setValue(e);
            }
        } else {
            this.setCellAt(aValue, aRow, aColumn);
        }
    }

    public void setCellAt(Object input, int aRow, int aColumn) {
        Cell temp = this.getCellAt(aRow, aColumn);
        if (temp != null) {
            this.removeRefs(aRow, aColumn);
            if (input instanceof Formula) {
                temp.setFormula((Formula)input);
                if (this.isLoop(new CellPoint(aRow, aColumn))) {
                    ParserException loop = new ParserException("#LOOP?");
                    Formula form2 = new Formula(input.toString(), aRow, aColumn, loop);
                    this.setCellAt(form2, aRow, aColumn);
                    this.getCellAt(aRow, aColumn).setValue(loop);
                    this.updateRefs(aRow, aColumn);
                    return;
                }
                this.addRefs(aRow, aColumn);
                this.recalculate(aRow, aColumn);
                this.updateRefs(aRow, aColumn);
            } else {
                temp.setData(input);
                this.updateRefs(aRow, aColumn);
            }
        }
    }

    public void setRange(CellRange range, Object[][] data) {
        for (int i = range.getStartRow(); i <= range.getEndRow(); ++i) {
            for (int j = range.getStartCol(); j <= range.getEndCol(); ++j) {
                int x = i - range.getStartRow();
                int y = j - range.getStartCol();
                this.doSetValueAt(data[x][y], i, j);
            }
        }
    }

    public void setRange(CellRange range, Cell[][] data, boolean byValue) {
        if (byValue) {
            for (int i = range.getStartRow(); i <= range.getEndRow(); ++i) {
                for (int j = range.getStartCol(); j <= range.getEndCol(); ++j) {
                    int x = i - range.getStartRow();
                    int y = j - range.getStartCol();
                    this.doSetValueAt(data[x][y].getValue(), i, j);
                }
            }
        } else {
            for (int i = range.getStartRow(); i <= range.getEndRow(); ++i) {
                for (int j = range.getStartCol(); j <= range.getEndCol(); ++j) {
                    int y;
                    int x = i - range.getStartRow();
                    Cell info = data[x][y = j - range.getStartCol()];
                    if (info.isFormula()) {
                        this.doSetValueAt(info.getFormula(), i, j);
                        continue;
                    }
                    this.doSetValueAt(info.getValue(), i, j);
                }
            }
        }
    }

    public void clearRange(CellRange range) {
        this.fill(range, null);
    }

    protected void fillRange(CellRange range, String s) {
        this.fill(range, SharpTableModel.fieldParser(s, range.getminCorner()));
    }

    protected void fill(CellRange range, Object input) {
        for (int i = range.getStartRow(); i <= range.getEndRow(); ++i) {
            for (int j = range.getStartCol(); j <= range.getEndCol(); ++j) {
                this.doSetValueAt(input, i, j);
            }
        }
    }

    public CellPoint look(CellPoint begin, Object goal, boolean matchCase, boolean matchCell) {
        int i;
        int startRow = begin.getRow();
        int startCol = begin.getCol();
        if (goal instanceof String && !matchCase && matchCell) {
            int i2;
            String objective = (String)goal;
            for (i2 = startCol; i2 < this.getColumnCount(); ++i2) {
                if (!objective.equalsIgnoreCase(this.getCellAt(startRow, i2).getValue().toString())) continue;
                return new CellPoint(startRow, i2);
            }
            for (i2 = startRow + 1; i2 < this.getRowCount(); ++i2) {
                for (int j = 1; j < this.getColumnCount(); ++j) {
                    if (!objective.equalsIgnoreCase(this.getCellAt(i2, j).getValue().toString())) continue;
                    return new CellPoint(i2, j);
                }
            }
            return null;
        }
        if (goal instanceof String && !matchCell) {
            int i3;
            String objective = (String)goal;
            for (i3 = startCol; i3 < this.getColumnCount(); ++i3) {
                String test = this.getCellAt(startRow, i3).getValue().toString();
                if (!matchCase) {
                    objective = objective.toUpperCase();
                    test = test.toUpperCase();
                }
                for (int k = 0; k < test.length(); ++k) {
                    if (!test.startsWith(objective, k)) continue;
                    return new CellPoint(startRow, i3);
                }
            }
            for (i3 = startRow + 1; i3 < this.getRowCount(); ++i3) {
                for (int j = 1; j < this.getColumnCount(); ++j) {
                    String test = this.getCellAt(i3, j).getValue().toString();
                    if (!matchCase) {
                        objective = objective.toUpperCase();
                        test = test.toUpperCase();
                    }
                    for (int k = 0; k < test.length(); ++k) {
                        if (!test.startsWith(objective, k)) continue;
                        return new CellPoint(i3, j);
                    }
                }
            }
            return null;
        }
        for (i = startCol; i < this.getColumnCount(); ++i) {
            if (!goal.equals(this.getCellAt(startRow, i).getValue())) continue;
            return new CellPoint(startRow, i);
        }
        for (i = startRow + 1; i < this.getRowCount(); ++i) {
            for (int j = 1; j < this.getColumnCount(); ++j) {
                if (!goal.equals(this.getCellAt(i, j).getValue())) continue;
                return new CellPoint(i, j);
            }
        }
        return null;
    }

    public Cell[][] getRange(CellRange range) {
        Cell[][] board = new Cell[range.getHeight()][range.getWidth()];
        for (int i = range.getStartRow(); i <= range.getEndRow(); ++i) {
            for (int j = range.getStartCol(); j <= range.getEndCol(); ++j) {
                int x = i - range.getStartRow();
                int y = j - range.getStartCol();
                Cell field = this.getCellAt(i, j);
                if (field.isFormula()) {
                    try {
                        Formula form = new Formula(field.getFormula(), i, j);
                        board[x][y] = new Cell(form, field.getValue(), null);
                    }
                    catch (ParserException e) {
                        board[x][y] = new Cell(field.getFormula().toString());
                    }
                    continue;
                }
                board[x][y] = new Cell(field.getValue());
            }
        }
        return board;
    }

    public void addRefs(int aRow, int aColumn) {
        if (this.isFormula(aRow, aColumn)) {
            Formula temp = this.getCellAt(aRow, aColumn).getFormula();
            TreeSet list = temp.getDependency();
            Iterator it = list.iterator();
            CellPoint thisRef = new CellPoint(aRow, aColumn);
            while (it.hasNext()) {
                CellPoint update = (CellPoint)it.next();
                Cell field = this.getCellAt(update.getRow(), update.getCol());
                if (field == null) continue;
                field.addRef(thisRef);
            }
        }
    }

    public void removeRefs(int aRow, int aColumn) {
        if (this.isFormula(aRow, aColumn)) {
            Formula temp = this.getCellAt(aRow, aColumn).getFormula();
            TreeSet list = temp.getDependency();
            Iterator it = list.iterator();
            CellPoint thisRef = new CellPoint(aRow, aColumn);
            while (it.hasNext()) {
                CellPoint update = (CellPoint)it.next();
                Cell field = this.getCellAt(update.getRow(), update.getCol());
                if (field == null) continue;
                field.removeRef(thisRef);
            }
        }
    }

    public void updateRefs(int aRow, int aColumn) {
        Cell temp = this.getCellAt(aRow, aColumn);
        if (temp == null) {
            return;
        }
        TreeSet set = this.getRefs(aRow, aColumn);
        for (CellPoint point : set) {
            Formula formula = this.getCellAt(point.getRow(), point.getCol()).getFormula();
            formula.setNeedsRecalc(true);
        }
        for (CellPoint point : set) {
            try {
                this.getNumericValueAt(point.getRow(), point.getCol());
            }
            catch (ParserException parserException) {
                // empty catch block
            }
            this.fireTableCellUpdated(point.getRow(), point.getCol());
        }
        this.fireTableCellUpdated(aRow, aColumn);
    }

    private TreeSet getRefs(int row, int col) {
        TreeSet set = new TreeSet();
        this.getRefs(row, col, set);
        return set;
    }

    private void getRefs(int row, int col, TreeSet set) {
        Cell cell = this.getCellAt(row, col);
        if (cell == null || !cell.hasRefs()) {
            return;
        }
        for (CellPoint point : cell.getRefs()) {
            set.add(point);
            this.getRefs(point.getRow(), point.getCol(), set);
        }
    }

    public void recalculateAll() {
        for (int i = 1; i < this.getRowCount(); ++i) {
            for (int j = 1; j < this.getColumnCount(); ++j) {
                this.addRefs(i, j);
                this.recalculate(i, j);
            }
        }
    }

    public void removeColumn(CellRange deletionRange) {
        int col = deletionRange.getStartCol();
        int removeNum = deletionRange.getWidth();
        int lastRow = this.getRowCount() - 1;
        int lastCol = this.getColumnCount() - 1;
        CellRange range = new CellRange(SharpTools.baseRow, lastRow, col + removeNum, lastCol);
        SharpClipboard scrap = new SharpClipboard(this, range, true);
        JTable table = this.sharp.getTable();
        for (int i = 0; i < removeNum; ++i) {
            this.removeColumn();
            TableColumnModel tm = table.getColumnModel();
            tm.removeColumn(tm.getColumn(tm.getColumnCount() - 1));
        }
        scrap.paste(this, new CellPoint(SharpTools.baseRow, col));
        this.recalculateAll();
        if (table.getSelectedColumnCount() == 0) {
            this.setSelection(new CellRange(SharpTools.baseRow, SharpTools.baseRow, col, col));
        }
        this.sharp.setBaseColumnWidth(0);
    }

    private void removeColumn() {
        int lastRow = this.getRowCount() - 1;
        int lastCol = this.getColumnCount() - 1;
        this.clearRange(new CellRange(SharpTools.baseRow, lastRow, lastCol, lastCol));
        for (Vector temp : this.dataVector) {
            temp.removeElementAt(this.getColumnCount() - 1);
        }
        this.columnIdentifiers.removeElementAt(this.columnIdentifiers.size() - 1);
    }

    public void insertColumn(CellRange insertRange) {
        Debug.println("insertRange: " + insertRange);
        int col = insertRange.getStartCol();
        int insertNum = insertRange.getWidth();
        int lastRow = this.getRowCount() - 1;
        int lastCol = this.getColumnCount() - 1;
        CellRange range = new CellRange(SharpTools.baseRow, lastRow, Math.max(col, SharpTools.baseCol), lastCol);
        SharpClipboard scrap = new SharpClipboard(this, range, true);
        JTable table = this.sharp.getTable();
        TableColumnModel tm = table.getColumnModel();
        TableColumn column = tm.getColumn(col);
        for (int i = 0; i < insertNum; ++i) {
            int curCol = lastCol + i + 1;
            this.addColumn();
            TableColumn newcol = new TableColumn(curCol, column.getPreferredWidth());
            newcol.setHeaderValue(Node.translateColumn(curCol));
            tm.addColumn(newcol);
        }
        scrap.paste(this, new CellPoint(SharpTools.baseRow, col + insertNum));
        this.recalculateAll();
        if (table.getSelectedColumnCount() == 0) {
            this.setSelection(new CellRange(SharpTools.baseRow, SharpTools.baseRow, col, col));
        }
        this.sharp.setBaseColumnWidth(0);
    }

    private void addColumn() {
        this.columnIdentifiers.addElement(null);
        Iterator it = this.dataVector.iterator();
        if (it.hasNext()) {
            Cell temp = new Cell(Node.translateColumn(this.getColumnCount() - 1));
            ((Vector)it.next()).addElement(temp);
        }
        while (it.hasNext()) {
            ((Vector)it.next()).addElement(new Cell(""));
        }
    }

    public void removeRow(CellRange deletionRange) {
        this.clearRange(deletionRange);
        int row = deletionRange.getStartRow();
        int removeNum = deletionRange.getHeight();
        int lastRow = this.getRowCount() - 1;
        int lastCol = this.getColumnCount() - 1;
        CellRange range = new CellRange(row + removeNum, lastRow, SharpTools.baseCol, lastCol);
        SharpClipboard scrap = new SharpClipboard(this, range, true);
        for (int i = 0; i < removeNum; ++i) {
            super.removeRow(this.getRowCount() - 1);
        }
        scrap.paste(this, new CellPoint(row, SharpTools.baseCol));
        this.recalculateAll();
        JTable table = this.sharp.getTable();
        if (table.getSelectedColumnCount() == 0) {
            this.setSelection(new CellRange(row, row, SharpTools.baseCol, SharpTools.baseCol));
        }
    }

    public void insertRow(CellRange insertRange) {
        int row = insertRange.getStartRow();
        int insertNum = insertRange.getHeight();
        int lastRow = this.getRowCount() - 1;
        int lastCol = this.getColumnCount() - 1;
        CellRange range = new CellRange(Math.max(row, SharpTools.baseRow), lastRow, SharpTools.baseCol, lastCol);
        SharpClipboard scrap = new SharpClipboard(this, range, true);
        for (int i = 0; i < insertNum; ++i) {
            this.addRow();
        }
        scrap.paste(this, new CellPoint(row + insertNum, SharpTools.baseCol));
        this.recalculateAll();
        JTable table = this.sharp.getTable();
        if (table.getSelectedColumnCount() == 0) {
            this.setSelection(new CellRange(row, row, SharpTools.baseCol, SharpTools.baseCol));
        }
    }

    private void addRow() {
        Vector<Cell> rowData = new Vector<Cell>();
        rowData.add(0, new Cell(new Integer(this.getRowCount() + 1)));
        super.addRow(rowData);
        for (int i = 1; i < this.getColumnCount(); ++i) {
            super.setValueAt(new Cell(""), this.getRowCount() - 1, i);
        }
    }

    public Number getNumericValueAt(int row, int col) throws ParserException {
        Cell cell = this.getCellAt(row, col);
        if (cell != null) {
            int type = cell.getType();
            if (type == 2) {
                Object value = cell.getValue();
                Formula form = cell.getFormula();
                if (form.needsRecalc()) {
                    try {
                        value = Formula.evaluate(this, row, col);
                        cell.setValue(value);
                    }
                    catch (ParserException e) {
                        cell.setValue(e);
                        value = e;
                    }
                }
                if (value instanceof ParserException) {
                    throw (ParserException)value;
                }
                return (Number)cell.getValue();
            }
            if (type == 1) {
                return (Number)cell.getValue();
            }
            return new Float(0.0f);
        }
        throw new ParserException("#REFS?");
    }

    public boolean isFormula(int aRow, int aColumn) {
        Cell temp = this.getCellAt(aRow, aColumn);
        return temp != null && temp.getType() == 2;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    public Class getColumnClass(int c) {
        return Cell.class;
    }

    private boolean isLoop(CellPoint cell) {
        return this.isLoop(cell, new TreeSet());
    }

    private boolean isLoop(CellPoint cell, TreeSet set) {
        if (set.contains(cell)) {
            return true;
        }
        Cell objCell = this.getCellAt(cell.getRow(), cell.getCol());
        if (objCell == null) {
            return false;
        }
        Formula formula = objCell.getFormula();
        if (formula == null) {
            return false;
        }
        set.add(cell);
        for (CellPoint newCell : formula.getDependency()) {
            boolean ret = this.isLoop(newCell, set);
            if (!ret) continue;
            return true;
        }
        set.remove(cell);
        return false;
    }

    public void setModified(boolean modified) {
        this.modified = modified | this.passwordModified;
        this.sharp.checkSaveState();
    }

    public void setPasswordModified(boolean modified) {
        this.passwordModified = modified;
        this.setModified(this.modified);
    }

    public boolean isModified() {
        return this.modified;
    }

    public JTable getTable() {
        return this.sharp.getTable();
    }

    public void setSelection(CellRange sel) {
        JTable table = this.sharp.getTable();
        int maxRow = table.getRowCount() - 1;
        int maxCol = table.getColumnCount() - 1;
        int startRow = sel.getStartRow();
        int startCol = sel.getStartCol();
        int endRow = sel.getEndRow();
        int endCol = sel.getEndCol();
        table.setColumnSelectionInterval(Math.min(startCol, maxCol), Math.min(endCol, maxCol));
        table.setRowSelectionInterval(Math.min(startRow, maxRow), Math.min(endRow, maxRow));
    }

    public boolean isDeletionSafe(CellRange range, boolean byRow) {
        CellRange needCheck;
        int colOff;
        int rowOff;
        if (byRow) {
            rowOff = -range.getHeight();
            colOff = 0;
            if (range.getEndRow() == this.getRowCount() - 1) {
                return true;
            }
            needCheck = new CellRange(range.getEndRow() + 1, this.getRowCount() - 1, SharpTools.baseCol, this.getColumnCount() - 1);
        } else {
            rowOff = 0;
            colOff = -range.getWidth();
            if (range.getEndCol() == this.getColumnCount() - 1) {
                return true;
            }
            needCheck = new CellRange(SharpTools.baseRow, this.getRowCount() - 1, range.getEndCol() + 1, this.getColumnCount() - 1);
        }
        for (int i = needCheck.getStartRow(); i <= needCheck.getEndRow(); ++i) {
            for (int j = needCheck.getStartCol(); j <= needCheck.getEndCol(); ++j) {
                Cell cell = this.getCellAt(i, j);
                if (!cell.isFormula() || Formula.isSafe(cell.getFormula(), rowOff, colOff)) continue;
                Debug.println("relative addresses become invalid");
                return false;
            }
        }
        return true;
    }

    public String toString(CellRange range, boolean byValue) {
        StringBuffer sbf = new StringBuffer();
        for (int i = range.getStartRow(); i <= range.getEndRow(); ++i) {
            for (int j = range.getStartCol(); j <= range.getEndCol(); ++j) {
                if (byValue) {
                    sbf.append(this.getValueAt(i, j));
                } else {
                    Cell cell = this.getCellAt(i, j);
                    if (cell != null) {
                        sbf.append(cell.toString());
                    }
                }
                if (j >= range.getEndCol()) continue;
                sbf.append("\t");
            }
            sbf.append("\n");
        }
        String text = sbf.toString();
        return text;
    }

    public String to_WIMS(CellRange range, boolean byValue, int type) {
        String col_sep;
        String row_sep;
        StringBuffer sbf = new StringBuffer();
        Number n = null;
        String tmp = "";
        String empty_cell = MainApplet.empty_cell;
        if (type == 0) {
            row_sep = ",";
            col_sep = ";";
            sbf.append("[");
        } else if (type == 1) {
            row_sep = ",";
            col_sep = "\n";
        } else {
            row_sep = "\t";
            col_sep = "\n";
        }
        for (int i = range.getStartRow(); i <= range.getEndRow(); ++i) {
            for (int j = range.getStartCol(); j <= range.getEndCol(); ++j) {
                n = null;
                if (this.isFormula(i, j)) {
                    try {
                        n = this.getNumericValueAt(i, j);
                    }
                    catch (ParserException e) {
                        System.out.println("hmmm this should not happen");
                    }
                }
                if (n != null) {
                    sbf.append(n);
                } else if (byValue) {
                    sbf.append(this.getValueAt(i, j));
                } else {
                    Cell cell = this.getCellAt(i, j);
                    if (cell != null) {
                        tmp = cell.toString();
                        if (type == 0) {
                            if (tmp.length() > 0) {
                                sbf.append("\"" + tmp + "\"");
                            } else {
                                sbf.append("\"" + empty_cell + "\"");
                            }
                        } else if (tmp.length() > 0) {
                            sbf.append(tmp);
                        } else {
                            sbf.append(empty_cell);
                        }
                    }
                }
                if (j >= range.getEndCol()) continue;
                sbf.append(row_sep);
            }
            if (i >= range.getEndRow()) continue;
            sbf.append(col_sep);
        }
        if (type == 0) {
            sbf.append("]");
        }
        String text = sbf.toString();
        return text;
    }

    void fromString(String text, int rowOff, int colOff, CellRange range) {
        try {
            BufferedReader in = new BufferedReader(new StringReader(text));
            for (int row = range.getStartRow(); row <= range.getEndRow(); ++row) {
                String line = in.readLine();
                int prev = 0;
                for (int col = range.getStartCol(); col <= range.getEndCol(); ++col) {
                    int index = line.indexOf(9, prev);
                    String value = index >= 0 ? line.substring(prev, index) : line.substring(prev);
                    if (value.startsWith("=")) {
                        value = (value = Formula.fixRelAddr(value.substring(1), rowOff, colOff)) == null ? new String("=$REFS$0") : "=" + value;
                    }
                    this.doSetValueAt(value, row, col);
                    prev = index + 1;
                    if (index != -1) continue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.toString(new CellRange(SharpTools.baseRow, this.getRowCount() - 1, SharpTools.baseCol, this.getColumnCount() - 1), false);
    }

    public String toWIMS(int type) {
        return this.to_WIMS(new CellRange(SharpTools.baseRow, this.getRowCount() - 1, SharpTools.baseCol, this.getColumnCount() - 1), false, type);
    }

    public static CellPoint getSize(String input) {
        BufferedReader in = new BufferedReader(new StringReader(input));
        int rowcount = 0;
        int colcount = 0;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                int index;
                ++rowcount;
                int prev = 0;
                int col = 0;
                do {
                    index = line.indexOf(9, prev);
                    prev = index + 1;
                    ++col;
                } while (index != -1);
                if (colcount >= col) continue;
                colcount = col;
            }
        }
        catch (Exception e) {
            return null;
        }
        return new CellPoint(rowcount, colcount);
    }

    public void sort(CellRange area, int primary, int second, boolean isRow, boolean ascend, boolean tiebreaker) {
        CellRange temp;
        int i;
        SharpClipboard[] data;
        if (isRow) {
            data = new SharpClipboard[area.getWidth()];
            for (i = 0; i < data.length; ++i) {
                temp = new CellRange(area.getStartRow(), area.getEndRow(), area.getStartCol() + i, area.getStartCol() + i);
                data[i] = new SharpClipboard(this, temp, false);
            }
        } else {
            data = new SharpClipboard[area.getHeight()];
            for (i = 0; i < data.length; ++i) {
                temp = new CellRange(area.getStartRow() + i, area.getStartRow() + i, area.getStartCol(), area.getEndCol());
                data[i] = new SharpClipboard(this, temp, false);
            }
        }
        int[] indices = this.internalSort(area, primary, second, isRow, ascend, tiebreaker);
        if (isRow) {
            for (int i2 = area.getStartCol(); i2 <= area.getEndCol(); ++i2) {
                CellPoint point = new CellPoint(area.getStartRow(), i2);
                int y = i2 - area.getStartCol();
                data[indices[y] - area.getStartCol()].paste(this, point);
            }
        } else {
            for (int i3 = area.getStartRow(); i3 <= area.getEndRow(); ++i3) {
                CellPoint point = new CellPoint(i3, area.getStartCol());
                int y = i3 - area.getStartRow();
                data[indices[y] - area.getStartRow()].paste(this, point);
            }
        }
    }

    private int compareLines(int primary, boolean isRow, boolean ascending, int i, int j) {
        Cell x = this.getCriteria(primary, i, isRow);
        Cell y = this.getCriteria(primary, j, isRow);
        return x.compare(y, ascending);
    }

    private Cell getCriteria(int interest, int i, boolean isRow) {
        if (isRow) {
            return this.getCellAt(interest, i);
        }
        return this.getCellAt(i, interest);
    }

    private boolean rightOrder(int primary, int second, boolean isRow, int i, int j, boolean ascend, boolean order) {
        int result = this.compareLines(primary, isRow, ascend, i, j);
        if (result == 0) {
            result = this.compareLines(second, isRow, order, i, j);
            if (order) {
                return result < 0;
            }
            return result > 0;
        }
        if (ascend) {
            return result < 0;
        }
        return result > 0;
    }

    private int[] internalSort(CellRange area, int primary, int second, boolean isRow, boolean ascend, boolean tiebreaker) {
        int i;
        int[] index;
        if (isRow) {
            index = new int[area.getWidth()];
            for (i = 0; i < index.length; ++i) {
                index[i] = i + area.getStartCol();
            }
        } else {
            index = new int[area.getHeight()];
            for (i = 0; i < index.length; ++i) {
                index[i] = i + area.getStartRow();
            }
        }
        for (int p = 1; p < index.length; ++p) {
            int tmp = index[p];
            for (int j = p; j > 0 && this.rightOrder(primary, second, isRow, tmp, index[j - 1], ascend, tiebreaker); --j) {
                index[j] = index[j - 1];
            }
            index[j] = tmp;
        }
        return index;
    }

    public boolean isEmptyCell(int row, int col) {
        return this.getCellAt(row, col).getValue().equals("");
    }
}

