---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, légendes, tableaux, tables,
              position de la légende
---

# Comment placer une légende à côté d'une figure ?

## Avec un changement d'orientation de la légende

Cette première solution est détaillée à la question 
"[](/3_composition/flottants/legendes/changer_l_orientation_d_une_legende)".


## Sans changement d'orientation de la légende

Dans ce cas, il est possible de s'inspirer de la référence ci-dessus, 
et utiliser `minipage`. La commande `\caption` est placée à l'intérieur 
d'une `minipage`. Par exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Du texte... Du texte... Du texte...
Du texte... Du texte... Du texte...
Du texte... Du texte... Du texte...

\begin{table}[!ht]
  \begin{minipage}{3cm}
    \caption{La légende, placée à côté du
    tableau, avec une largeur fixée.}\label{test}
  \end{minipage}
  \centerline{%
  \begin{tabular}{|c|}
    \hline
    Un petit tableau \\
    Avec quelques lignes \\
    Pour voir comment \\
    est placée la légende.\\
    \hline
  \end{tabular}}
\end{table}

Du texte... Du texte... Du texte...
Du texte... Du texte... Du texte...
Du texte... Du texte... Du texte...

Et pour finir, une référence au tableau \ref{test}.
\end{document}
```