# `systemd-zram-setup@.service` generator for zram devices

<a href="https://repology.org/project/zram-generator/versions">
    <img align="right" src="https://repology.org/badge/vertical-allrepos/zram-generator.svg?exclude_sources=site&exclude_unsupported=1" alt="Packaging status">
</a>

This generator provides a simple and fast mechanism to configure swap on `/dev/zram*` devices.

The main use case is create **swap** devices, but devices with a file system can be created too, see below.

### Configuration

A default config file may be located in /usr.
This generator checks the following locations:
* `/run/systemd/zram-generator.conf`
* `/etc/systemd/zram-generator.conf`
* `/usr/local/lib/systemd/zram-generator.conf`
* `/usr/lib/systemd/zram-generator.conf`

… and the first file found in that list wins.

In addition, "drop-ins" will be loaded from `.conf` files in
`/etc/systemd/zram-generator.conf.d/`,
`/usr/lib/systemd/zram-generator.conf.d/`, etc.

The main configuration file is read before any of the drop-ins and has
the lowest precedence; entries in the drop-in files override entries
in the main configuration file.

See systemd.unit(5) for a detailed description of this logic.

See `zram-generator.conf.example` for a list of available settings.

### Swap devices

Create `/etc/systemd/zram-generator.conf`:

```ini
# /etc/systemd/zram-generator.conf
[zram0]
zram-size = ram / 2
```

A zram device will be created for each section. No actual
configuration is necessary (the default of `zram-size = min(ram / 2, 4096)` will be
used unless overriden), but the configuration file with at least one
section must exist.

### Mount points

```ini
# /etc/systemd/zram-generator.conf
[zram1]
mount-point = /var/compressed
```

This will set up a /dev/zram1 with ext2 and generate a mount unit for /var/compressed.

In case you want this path to be user-writable, since util-linux v2.39 you can use
```ini
[zram1]
options = X-mount.mode=1777
```
(and/or the relevant `X.mount.{owner,group}=` arguments, cf. mount(8)).

Otherwise, you can use the following "high-quality hack":
for the above example, create an
override for `systemd-zram-setup@zram1.service`, for example with `systemctl edit`,
containing the following (note the sticky bit as required for [/var]/tmp):

```ini
[Service]
ExecStartPost=/bin/sh -c 'd=$(mktemp -d); mount "$1" "$d"; chmod 1777 "$d"; umount "$d"; rmdir "$d"' _ /dev/%i
```

### Rust

The second purpose of this program is to serve as an example of a systemd
generator in rust.

### Installation

It is recommended to use an existing package:

* Fedora: `sudo dnf install zram-generator-defaults` (or `sudo dnf install zram-generator` to install without the default configuration)
* Debian: packages provided by nabijaczleweli, see https://debian.nabijaczleweli.xyz/README.
* Arch: `sudo pacman -S zram-generator` (or https://aur.archlinux.org/packages/zram-generator-git/ for the latest git commit)

To install directly from sources, execute `make build && sudo make install NOBUILD=true`:
* `zram-generator` binary is installed in the systemd system generator directory (usually `/usr/lib/systemd/system-generators/`)
* `zram-generator(8)` and `zram-generator.conf(5)` manpages are installed into `/usr/share/man/manN/`, this requires [`ronn`](https://github.com/apjanke/ronn-ng).
* `units/systemd-zram-setup@.service` is copied into the systemd system unit directory (usually `/usr/lib/systemd/system/`)
* `zram-generator.conf.example` is copied into `/usr/share/doc/zram-generator/`
You need though create your own config file at one of the locations listed above.

To install and configure with puppet [puppet-zram_generator](https://github.com/voxpupuli/puppet-zram_generator) is available.

#### tl;dr

- Install `zram-generator` using one of the methods listed above.
- Create a `zram-generator.conf` config file.
- Run `systemctl daemon-reload` to create new device units.
- Run `systemctl start /dev/zram0` (adjust the name as appropriate to match the config).
- Call `zramctl` or `swapon` to confirm that the device has been created and is in use.

Once installed and configured, the generator will be invoked by systemd early at boot,
there is no need to do anything else.

### Testing

The tests require either the `zram` module to be loaded, or root to run `modprobe zram`.

Set the `ZRAM_GENERATOR_ROOT` environment variable to use that
instead of `/` as root.

The "{generator}" template in `units/systemd-zram-setup@.service.d/binary-location.conf`
can be substituted for a non-standard location of the binary for testing.

### Authors

Written by Zbigniew Jędrzejewski-Szmek &lt;<zbyszek@in.waw.pl>&gt;,
Igor Raits &lt;<i.gnatenko.brain@gmail.com>&gt;, наб &lt;<nabijaczleweli@nabijaczleweli.xyz>&gt;, and others.
See https://github.com/systemd/zram-generator/graphs/contributors for the full list.
