/* 
*  Copyright (C) Nicola Fragale <nicolafragale@gmail.com> 
*
*  This program is free software; you can redistribute it and/or modify 
*  it under the terms of the GNU General Public License as published by 
*  the Free Software Foundation; either version 2 of the License, or 
*  (at your option) any later version. 
*
*  This program is distributed in the hope that it will be useful, 
*  but WITHOUT ANY WARRANTY; without even the implied warranty of 
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
*  GNU General Public License for more details. 
*
*  You should have received a copy of the GNU General Public License 
*  along with this program; if not, write to the Free Software 
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
*/ 

#ifndef _TRASH_VIEW_H__
#define _TRASH_VIEW_H__


#include <glib.h>
#include <gtk/gtk.h>

#include "libral.h"
#include "view.h"

G_BEGIN_DECLS


#define RUBRICA_TRASH_VIEW_TYPE           (rubrica_trash_view_get_type())

#define RUBRICA_TRASH_VIEW(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj), \
                                           RUBRICA_TRASH_VIEW_TYPE,          \
                                           RubricaTrashView))

#define RUBRICA_TRASH_VIEW_CLASS(kls)     (G_TYPE_CHECK_CLASS_CAST((kls),    \
                                           RUBRICA_TRASH_VIEW_TYPE,          \
                                           RubricaTrashViewClass))

#define IS_RUBRICA_TRASH_VIEW(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
                                           RUBRICA_TRASH_VIEW_TYPE))

#define IS_RUBRICA_TRASH_VIEW_CLASS(kls)  (G_TYPE_INSTANCE_GET_CLASS((kls),  \
                                           RUBRICA_TRASH_VIEW_TYPE))

#define RUBRICA_TRASH_VIEW_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS(kls),   \
                                           RUBRICA_TRASH_VIEW_TYPE,          \
                                           RubricaTrashViewClass)


typedef enum {
  TRASH_ID,              /* card's id, hidden column */
  TRASH_ADDRESSBOOK,     /* addressbook that owns the card, hidden  column */
  TRASH_CARD_LABEL,      /* card's label          */
  TRASH_LN_COMPANY,      /* (last | company) name */
  TRASH_WEB,             
  TRASH_EMAIL,
  TRASH_PHONE,
  TRASH_LAST_COLUMN
} RubricaTrashColumns;


typedef struct _RubricaTrashView        RubricaTrashView;
typedef struct _RubricaTrashViewClass   RubricaTrashViewClass;
typedef struct _RubricaTrashViewPrivate RubricaTrashViewPrivate;


struct _RubricaTrashView 
{
  RubricaView  parent;
  
  RubricaTrashViewPrivate* priv;
};


struct _RubricaTrashViewClass
{
  RubricaViewClass parent_class;  
};


GType rubrica_trash_view_get_type      (void);


GtkWidget* rubrica_trash_view_new     (void);
void rubrica_trash_view_free          (RubricaTrashView* view);
 
void rubrica_trash_view_add_card      (RubricaTrashView* view, RAbook* book,
				       RCard* card);
void rubrica_trash_view_recovery_card (RubricaTrashView* view);
void rubrica_trash_view_destroy_card  (RubricaTrashView* view);

void rubrica_trash_view_empty_trash   (RubricaTrashView* view);


G_END_DECLS

#endif
