// rTorrent - BitTorrent client
// Copyright (C) 2005-2011, Jari Sundell
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// In addition, as a special exception, the copyright holders give
// permission to link the code of portions of this program with the
// OpenSSL library under certain conditions as described in each
// individual source file, and distribute linked combinations
// including the two.
//
// You must obey the GNU General Public License in all respects for
// all of the code used other than OpenSSL.  If you modify file(s)
// with this exception, you may extend this exception to your version
// of the file(s), but you are not obligated to do so.  If you do not
// wish to do so, delete this exception statement from your version.
// If you delete this exception statement from all source files in the
// program, then also delete it here.
//
// Contact:  Jari Sundell <jaris@ifi.uio.no>
//
//           Skomakerveien 33
//           3185 Skoppum, NORWAY

#ifndef RTORRENT_RPC_EXEC_FILE_H
#define RTORRENT_RPC_EXEC_FILE_H

#include <torrent/object.h>

namespace rpc {

class ExecFile {
public:
  static const unsigned int max_args    = 128;
  static const unsigned int buffer_size = 4096;
    
  static const int flag_expand_tilde = 0x1;
  static const int flag_throw        = 0x2;
  static const int flag_capture      = 0x4;
  static const int flag_background   = 0x8;

  ExecFile() : m_logFd(-1) {}

  int                 log_fd() const     { return m_logFd; }
  void                set_log_fd(int fd) { m_logFd = fd; }

  int                 execute(const char* file, char* const* argv, int flags);

  torrent::Object     execute_object(const torrent::Object& rawArgs, int flags);
  
private:
  int                 m_logFd;
  std::string         m_capture;
};

}

#endif
