//light.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2008-2014
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _LIGHT_H_
#define _LIGHT_H_

#include <roaraudio.h>

#ifndef ROAR_WITHOUT_DCOMP_LIGHT

#define LIGHT_CHANNELS_DEFAULT 512 /* one DMX Universe */
#define MAX_EVENTS_PER_CYCLE   16  /* this*cfreq is event thruput (16*100Hz = 1.6kEvents/s) */

extern struct light_state {
 unsigned int    channels;
 uint8_t events[MAX_EVENTS_PER_CYCLE];
 size_t eventsqueuelen;
 uint8_t * state;
 uint8_t * changes;
} g_light_state;

extern struct light_mixer {
 int stream;
} g_light_mixer;

int light_init  (uint32_t channels);
int light_free  (void);

int light_update(void);
int light_reset (void);
int light_reinit(void);

int light_check_stream  (int id);
int light_send_stream   (int id);

// for plugins:
int     light_dmxchannel_get(size_t index);
int     light_dmxchannel_set(size_t index, uint8_t val);
ssize_t light_dmxchannel_num(void);
int     light_dmxchannel_swap_universe(uint8_t * universe, size_t len);

int light_dmxevent_add(const uint8_t * events, size_t len);
int light_dmxevent_read(const uint8_t ** events, size_t * len);
#define light_dmxevent_addone(event) light_dmxevent_add(&(uint8_t){(event)}, 1)

// codec filters:
int cf_light_roardmx_read(int id, struct roar_stream_server * ss);
int cf_light_roardmx_write(int id, struct roar_stream_server * ss);

#endif

#endif

//ll
