//protocol-discard.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2011-2014
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include <roaraudio.h>

static int _handle(int client, struct roar_vio_calls * vio, struct roar_buffer ** obuffer, void ** userdata, const struct roar_keyval * protopara, ssize_t protoparalen, struct roar_dl_librarypara * pluginpara) {
 char buf[4096];

 (void)client, (void)obuffer, (void)userdata, (void)protopara, (void)protoparalen, (void)pluginpara;

 if ( roar_vio_read(vio, buf, sizeof(buf)) < 1 ) {
  return -1;
 }

 return 0;
}

static const struct roar_dl_proto proto = {
 .proto = ROAR_PROTO_DISCARD,
 .description = "Discard all data send to the server",
 .flags = ROAR_DL_PROTO_FLAGS_NONE,
 .set_proto = NULL,
 .unset_proto = NULL,
 .handle = _handle,
 .flush = NULL,
 .flushed = NULL,
 .status = NULL
};

static int __reg_proto(struct roar_dl_librarypara * para, struct roar_dl_libraryinst * lib) {
 (void)para, (void)lib;
 ROAR_DL_PLUGIN_REG_FN(ROAR_DL_PROTO_SUBTYPE, proto, ROAR_DL_PROTO_VERSION);
 return 0;
}

ROAR_DL_PLUGIN_START(protocol_discard) {
 ROAR_DL_PLUGIN_META_PRODUCT_NIV("protocol-discard", ROAR_VID_ROARAUDIO, ROAR_VNAME_ROARAUDIO);
 ROAR_DL_PLUGIN_META_VERSION(ROAR_VERSION_STRING);
 ROAR_DL_PLUGIN_META_LICENSE_TAG(GPLv3_0);
 ROAR_DL_PLUGIN_META_CONTACT_FLNE("Philipp", "Schafft", "ph3-der-loewe", "lion@lion.leolix.org");
 ROAR_DL_PLUGIN_META_DESC("Implementation of a dummy protocol discarding all data");

 ROAR_DL_PLUGIN_REG(ROAR_DL_FN_PROTO, __reg_proto);
} ROAR_DL_PLUGIN_END

//ll
