//playback.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2008-2014
 *
 *  The code (may) include prototypes and comments (and maybe
 *  other code fragements) from the yiff sound system.
 *  According to the debian/copyright file upstream author is
 *  Tara Milana <learfox@twu.net>. Also copyright is listed as:
 *  Copyright (C)  1997-2003 WolfPack Entertainment
 *
 *  This file is part of libroaryiff a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroaryiff is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 * NOTE: code fragments (like prototypes) taken from the yiff package
 *       are 'GPLv2 or later' and are upgraded to GPLv3 by being used
 *       within this document.
 *
 */

#include <libroaryiff.h>

#define BUFFERSIZE  8192

#ifdef ROAR_HAVE_IO_POSIX
#define _CAN_OPERATE
#endif

YID YStartPlaySoundObjectSimple (YConnection *con, const char *path) {
 return YStartPlaySoundObject(con, path, NULL);
}

static inline ssize_t _file_play  (struct roar_connection * con, const char * file, struct roar_stream * s) {
#ifdef _CAN_OPERATE
 int codec = -1;
 int in, out = -1;
 ssize_t r = 0;
 int seek;
 int len;
 char buf[BUFFERSIZE];
 int rate = ROAR_RATE_DEFAULT, channels = ROAR_CHANNELS_DEFAULT, bits = ROAR_BITS_DEFAULT;

 // FIXME: check error cases

 ROAR_DBG("roar_file_play_full(*) = ?");

#ifdef ROAR_TARGET_WIN32
 if ( (in = open(file, O_RDONLY|O_BINARY, 0644)) == -1 ) {
#else
 if ( (in = open(file, O_RDONLY, 0644)) == -1 ) {
#endif
  roar_err_from_errno();
  return -1;
 }

 if ((len = read(in, buf, BUFFERSIZE)) < 1) {
  roar_err_from_errno();
  close(in);
  return -1;
 }

 codec = roar_file_codecdetect(buf, len);

 ROAR_DBG("roar_file_play_full(*): codec=%i(%s)", codec, roar_codec2str(codec));

 seek = lseek(in, 0, SEEK_SET) == (off_t) -1 ? 0 : 1;

 if ( codec == -1 ) {
  ROAR_WARN("roar_file_play_full(*): Unknown codec of file: %s", file);
  close(in);
  roar_err_set(ROAR_ERROR_BADMAGIC);
  return -1;
 }

 if ( !seek ) {
  ROAR_WARN("roar_file_play_full(*): passfh on non seekable file: this may produce incorrect playback");
  close(in);
  roar_err_set(ROAR_ERROR_NOSEEK);
  return -1;
 }

 if ( roar_stream_new(s, rate, channels, bits, codec) == -1 ) {
  close(in);
  return -1;
 }

 if ( roar_stream_connect(con, s, ROAR_DIR_PLAY, -1) == -1 ) {
  close(in);
  return -1;
 }

 if ( roar_stream_passfh(con, s, in) == -1 ) {
  close(in);
  roar_kick(con, ROAR_OT_STREAM, roar_stream_get_id(s));
  return -1;
 }

 close(out);
 close(in);
 return 0;

 return r;
#else
 roar_err_set(ROAR_ERROR_NOSYS);
 return -1;
#endif
}

YID YStartPlaySoundObject (YConnection *con, const char *path, YEventSoundPlay *value) {
 struct roar_connection rcon;
 struct roar_stream     stream[1];

 if ( con == NULL )
  return YIDNULL;

 if ( path == NULL )
  return YIDNULL;

 roar_connect_fh(&rcon, con->fd);

 // hm,... find out how to do this.
 // need to start ssize_t roar_file_play (struct roar_connection * con, char * file, int exec)
 // in background

 if ( _file_play(&rcon, path, stream) == -1 ) {
  ROAR_ERR("Can not start playback");
  return YIDNULL;
 }

 return con->prev_generated_yid = ROARYIFF_ROAR2YID(stream->id);
}

void YDestroyPlaySoundObject(YConnection *con, YID yid) {
 struct roar_connection rcon;

 if ( !con )
  return ;

 if ( yid == YIDNULL )
  return;

 roar_connect_fh(&rcon, con->fd);

 roar_kick(&rcon, ROAR_OT_STREAM, ROARYIFF_YID2ROAR(yid));
}

//ll
