#include "rheolef.h"
using namespace std;
using namespace rheolef;
#include "sphere.icc"
int main (int argc, char**argv) {
  environment rheolef(argc, argv);
  geo lambda (argv[1]);
  size_t d = lambda.dimension();
  space Xh (lambda, "P1");
  field phi_h = interpolate(Xh, phi);
  band gamma_h (phi_h);
  space Bh (gamma_h.band(), "P1");
  trial u (Bh); test v (Bh);
  form  a  = integrate (gamma_h, u*v + dot(grad_s(u),grad_s(v)));
  field lh = integrate (gamma_h, f(d)*v);
  field uh (Bh,0);
  size_t max_iter = 10000;
  Float tol = 1e-10;
  pminres (a.uu(), uh.set_u(), lh.u(), eye(), max_iter, tol, &derr);
  dout << catchmark("phi") << phi_h
       << catchmark("u")   << uh;
}
